/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.events;

import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3545;
import net.minecraft.class_3610;
import twilightforest.TFConfig;
import twilightforest.TwilightForestMod;
import twilightforest.block.KeepsakeCasketBlock;
import twilightforest.block.entity.KeepsakeCasketBlockEntity;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.entity.CharmEffect;
import twilightforest.enums.BlockLoggingEnum;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFEntities;
import twilightforest.init.TFItems;
import twilightforest.init.TFSounds;
import twilightforest.init.TFStats;
import twilightforest.util.TFItemStackUtils;

public class CharmEvents {
    public static final String CHARM_INV_TAG = "TFCharmInventory";
    private static boolean casketExpiration = false;
    public static class_1799 charmUsed;

    public static void init() {
        ServerPlayerEvents.AFTER_RESPAWN.register(CharmEvents::onPlayerRespawn);
        class_2960 late = TwilightForestMod.prefix("late");
        ServerPlayerEvents.ALLOW_DEATH.addPhaseOrdering(Event.DEFAULT_PHASE, late);
        ServerPlayerEvents.ALLOW_DEATH.register(late, CharmEvents::applyDeathItems);
    }

    public static boolean applyDeathItems(class_3222 player, class_1282 damageSource, float damageAmount) {
        if (player.method_14220().method_8608() || player.getClass() != class_3222.class || player.method_7337() || player.method_7325()) {
            return true;
        }
        if (CharmEvents.charmOfLife((class_1657)player)) {
            return false;
        }
        if (!player.method_14220().method_8450().method_8355(class_1928.field_19389)) {
            CharmEvents.charmOfKeeping((class_1657)player);
            CharmEvents.keepsakeCasket((class_1657)player);
        }
        return true;
    }

    public static void onPlayerRespawn(class_3222 oldPlayer, class_3222 newPlayer, boolean alive) {
        if (!alive) {
            if (casketExpiration) {
                newPlayer.method_43496((class_2561)class_2561.method_43471((String)"block.twilightforest.casket.broken").method_27692(class_124.field_1061));
                casketExpiration = false;
            }
            CharmEvents.returnStoredItems((class_1657)newPlayer);
        }
    }

    private static boolean charmOfLife(class_1657 player) {
        boolean charm1;
        boolean charm2 = TFItemStackUtils.consumeInventoryItem(player, (class_1792)TFItems.CHARM_OF_LIFE_2.get()) || CharmEvents.hasCharmCurio((class_1792)TFItems.CHARM_OF_LIFE_2.get(), player);
        boolean bl = charm1 = !charm2 && (TFItemStackUtils.consumeInventoryItem(player, (class_1792)TFItems.CHARM_OF_LIFE_1.get()) || CharmEvents.hasCharmCurio((class_1792)TFItems.CHARM_OF_LIFE_1.get(), player));
        if (charm2 || charm1) {
            if (charm1) {
                player.method_6033(8.0f);
                player.method_6092(new class_1293(class_1294.field_5924, 100, 0));
            }
            if (charm2) {
                player.method_6033(player.method_6063());
                player.method_6092(new class_1293(class_1294.field_5924, 600, 3));
                player.method_6092(new class_1293(class_1294.field_5907, 600, 0));
                player.method_6092(new class_1293(class_1294.field_5918, 600, 0));
            }
            CharmEffect effect = new CharmEffect((class_1299<? extends CharmEffect>)((class_1299)TFEntities.CHARM_EFFECT.get()), player.method_37908(), (class_1309)player, charm1 ? (class_1792)TFItems.CHARM_OF_LIFE_1.get() : (class_1792)TFItems.CHARM_OF_LIFE_2.get());
            player.method_37908().method_8649((class_1297)effect);
            CharmEffect effect2 = new CharmEffect((class_1299<? extends CharmEffect>)((class_1299)TFEntities.CHARM_EFFECT.get()), player.method_37908(), (class_1309)player, charm1 ? (class_1792)TFItems.CHARM_OF_LIFE_1.get() : (class_1792)TFItems.CHARM_OF_LIFE_2.get());
            effect2.offset = (float)Math.PI;
            player.method_37908().method_8649((class_1297)effect2);
            player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), (class_3414)TFSounds.CHARM_LIFE.get(), player.method_5634(), 1.0f, 1.0f);
            if (player instanceof class_3222) {
                player.method_7281((class_2960)TFStats.LIFE_CHARMS_ACTIVATED.get());
            }
            return true;
        }
        return false;
    }

    private static void charmOfKeeping(class_1657 player) {
        int i;
        boolean tier3 = TFItemStackUtils.consumeInventoryItem(player, (class_1792)TFItems.CHARM_OF_KEEPING_3.get()) || CharmEvents.hasCharmCurio((class_1792)TFItems.CHARM_OF_KEEPING_3.get(), player);
        boolean tier2 = tier3 || TFItemStackUtils.consumeInventoryItem(player, (class_1792)TFItems.CHARM_OF_KEEPING_2.get()) || CharmEvents.hasCharmCurio((class_1792)TFItems.CHARM_OF_KEEPING_2.get(), player);
        boolean tier1 = tier2 || TFItemStackUtils.consumeInventoryItem(player, (class_1792)TFItems.CHARM_OF_KEEPING_1.get()) || CharmEvents.hasCharmCurio((class_1792)TFItems.CHARM_OF_KEEPING_1.get(), player);
        class_1661 keepInventory = new class_1661(null);
        class_2499 tagList = new class_2499();
        if (tier1) {
            CharmEvents.keepWholeList((class_2371<class_1799>)keepInventory.field_7548, (class_2371<class_1799>)player.method_31548().field_7548);
            CharmEvents.keepWholeList((class_2371<class_1799>)keepInventory.field_7544, (class_2371<class_1799>)player.method_31548().field_7544);
        }
        if (tier3) {
            CharmEvents.keepWholeList((class_2371<class_1799>)keepInventory.field_7547, (class_2371<class_1799>)player.method_31548().field_7547);
            charmUsed = new class_1799((class_1935)TFItems.CHARM_OF_KEEPING_3.get());
        } else if (tier2) {
            for (i = 0; i < 9; ++i) {
                keepInventory.field_7547.set(i, (Object)((class_1799)player.method_31548().field_7547.get(i)).method_7972());
                player.method_31548().field_7547.set(i, (Object)class_1799.field_8037);
            }
            charmUsed = new class_1799((class_1935)TFItems.CHARM_OF_KEEPING_2.get());
        } else if (tier1) {
            i = player.method_31548().field_7545;
            if (class_1661.method_7380((int)i)) {
                keepInventory.field_7547.set(i, (Object)((class_1799)player.method_31548().field_7547.get(i)).method_7972());
                player.method_31548().field_7547.set(i, (Object)class_1799.field_8037);
            }
            charmUsed = new class_1799((class_1935)TFItems.CHARM_OF_KEEPING_1.get());
        }
        for (i = 0; i < player.method_31548().field_7547.size(); ++i) {
            class_1799 stack = (class_1799)player.method_31548().field_7547.get(i);
            if (!stack.method_31573(ItemTagGenerator.KEPT_ON_DEATH)) continue;
            keepInventory.field_7547.set(i, (Object)stack.method_7972());
            player.method_31548().field_7547.set(i, (Object)class_1799.field_8037);
        }
        for (i = 0; i < player.method_31548().field_7548.size(); ++i) {
            class_1799 armor = (class_1799)player.method_31548().field_7548.get(i);
            if (!armor.method_31573(ItemTagGenerator.KEPT_ON_DEATH)) continue;
            keepInventory.field_7548.set(i, (Object)armor.method_7972());
            player.method_31548().field_7548.set(i, (Object)class_1799.field_8037);
        }
        if (((class_1799)player.method_31548().field_7544.get(0)).method_31573(ItemTagGenerator.KEPT_ON_DEATH)) {
            keepInventory.field_7544.set(0, (Object)((class_1799)player.method_31548().field_7544.get(0)).method_7972());
            player.method_31548().field_7544.set(0, (Object)class_1799.field_8037);
        }
        if (!keepInventory.method_5442()) {
            keepInventory.method_7384(tagList);
            CharmEvents.getPlayerData(player).method_10566(CHARM_INV_TAG, (class_2520)tagList);
        }
    }

    private static void keepsakeCasket(class_1657 player) {
        TFItemStackUtils.damage = 0;
        boolean casketConsumed = TFItemStackUtils.consumeInventoryItem(player, ((KeepsakeCasketBlock)TFBlocks.KEEPSAKE_CASKET.get()).method_8389());
        if (casketConsumed) {
            class_1937 level = player.method_5770();
            class_2338.class_2339 pos = player.method_24515().method_25503();
            if (pos.method_10264() < level.method_8597().comp_651() + 2) {
                pos.method_33098(level.method_8597().comp_651() + 2);
            } else {
                int logicalHeight = player.method_5770().method_8597().comp_653();
                if (pos.method_10264() > logicalHeight) {
                    pos.method_33098(logicalHeight - 1);
                }
            }
            pos.method_10100(0, -1, 0);
            do {
                pos.method_10100(0, 1, 0);
            } while (!level.method_8320((class_2338)pos).method_26207().method_15800());
            class_2338 immutablePos = pos.method_10062();
            class_3610 fluidState = level.method_8316(immutablePos);
            if (level.method_8501(immutablePos, (class_2680)((class_2680)((class_2680)((KeepsakeCasketBlock)TFBlocks.KEEPSAKE_CASKET.get()).method_9564().method_11657(BlockLoggingEnum.MULTILOGGED, (Comparable)((Object)BlockLoggingEnum.getFromFluid(fluidState.method_15772())))).method_11657((class_2769)KeepsakeCasketBlock.BREAKAGE, (Comparable)Integer.valueOf(TFItemStackUtils.damage))).method_11657((class_2769)KeepsakeCasketBlock.FACING, (Comparable)class_2350.method_10139((int)level.method_8409().method_43048(3))))) {
                class_2586 te = level.method_8321(immutablePos);
                if (te instanceof KeepsakeCasketBlockEntity) {
                    KeepsakeCasketBlockEntity casket = (KeepsakeCasketBlockEntity)te;
                    casket.playeruuid = (Boolean)TFConfig.COMMON_CONFIG.casketUUIDLocking.get() != false ? player.method_7334().getId() : null;
                    String modifiedName = player.method_5477().getString().length() > 12 ? player.method_5477().getString().substring(0, 12) : player.method_5477().getString();
                    casket.name = player.method_5477().getString();
                    casket.casketname = modifiedName;
                    casket.method_17488((class_2561)class_2561.method_43470((String)(modifiedName + "'s " + (level.method_8409().method_43048(1000) == 0 ? "Costco Casket" : casket.method_5476().getString()))));
                    int damage = (Integer)level.method_8320(immutablePos).method_11654((class_2769)KeepsakeCasketBlock.BREAKAGE);
                    if (level.method_8409().method_43057() <= 0.15f) {
                        if (damage >= 2) {
                            player.method_31548().method_7388();
                            level.method_8501(immutablePos, class_2246.field_10124.method_9564());
                            casketExpiration = true;
                            TwilightForestMod.LOGGER.debug("{}'s Casket damage value was too high, alerting the player and dropping extra items", (Object)player.method_5477().getString());
                        } else {
                            level.method_8501(immutablePos, (class_2680)((class_2680)((KeepsakeCasketBlock)TFBlocks.KEEPSAKE_CASKET.get()).method_9564().method_11657(BlockLoggingEnum.MULTILOGGED, (Comparable)((Object)BlockLoggingEnum.getFromFluid(fluidState.method_15772())))).method_11657((class_2769)KeepsakeCasketBlock.BREAKAGE, (Comparable)Integer.valueOf(++damage)));
                            TwilightForestMod.LOGGER.debug("{}'s Casket was randomly damaged, applying new damage", (Object)player.method_5477().getString());
                        }
                    }
                    int casketCapacity = casket.method_5439();
                    ArrayList<class_1799> list = new ArrayList<class_1799>(casketCapacity);
                    class_2371 filler = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
                    list.addAll((Collection<class_1799>)TFItemStackUtils.sortArmorForCasket(player));
                    player.method_31548().field_7548.clear();
                    list.addAll((Collection<class_1799>)filler);
                    list.addAll((Collection<class_1799>)player.method_31548().field_7544);
                    player.method_31548().field_7544.clear();
                    list.addAll((Collection<class_1799>)TFItemStackUtils.sortInvForCasket(player));
                    player.method_31548().field_7547.clear();
                    casket.method_11281((class_2371<class_1799>)class_2371.method_10212((Object)class_1799.field_8037, (Object[])list.toArray(new class_1799[casketCapacity])));
                }
            } else {
                TwilightForestMod.LOGGER.error("Could not place Keepsake Casket at " + pos);
            }
        }
    }

    private static void returnStoredItems(class_1657 player) {
        TwilightForestMod.LOGGER.debug("Player {} ({}) respawned and received items held in storage", (Object)player.method_5477().getString(), (Object)player.method_5667());
        class_2487 playerData = CharmEvents.getPlayerData(player);
        if (!player.method_37908().method_8608() && playerData.method_10545(CHARM_INV_TAG)) {
            class_2499 tagList = playerData.method_10554(CHARM_INV_TAG, 10);
            TFItemStackUtils.loadNoClear(tagList, player.method_31548());
            CharmEvents.getPlayerData(player).method_10554(CHARM_INV_TAG, 10).clear();
            CharmEvents.getPlayerData(player).method_10551(CHARM_INV_TAG);
        }
        if (charmUsed != null) {
            CharmEffect effect = new CharmEffect((class_1299<? extends CharmEffect>)((class_1299)TFEntities.CHARM_EFFECT.get()), player.method_37908(), (class_1309)player, charmUsed.method_7909());
            player.method_37908().method_8649((class_1297)effect);
            CharmEffect effect2 = new CharmEffect((class_1299<? extends CharmEffect>)((class_1299)TFEntities.CHARM_EFFECT.get()), player.method_37908(), (class_1309)player, charmUsed.method_7909());
            effect2.offset = (float)Math.PI;
            player.method_37908().method_8649((class_1297)effect2);
            player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), (class_3414)TFSounds.CHARM_KEEP.get(), player.method_5634(), 1.5f, 1.0f);
            if (player instanceof class_3222) {
                player.method_7281((class_2960)TFStats.KEEPING_CHARMS_ACTIVATED.get());
            }
            charmUsed = null;
        }
    }

    public static class_2487 getPlayerData(class_1657 player) {
        if (!player.getExtraCustomData().method_10545("PlayerPersisted")) {
            player.getExtraCustomData().method_10566("PlayerPersisted", (class_2520)new class_2487());
        }
        return player.getExtraCustomData().method_10562("PlayerPersisted");
    }

    private static void keepWholeList(class_2371<class_1799> transferTo, class_2371<class_1799> transferFrom) {
        for (int i = 0; i < transferFrom.size(); ++i) {
            transferTo.set(i, (Object)((class_1799)transferFrom.get(i)).method_7972());
        }
        transferFrom.clear();
    }

    private static boolean hasCharmCurio(class_1792 item, class_1657 player) {
        List slots;
        if (FabricLoader.getInstance().isModLoaded("trinkets") && !(slots = ((TrinketComponent)player.getComponent(TrinketsApi.TRINKET_COMPONENT)).getEquipped(stack -> stack.method_31574(item))).isEmpty() && !((class_1799)((class_3545)slots.get(0)).method_15441()).method_7960()) {
            ((class_1799)((class_3545)slots.get(0)).method_15441()).method_7934(1);
            return true;
        }
        return false;
    }
}

