/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.events;

import com.mojang.authlib.GameProfile;
import io.github.fabricators_of_create.porting_lib.event.common.ItemCraftedCallback;
import io.github.fabricators_of_create.porting_lib.event.common.LivingEntityEvents;
import java.util.UUID;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1285;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1668;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2190;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2484;
import net.minecraft.class_2549;
import net.minecraft.class_2586;
import net.minecraft.class_2631;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3489;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import twilightforest.TFConfig;
import twilightforest.block.AbstractLightableBlock;
import twilightforest.block.AbstractSkullCandleBlock;
import twilightforest.block.SkullCandleBlock;
import twilightforest.block.WallSkullCandleBlock;
import twilightforest.block.entity.KeepsakeCasketBlockEntity;
import twilightforest.block.entity.SkullCandleBlockEntity;
import twilightforest.entity.projectile.ITFProjectile;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFItems;
import twilightforest.init.TFMobEffects;
import twilightforest.init.TFStats;
import twilightforest.item.FieryArmorItem;
import twilightforest.item.YetiArmorItem;

public class EntityEvents {
    private static final boolean SHIELD_PARRY_MOD_LOADED = FabricLoader.getInstance().isModLoaded("parry");

    public static void init() {
        ItemCraftedCallback.EVENT.register(EntityEvents::onCrafting);
        LivingEntityEvents.ACTUALLY_HURT.register(EntityEvents::entityHurts);
        UseBlockCallback.EVENT.register(EntityEvents::createSkullCandle);
        PlayerBlockBreakEvents.BEFORE.register(EntityEvents::onCasketBreak);
    }

    public static float entityHurts(class_1282 source, class_1309 living, float amount) {
        class_1657 player;
        class_1297 trueSource = source.method_5529();
        if (source instanceof class_1285 && trueSource != null && amount > 0.0f) {
            int fireLevel = EntityEvents.getGearCoverage(living, false) * 5;
            int chillLevel = EntityEvents.getGearCoverage(living, true);
            if (fireLevel > 0 && living.method_6051().method_43048(25) < fireLevel) {
                trueSource.method_5639(fireLevel / 2);
            }
            if (chillLevel > 0 && trueSource instanceof class_1309) {
                class_1309 target = (class_1309)trueSource;
                target.method_6092(new class_1293((class_1291)TFMobEffects.FROSTY.get(), chillLevel * 5 + 5, chillLevel));
            }
        }
        if (source.method_5525().equals("arrow") && trueSource instanceof class_1657 && (player = (class_1657)trueSource).method_5998(player.method_6058()).method_31574((class_1792)TFItems.TRIPLE_BOW.get())) {
            living.field_6008 = 0;
        }
        return amount;
    }

    public static boolean onCasketBreak(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_2586 te) {
        class_2248 block = state.method_26204();
        if (block == TFBlocks.KEEPSAKE_CASKET.get()) {
            UUID checker;
            if (te instanceof KeepsakeCasketBlockEntity) {
                KeepsakeCasketBlockEntity casket = (KeepsakeCasketBlockEntity)te;
                checker = casket.playeruuid;
            } else {
                checker = null;
            }
            if (!(checker == null || ((KeepsakeCasketBlockEntity)te).method_5442() || player.method_5687(3) && player.method_7334().getId().equals(checker))) {
                return false;
            }
        }
        return true;
    }

    public static void onCrafting(class_1657 player, class_1799 itemStack, class_1263 inventory) {
        if (itemStack.method_31574(class_1802.field_8118) && itemStack.method_7947() == 64 && inventory.method_18861(((class_2248)TFBlocks.GIANT_LOG.get()).method_8389()) > 0) {
            player.method_31548().method_7398(new class_1799((class_1935)class_1802.field_8118, 64));
            player.method_31548().method_7398(new class_1799((class_1935)class_1802.field_8118, 64));
            player.method_31548().method_7398(new class_1799((class_1935)class_1802.field_8118, 64));
        }
    }

    public static boolean onParryProjectile(class_1676 projectile, class_239 hitResult) {
        class_1309 entityBlocking;
        class_3966 result;
        class_1297 entity;
        if (!projectile.method_5770().method_8608() && !SHIELD_PARRY_MOD_LOADED && (((Boolean)TFConfig.COMMON_CONFIG.SHIELD_INTERACTIONS.parryNonTwilightAttacks.get()).booleanValue() || projectile instanceof ITFProjectile) && hitResult instanceof class_3966 && (entity = (result = (class_3966)hitResult).method_17782()) instanceof class_1309 && (entityBlocking = (class_1309)entity).method_6039() && entityBlocking.method_6030().method_7935() - entityBlocking.method_6014() <= (Integer)TFConfig.COMMON_CONFIG.SHIELD_INTERACTIONS.shieldParryTicks.get()) {
            projectile.method_7432((class_1297)entityBlocking);
            class_243 rebound = entityBlocking.method_5720();
            projectile.method_7485(rebound.method_10216(), rebound.method_10214(), rebound.method_10215(), 1.1f, 0.1f);
            if (projectile instanceof class_1668) {
                class_1668 hurting = (class_1668)projectile;
                hurting.field_7601 = rebound.method_10216() * 0.1;
                hurting.field_7600 = rebound.method_10214() * 0.1;
                hurting.field_7599 = rebound.method_10215() * 0.1;
            }
            return true;
        }
        return false;
    }

    public static class_1269 createSkullCandle(class_1657 player, class_1937 world, class_1268 hand, class_3965 hitResult) {
        class_2248 class_22482;
        class_1799 stack = player.method_5998(hand);
        class_2338 pos = hitResult.method_17777();
        class_2680 state = world.method_8320(pos);
        if (!((Boolean)TFConfig.COMMON_CONFIG.disableSkullCandles.get()).booleanValue() && stack.method_31573(class_3489.field_26989) && class_2378.field_11142.method_10221((Object)stack.method_7909()).method_12836().equals("minecraft") && !player.method_5715() && (class_22482 = state.method_26204()) instanceof class_2190) {
            class_2190 skull = (class_2190)class_22482;
            if (class_2378.field_11146.method_10221((Object)state.method_26204()).method_12836().equals("minecraft")) {
                class_2484.class_2486 type = (class_2484.class_2486)skull.method_9327();
                boolean wall = state.method_26204() instanceof class_2549;
                switch (type) {
                    case field_11512: {
                        if (wall) {
                            EntityEvents.makeWallSkull(stack, pos, world, (class_2248)TFBlocks.SKELETON_WALL_SKULL_CANDLE.get());
                            break;
                        }
                        EntityEvents.makeFloorSkull(stack, pos, world, (class_2248)TFBlocks.SKELETON_SKULL_CANDLE.get());
                        break;
                    }
                    case field_11513: {
                        if (wall) {
                            EntityEvents.makeWallSkull(stack, pos, world, (class_2248)TFBlocks.WITHER_SKELE_WALL_SKULL_CANDLE.get());
                            break;
                        }
                        EntityEvents.makeFloorSkull(stack, pos, world, (class_2248)TFBlocks.WITHER_SKELE_SKULL_CANDLE.get());
                        break;
                    }
                    case field_11510: {
                        if (wall) {
                            EntityEvents.makeWallSkull(stack, pos, world, (class_2248)TFBlocks.PLAYER_WALL_SKULL_CANDLE.get());
                            break;
                        }
                        EntityEvents.makeFloorSkull(stack, pos, world, (class_2248)TFBlocks.PLAYER_SKULL_CANDLE.get());
                        break;
                    }
                    case field_11508: {
                        if (wall) {
                            EntityEvents.makeWallSkull(stack, pos, world, (class_2248)TFBlocks.ZOMBIE_WALL_SKULL_CANDLE.get());
                            break;
                        }
                        EntityEvents.makeFloorSkull(stack, pos, world, (class_2248)TFBlocks.ZOMBIE_SKULL_CANDLE.get());
                        break;
                    }
                    case field_11507: {
                        if (wall) {
                            EntityEvents.makeWallSkull(stack, pos, world, (class_2248)TFBlocks.CREEPER_WALL_SKULL_CANDLE.get());
                            break;
                        }
                        EntityEvents.makeFloorSkull(stack, pos, world, (class_2248)TFBlocks.CREEPER_SKULL_CANDLE.get());
                        break;
                    }
                    default: {
                        return class_1269.field_5811;
                    }
                }
                if (!player.method_31549().field_7477) {
                    stack.method_7934(1);
                }
                player.method_6104(hand);
                if (player instanceof class_3222) {
                    player.method_7281((class_2960)TFStats.SKULL_CANDLES_MADE.get());
                }
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }

    private static void makeFloorSkull(class_1799 stack, class_2338 pos, class_1937 level, class_2248 newBlock) {
        GameProfile profile = null;
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof class_2631) {
            class_2631 skull = (class_2631)class_25862;
            profile = skull.method_11334();
        }
        level.method_8396(null, pos, class_3417.field_26958, class_3419.field_15245, 1.0f, 1.0f);
        level.method_8501(pos, (class_2680)((class_2680)newBlock.method_9564().method_11657((class_2769)AbstractSkullCandleBlock.LIGHTING, (Comparable)((Object)AbstractLightableBlock.Lighting.NONE))).method_11657((class_2769)SkullCandleBlock.ROTATION, (Comparable)((Integer)level.method_8320(pos).method_11654((class_2769)class_2484.field_11505))));
        level.method_8438((class_2586)new SkullCandleBlockEntity(pos, (class_2680)((class_2680)newBlock.method_9564().method_11657((class_2769)AbstractSkullCandleBlock.LIGHTING, (Comparable)((Object)AbstractLightableBlock.Lighting.NONE))).method_11657((class_2769)SkullCandleBlock.ROTATION, (Comparable)((Integer)level.method_8320(pos).method_11654((class_2769)class_2484.field_11505))), AbstractSkullCandleBlock.candleToCandleColor(stack.method_7909()).getValue(), 1));
        class_25862 = level.method_8321(pos);
        if (class_25862 instanceof SkullCandleBlockEntity) {
            SkullCandleBlockEntity sc = (SkullCandleBlockEntity)class_25862;
            sc.method_11333(profile);
        }
    }

    private static void makeWallSkull(class_1799 stack, class_2338 pos, class_1937 level, class_2248 newBlock) {
        GameProfile profile = null;
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof class_2631) {
            class_2631 skull = (class_2631)class_25862;
            profile = skull.method_11334();
        }
        level.method_8396(null, pos, class_3417.field_26958, class_3419.field_15245, 1.0f, 1.0f);
        level.method_8501(pos, (class_2680)((class_2680)newBlock.method_9564().method_11657((class_2769)AbstractSkullCandleBlock.LIGHTING, (Comparable)((Object)AbstractLightableBlock.Lighting.NONE))).method_11657((class_2769)WallSkullCandleBlock.FACING, (Comparable)((class_2350)level.method_8320(pos).method_11654((class_2769)class_2549.field_11724))));
        level.method_8438((class_2586)new SkullCandleBlockEntity(pos, (class_2680)((class_2680)newBlock.method_9564().method_11657((class_2769)AbstractSkullCandleBlock.LIGHTING, (Comparable)((Object)AbstractLightableBlock.Lighting.NONE))).method_11657((class_2769)WallSkullCandleBlock.FACING, (Comparable)((class_2350)level.method_8320(pos).method_11654((class_2769)class_2549.field_11724))), AbstractSkullCandleBlock.candleToCandleColor(stack.method_7909()).getValue(), 1));
        class_25862 = level.method_8321(pos);
        if (class_25862 instanceof SkullCandleBlockEntity) {
            SkullCandleBlockEntity sc = (SkullCandleBlockEntity)class_25862;
            sc.method_11333(profile);
        }
    }

    public static int getGearCoverage(class_1309 entity, boolean yeti) {
        int amount = 0;
        for (class_1799 armor : entity.method_5661()) {
            if (armor.method_7960() || !(yeti ? armor.method_7909() instanceof YetiArmorItem : armor.method_7909() instanceof FieryArmorItem)) continue;
            ++amount;
        }
        return amount;
    }
}

