/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.init;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2794;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3485;
import net.minecraft.class_3532;
import net.minecraft.class_3773;
import net.minecraft.class_5483;
import net.minecraft.class_5819;
import net.minecraft.class_5847;
import net.minecraft.class_6130;
import net.minecraft.class_6862;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.data.tags.BiomeTagGenerator;
import twilightforest.init.TFEntities;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.world.components.structures.HedgeMazeComponent;
import twilightforest.world.components.structures.HollowHillComponent;
import twilightforest.world.components.structures.HydraLairComponent;
import twilightforest.world.components.structures.QuestGrove;
import twilightforest.world.components.structures.TFStructureComponentTemplate;
import twilightforest.world.components.structures.YetiCaveComponent;
import twilightforest.world.components.structures.courtyard.CourtyardMain;
import twilightforest.world.components.structures.darktower.DarkTowerMainComponent;
import twilightforest.world.components.structures.finalcastle.FinalCastleMainComponent;
import twilightforest.world.components.structures.icetower.IceTowerMainComponent;
import twilightforest.world.components.structures.lichtower.TowerMainComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeRuinsComponent;
import twilightforest.world.components.structures.mushroomtower.MushroomTowerMainComponent;
import twilightforest.world.components.structures.stronghold.StrongholdEntranceComponent;
import twilightforest.world.components.structures.trollcave.TrollCaveMainComponent;
import twilightforest.world.components.structures.util.AdvancementLockedStructure;
import twilightforest.world.components.structures.util.ControlledSpawns;
import twilightforest.world.components.structures.util.DecorationClearance;
import twilightforest.world.components.structures.util.StructureHints;

public class TFLandmark
implements StructureHints,
AdvancementLockedStructure,
DecorationClearance,
ControlledSpawns {
    public static final TFLandmark NOTHING = new TFLandmark(0, "no_feature", false, null, class_5847.field_28922, new class_2960[0]){
        {
            this.enableDecorations().disableStructure();
        }
    };
    public static final TFLandmark SMALL_HILL = new TFLandmark(1, "small_hollow_hill", true, (class_6862)BiomeTagGenerator.VALID_HOLLOW_HILL_BIOMES, class_5847.field_28922, true, new class_2960[0]){
        {
            this.enableDecorations().enableTerrainAlterations();
            this.undergroundDecoAllowed = false;
            this.addMonster((class_1299<? extends class_1309>)class_1299.field_6079, 10, 4, 4).addMonster((class_1299<? extends class_1309>)class_1299.field_6051, 10, 4, 4).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.REDCAP.get()), 10, 4, 4).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.SWARM_SPIDER.get()), 10, 4, 4).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.KOBOLD.get()), 10, 4, 8);
        }

        @Override
        public class_3443 provideFirstPiece(class_3485 structureManager, class_2794 chunkGenerator, class_5819 rand, int x, int y, int z) {
            return new HollowHillComponent((class_3773)TFStructurePieceTypes.TFHill.get(), this, 0, this.size, x - 3, y - 2, z - 3);
        }
    };
    public static final TFLandmark MEDIUM_HILL = new TFLandmark(2, "medium_hollow_hill", true, (class_6862)BiomeTagGenerator.VALID_HOLLOW_HILL_BIOMES, class_5847.field_28922, true, new class_2960[0]){
        {
            this.enableDecorations().enableTerrainAlterations();
            this.undergroundDecoAllowed = false;
            this.addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.REDCAP.get()), 10, 1, 2).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.REDCAP_SAPPER.get()), 1, 1, 2).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.KOBOLD.get()), 10, 2, 4).addMonster((class_1299<? extends class_1309>)class_1299.field_6137, 10, 2, 3).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.SWARM_SPIDER.get()), 10, 2, 4).addMonster((class_1299<? extends class_1309>)class_1299.field_6079, 10, 1, 3).addMonster((class_1299<? extends class_1309>)class_1299.field_6046, 10, 1, 2).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.FIRE_BEETLE.get()), 5, 1, 1).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.SLIME_BEETLE.get()), 5, 1, 1).addMonster((class_1299<? extends class_1309>)class_1299.field_6145, 1, 1, 1);
        }

        @Override
        public class_3443 provideFirstPiece(class_3485 structureManager, class_2794 chunkGenerator, class_5819 rand, int x, int y, int z) {
            return new HollowHillComponent((class_3773)TFStructurePieceTypes.TFHill.get(), this, 0, this.size, x - 7, y - 5, z - 7);
        }
    };
    public static final TFLandmark LARGE_HILL = new TFLandmark(3, "large_hollow_hill", true, (class_6862)BiomeTagGenerator.VALID_HOLLOW_HILL_BIOMES, class_5847.field_28922, true, new class_2960[0]){
        {
            this.enableDecorations().enableTerrainAlterations();
            this.undergroundDecoAllowed = false;
            this.addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.REDCAP.get()), 10, 2, 4).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.REDCAP_SAPPER.get()), 2, 1, 2).addMonster((class_1299<? extends class_1309>)class_1299.field_6137, 10, 2, 3).addMonster((class_1299<? extends class_1309>)class_1299.field_6084, 10, 1, 2).addMonster((class_1299<? extends class_1309>)class_1299.field_6046, 10, 1, 1).addMonster((class_1299<? extends class_1309>)class_1299.field_6091, 1, 1, 1).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.WRAITH.get()), 2, 1, 2).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.FIRE_BEETLE.get()), 10, 1, 2).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.SLIME_BEETLE.get()), 10, 1, 2).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.PINCH_BEETLE.get()), 10, 1, 2).addMonster((class_1299<? extends class_1309>)class_1299.field_6145, 1, 1, 1);
        }

        @Override
        public class_3443 provideFirstPiece(class_3485 structureManager, class_2794 chunkGenerator, class_5819 rand, int x, int y, int z) {
            return new HollowHillComponent((class_3773)TFStructurePieceTypes.TFHill.get(), this, 0, this.size, x - 11, y - 5, z - 11);
        }
    };
    public static final TFLandmark HEDGE_MAZE = new TFLandmark(2, "hedge_maze", true, (class_6862)BiomeTagGenerator.VALID_HEDGE_MAZE_BIOMES, class_5847.field_38431, new class_2960[0]){
        {
            this.enableTerrainAlterations();
            this.adjustToTerrainHeight = true;
        }

        @Override
        public class_3443 provideFirstPiece(class_3485 structureManager, class_2794 chunkGenerator, class_5819 rand, int x, int y, int z) {
            return new HedgeMazeComponent(this, 0, x + 1, chunkGenerator.method_16398() + 8, z + 1);
        }
    };
    public static final TFLandmark QUEST_GROVE = new TFLandmark(1, "quest_grove", true, (class_6862)BiomeTagGenerator.VALID_QUEST_GROVE_BIOMES, class_5847.field_38431, new class_2960[0]){
        {
            this.enableTerrainAlterations();
            this.adjustToTerrainHeight = true;
        }

        @Override
        public class_3443 provideFirstPiece(class_3485 structureManager, class_2794 chunkGenerator, class_5819 rand, int x, int y, int z) {
            return new QuestGrove(structureManager, new class_2338(x - 12, chunkGenerator.method_16398() + 5, z - 12));
        }
    };
    public static final TFLandmark NAGA_COURTYARD = new TFLandmark(3, "naga_courtyard", true, (class_6862)BiomeTagGenerator.VALID_NAGA_COURTYARD_BIOMES, class_5847.field_38431, new class_2960[0]){
        {
            this.enableTerrainAlterations();
            this.adjustToTerrainHeight = true;
        }

        @Override
        public class_3443 provideFirstPiece(class_3485 structureManager, class_2794 chunkGenerator, class_5819 rand, int x, int y, int z) {
            return new CourtyardMain(this, rand, 0, x + 1, chunkGenerator.method_16398() + 5, z + 1, structureManager);
        }
    };
    public static final TFLandmark LICH_TOWER = new TFLandmark(1, "lich_tower", true, (class_6862)BiomeTagGenerator.VALID_LICH_TOWER_BIOMES, class_5847.field_38431, new class_2960[]{TwilightForestMod.prefix("progress_naga")}){
        {
            this.addMonster((class_1299<? extends class_1309>)class_1299.field_6051, 10, 1, 2).addMonster((class_1299<? extends class_1309>)class_1299.field_6137, 10, 1, 2).addMonster((class_1299<? extends class_1309>)class_1299.field_6046, 1, 1, 1).addMonster((class_1299<? extends class_1309>)class_1299.field_6091, 1, 1, 2).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.DEATH_TOME.get()), 10, 2, 3).addMonster((class_1299<? extends class_1309>)class_1299.field_6145, 1, 1, 1);
            this.adjustToTerrainHeight = true;
        }

        @Override
        public void addBookInformation(class_1799 book, class_2499 bookPages) {
            StructureHints.addTranslatedPages(bookPages, "twilightforest.book.lichtower", 4);
            book.method_7959("pages", (class_2520)bookPages);
            book.method_7959("author", (class_2520)class_2519.method_23256((String)"twilightforest.book.author"));
            book.method_7959("title", (class_2520)class_2519.method_23256((String)"twilightforest.book.lichtower"));
        }

        @Override
        public class_3443 provideFirstPiece(class_3485 structureManager, class_2794 chunkGenerator, class_5819 rand, int x, int y, int z) {
            return new TowerMainComponent(this, rand, 0, x, y, z);
        }
    };
    public static final TFLandmark HYDRA_LAIR = new TFLandmark(2, "hydra_lair", true, (class_6862)BiomeTagGenerator.VALID_HYDRA_LAIR_BIOMES, class_5847.field_28922, true, new class_2960[]{TwilightForestMod.prefix("progress_labyrinth")}){
        {
            this.enableTerrainAlterations();
            this.undergroundDecoAllowed = false;
        }

        @Override
        public void addBookInformation(class_1799 book, class_2499 bookPages) {
            StructureHints.addTranslatedPages(bookPages, "twilightforest.book.hydralair", 4);
            book.method_7959("pages", (class_2520)bookPages);
            book.method_7959("author", (class_2520)class_2519.method_23256((String)"twilightforest.book.author"));
            book.method_7959("title", (class_2520)class_2519.method_23256((String)"twilightforest.book.hydralair"));
        }

        @Override
        public class_3443 provideFirstPiece(class_3485 structureManager, class_2794 chunkGenerator, class_5819 rand, int x, int y, int z) {
            return new HydraLairComponent(this, 0, x - 7, y, z - 7);
        }
    };
    public static final TFLandmark LABYRINTH = new TFLandmark(3, "labyrinth", true, (class_6862)BiomeTagGenerator.VALID_LABYRINTH_BIOMES, class_5847.field_28923, new class_2960[]{TwilightForestMod.prefix("progress_lich")}){
        {
            this.enableDecorations();
            this.undergroundDecoAllowed = false;
            this.addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.MINOTAUR.get()), 20, 2, 3).addMonster((class_1299<? extends class_1309>)class_1299.field_6084, 10, 1, 2).addMonster((class_1299<? extends class_1309>)class_1299.field_6046, 10, 1, 2).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.MAZE_SLIME.get()), 10, 2, 4).addMonster((class_1299<? extends class_1309>)class_1299.field_6091, 1, 1, 2).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.FIRE_BEETLE.get()), 10, 1, 2).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.SLIME_BEETLE.get()), 10, 1, 2).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.PINCH_BEETLE.get()), 10, 1, 1);
        }

        @Override
        public void addBookInformation(class_1799 book, class_2499 bookPages) {
            StructureHints.addTranslatedPages(bookPages, "twilightforest.book.labyrinth", 5);
            book.method_7959("pages", (class_2520)bookPages);
            book.method_7959("author", (class_2520)class_2519.method_23256((String)"twilightforest.book.author"));
            book.method_7959("title", (class_2520)class_2519.method_23256((String)"twilightforest.book.labyrinth"));
        }

        @Override
        public class_3443 provideFirstPiece(class_3485 structureManager, class_2794 chunkGenerator, class_5819 rand, int x, int y, int z) {
            return new MazeRuinsComponent(this, 0, x, y, z);
        }

        @Override
        public class_2893.class_2895 getDecorationStage() {
            return class_2893.class_2895.field_13172;
        }
    };
    public static final TFLandmark DARK_TOWER = new TFLandmark(1, "dark_tower", true, (class_6862)BiomeTagGenerator.VALID_DARK_TOWER_BIOMES, class_5847.field_38431, new class_2960[]{TwilightForestMod.prefix("progress_knights")}){
        {
            this.addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.CARMINITE_GOLEM.get()), 10, 1, 2).addMonster((class_1299<? extends class_1309>)class_1299.field_6137, 10, 1, 2).addMonster((class_1299<? extends class_1309>)class_1299.field_6046, 5, 1, 1).addMonster((class_1299<? extends class_1309>)class_1299.field_6091, 2, 1, 2).addMonster((class_1299<? extends class_1309>)class_1299.field_6145, 1, 1, 1).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.CARMINITE_GHASTLING.get()), 10, 1, 2).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.CARMINITE_BROODLING.get()), 10, 4, 4).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.PINCH_BEETLE.get()), 10, 1, 1).addMonster(1, (class_1299<? extends class_1309>)((class_1299)TFEntities.CARMINITE_GHASTGUARD.get()), 10, 1, 2).addWaterCreature((class_1299<? extends class_1309>)class_1299.field_6114, 10, 4, 4);
            this.adjustToTerrainHeight = true;
        }

        @Override
        public void addBookInformation(class_1799 book, class_2499 bookPages) {
            StructureHints.addTranslatedPages(bookPages, "twilightforest.book.darktower", 3);
            book.method_7959("pages", (class_2520)bookPages);
            book.method_7959("author", (class_2520)class_2519.method_23256((String)"twilightforest.book.author"));
            book.method_7959("title", (class_2520)class_2519.method_23256((String)"twilightforest.book.darktower"));
        }

        @Override
        public class_3443 provideFirstPiece(class_3485 structureManager, class_2794 chunkGenerator, class_5819 rand, int x, int y, int z) {
            return new DarkTowerMainComponent(this, rand, 0, x, y, z);
        }
    };
    public static final TFLandmark KNIGHT_STRONGHOLD = new TFLandmark(3, "knight_stronghold", true, (class_6862)BiomeTagGenerator.VALID_KNIGHT_STRONGHOLD_BIOMES, class_5847.field_28923, new class_2960[]{TwilightForestMod.prefix("progress_trophy_pedestal")}){
        {
            this.enableDecorations().disableProtectionAura();
            this.undergroundDecoAllowed = false;
            this.addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.BLOCKCHAIN_GOBLIN.get()), 10, 1, 2).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.LOWER_GOBLIN_KNIGHT.get()), 5, 1, 2).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.HELMET_CRAB.get()), 10, 2, 4).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.SLIME_BEETLE.get()), 10, 2, 3).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.REDCAP_SAPPER.get()), 2, 1, 2).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.KOBOLD.get()), 10, 2, 4).addMonster((class_1299<? extends class_1309>)class_1299.field_6046, 5, 1, 2).addMonster((class_1299<? extends class_1309>)class_1299.field_6069, 5, 4, 4);
        }

        @Override
        public void addBookInformation(class_1799 book, class_2499 bookPages) {
            StructureHints.addTranslatedPages(bookPages, "twilightforest.book.tfstronghold", 5);
            book.method_7959("pages", (class_2520)bookPages);
            book.method_7959("author", (class_2520)class_2519.method_23256((String)"twilightforest.book.author"));
            book.method_7959("title", (class_2520)class_2519.method_23256((String)"twilightforest.book.tfstronghold"));
        }

        @Override
        public class_3443 provideFirstPiece(class_3485 structureManager, class_2794 chunkGenerator, class_5819 rand, int x, int y, int z) {
            return new StrongholdEntranceComponent(this, 0, x, y + 5, z);
        }

        @Override
        public class_2893.class_2895 getDecorationStage() {
            return class_2893.class_2895.field_13172;
        }
    };
    public static final TFLandmark YETI_CAVE = new TFLandmark(2, "yeti_lairs", true, (class_6862)BiomeTagGenerator.VALID_YETI_CAVE_BIOMES, class_5847.field_28923, true, new class_2960[]{TwilightForestMod.prefix("progress_lich")}){
        {
            this.enableDecorations().enableTerrainAlterations();
            this.undergroundDecoAllowed = false;
            this.addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.YETI.get()), 5, 1, 2);
        }

        @Override
        public void addBookInformation(class_1799 book, class_2499 bookPages) {
            StructureHints.addTranslatedPages(bookPages, "twilightforest.book.yeticave", 3);
            book.method_7959("pages", (class_2520)bookPages);
            book.method_7959("author", (class_2520)class_2519.method_23256((String)"twilightforest.book.author"));
            book.method_7959("title", (class_2520)class_2519.method_23256((String)"twilightforest.book.yeticave"));
        }

        @Override
        public class_3443 provideFirstPiece(class_3485 structureManager, class_2794 chunkGenerator, class_5819 rand, int x, int y, int z) {
            return new YetiCaveComponent(this, 0, x, y, z);
        }
    };
    public static final TFLandmark ICE_TOWER = new TFLandmark(2, "ice_tower", true, (class_6862)BiomeTagGenerator.VALID_AURORA_PALACE_BIOMES, class_5847.field_28922, new class_2960[]{TwilightForestMod.prefix("progress_yeti")}){
        {
            this.addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.SNOW_GUARDIAN.get()), 10, 1, 2).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.STABLE_ICE_CORE.get()), 10, 1, 2).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.UNSTABLE_ICE_CORE.get()), 5, 1, 2);
        }

        @Override
        public void addBookInformation(class_1799 book, class_2499 bookPages) {
            StructureHints.addTranslatedPages(bookPages, "twilightforest.book.icetower", 3);
            book.method_7959("pages", (class_2520)bookPages);
            book.method_7959("author", (class_2520)class_2519.method_23256((String)"twilightforest.book.author"));
            book.method_7959("title", (class_2520)class_2519.method_23256((String)"twilightforest.book.icetower"));
        }

        @Override
        public class_3443 provideFirstPiece(class_3485 structureManager, class_2794 chunkGenerator, class_5819 rand, int x, int y, int z) {
            return new IceTowerMainComponent(this, rand, 0, x, y, z);
        }
    };
    public static final TFLandmark TROLL_CAVE = new TFLandmark(4, "troll_lairs", true, (class_6862)BiomeTagGenerator.VALID_TROLL_CAVE_BIOMES, class_5847.field_28923, new class_2960[]{TwilightForestMod.prefix("progress_merge")}){
        {
            this.enableDecorations().enableTerrainAlterations().disableProtectionAura();
            this.addMonster((class_1299<? extends class_1309>)class_1299.field_6046, 5, 1, 2).addMonster((class_1299<? extends class_1309>)class_1299.field_6137, 10, 1, 2).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.TROLL.get()), 20, 1, 2).addMonster((class_1299<? extends class_1309>)class_1299.field_6145, 5, 1, 1).addMonster(1, (class_1299<? extends class_1309>)((class_1299)TFEntities.GIANT_MINER.get()), 10, 1, 1).addMonster(1, (class_1299<? extends class_1309>)((class_1299)TFEntities.ARMORED_GIANT.get()), 10, 1, 1);
        }

        @Override
        public void addBookInformation(class_1799 book, class_2499 bookPages) {
            StructureHints.addTranslatedPages(bookPages, "twilightforest.book.trollcave", 3);
            book.method_7959("pages", (class_2520)bookPages);
            book.method_7959("author", (class_2520)class_2519.method_23256((String)"twilightforest.book.author"));
            book.method_7959("title", (class_2520)class_2519.method_23256((String)"twilightforest.book.trollcave"));
        }

        @Override
        public class_2893.class_2895 getDecorationStage() {
            return class_2893.class_2895.field_13172;
        }

        @Override
        public class_3443 provideFirstPiece(class_3485 structureManager, class_2794 chunkGenerator, class_5819 rand, int x, int y, int z) {
            return new TrollCaveMainComponent((class_3773)TFStructurePieceTypes.TFTCMai.get(), this, 0, x, y, z);
        }
    };
    public static final TFLandmark FINAL_CASTLE = new TFLandmark(4, "final_castle", true, (class_6862)BiomeTagGenerator.VALID_FINAL_CASTLE_BIOMES, class_5847.field_38431, new class_2960[]{TwilightForestMod.prefix("progress_troll")}){

        @Override
        public class_3443 provideFirstPiece(class_3485 structureManager, class_2794 chunkGenerator, class_5819 rand, int x, int y, int z) {
            return new FinalCastleMainComponent(this, 0, x, y, z);
        }
    };
    public static final TFLandmark MUSHROOM_TOWER = new TFLandmark(2, "mushroom_tower", true, (class_6862)BiomeTagGenerator.VALID_MUSHROOM_TOWER_BIOMES, class_5847.field_28922, new class_2960[0]){
        {
            this.disableStructure();
            this.adjustToTerrainHeight = true;
        }

        @Override
        public class_3443 provideFirstPiece(class_3485 structureManager, class_2794 chunkGenerator, class_5819 rand, int x, int y, int z) {
            return new MushroomTowerMainComponent(this, rand, 0, x, y, z);
        }
    };
    public static final TFLandmark QUEST_ISLAND = new TFLandmark(1, "quest_island", false, (class_6862)BiomeTagGenerator.VALID_QUEST_GROVE_BIOMES, class_5847.field_28922, new class_2960[0]){
        {
            this.disableStructure();
        }
    };
    public final int size;
    public final String name;
    public final boolean centerBounds;
    protected boolean surfaceDecorationsAllowed = false;
    protected boolean undergroundDecoAllowed = true;
    public boolean isStructureEnabled = true;
    public boolean requiresTerraforming = false;
    private final class_6862<class_1959> biomeTag;
    private final class_5847 beardifierContribution;
    private final ImmutableList<class_2960> requiredAdvancements;
    public boolean hasProtectionAura = true;
    protected boolean adjustToTerrainHeight = false;
    private static int maxPossibleSize;
    private final List<List<class_5483.class_1964>> spawnableMonsterLists = new ArrayList<List<class_5483.class_1964>>();
    private final List<class_5483.class_1964> ambientCreatureList = new ArrayList<class_5483.class_1964>();
    private final List<class_5483.class_1964> waterCreatureList = new ArrayList<class_5483.class_1964>();
    private long lastSpawnedHintMonsterTime;
    private static final ImmutableMap<String, TFLandmark> NAME_2_TYPE;
    public static final Codec<TFLandmark> CODEC;

    private TFLandmark(int size, String name, boolean featureGenerator, @Nullable class_6862<class_1959> biomeTag, class_5847 beardifierContribution, class_2960 ... requiredAdvancements) {
        this(size, name, featureGenerator, biomeTag, beardifierContribution, false, requiredAdvancements);
    }

    private TFLandmark(int size, String name, boolean featureGenerator, class_6862<class_1959> biomeTag, class_5847 beardifierContribution, boolean centerBounds, class_2960 ... requiredAdvancements) {
        this.size = size;
        this.name = name;
        this.biomeTag = biomeTag;
        this.beardifierContribution = beardifierContribution;
        this.requiredAdvancements = ImmutableList.copyOf((Object[])requiredAdvancements);
        this.centerBounds = centerBounds;
        maxPossibleSize = Math.max(this.size, maxPossibleSize);
    }

    @Deprecated
    public static int getMaxSearchSize() {
        return maxPossibleSize;
    }

    @Override
    public boolean isSurfaceDecorationsAllowed() {
        return this.surfaceDecorationsAllowed;
    }

    @Override
    public boolean isUndergroundDecoAllowed() {
        return this.undergroundDecoAllowed;
    }

    @Override
    public boolean shouldAdjustToTerrain() {
        return this.adjustToTerrainHeight;
    }

    public TFLandmark enableDecorations() {
        this.surfaceDecorationsAllowed = true;
        return this;
    }

    public TFLandmark disableStructure() {
        this.enableDecorations();
        this.isStructureEnabled = false;
        return this;
    }

    public TFLandmark enableTerrainAlterations() {
        this.requiresTerraforming = true;
        return this;
    }

    public TFLandmark disableProtectionAura() {
        this.hasProtectionAura = false;
        return this;
    }

    public TFLandmark addMonster(class_1299<? extends class_1309> monsterClass, int weight, int minGroup, int maxGroup) {
        this.addMonster(0, monsterClass, weight, minGroup, maxGroup);
        return this;
    }

    public TFLandmark addMonster(int listIndex, class_1299<? extends class_1309> monsterClass, int weight, int minGroup, int maxGroup) {
        List<Object> monsterList;
        if (this.spawnableMonsterLists.size() > listIndex) {
            monsterList = this.spawnableMonsterLists.get(listIndex);
        } else {
            monsterList = new ArrayList();
            this.spawnableMonsterLists.add(listIndex, monsterList);
        }
        monsterList.add(new class_5483.class_1964(monsterClass, weight, minGroup, maxGroup));
        return this;
    }

    public TFLandmark addWaterCreature(class_1299<? extends class_1309> monsterClass, int weight, int minGroup, int maxGroup) {
        this.waterCreatureList.add(new class_5483.class_1964(monsterClass, weight, minGroup, maxGroup));
        return this;
    }

    @Nullable
    public class_6862<class_1959> getBiomeTag() {
        return this.biomeTag;
    }

    public class_5847 getBeardifierContribution() {
        return this.beardifierContribution;
    }

    @Override
    public List<class_5483.class_1964> getCombinedMonsterSpawnableList() {
        ArrayList<class_5483.class_1964> list = new ArrayList<class_5483.class_1964>();
        this.spawnableMonsterLists.forEach(l -> {
            if (l != null) {
                list.addAll((Collection<class_5483.class_1964>)l);
            }
        });
        return list;
    }

    @Override
    public List<class_5483.class_1964> getCombinedCreatureSpawnableList() {
        ArrayList<class_5483.class_1964> list = new ArrayList<class_5483.class_1964>();
        list.addAll(this.ambientCreatureList);
        list.addAll(this.waterCreatureList);
        return list;
    }

    @Override
    public List<class_5483.class_1964> getSpawnableList(class_1311 creatureType) {
        return switch (creatureType) {
            case class_1311.field_6302 -> this.getSpawnableMonsterList(0);
            case class_1311.field_6303 -> this.ambientCreatureList;
            case class_1311.field_6300 -> this.waterCreatureList;
            default -> List.of();
        };
    }

    @Override
    public List<class_5483.class_1964> getSpawnableMonsterList(int index) {
        if (index >= 0 && index < this.spawnableMonsterLists.size()) {
            return this.spawnableMonsterLists.get(index);
        }
        return new ArrayList<class_5483.class_1964>();
    }

    public List<List<class_5483.class_1964>> getSpawnableMonsterLists() {
        return this.spawnableMonsterLists;
    }

    public List<class_5483.class_1964> getAmbientCreatureList() {
        return this.ambientCreatureList;
    }

    public List<class_5483.class_1964> getWaterCreatureList() {
        return this.waterCreatureList;
    }

    @Override
    public List<class_2960> getRequiredAdvancements() {
        return this.requiredAdvancements;
    }

    @Override
    public void trySpawnHintMonster(class_1937 world, class_1657 player, class_2338 pos) {
        long currentTime = world.method_8510();
        if (currentTime < this.lastSpawnedHintMonsterTime) {
            this.lastSpawnedHintMonsterTime = 0L;
        }
        if (currentTime - this.lastSpawnedHintMonsterTime > 1200L) {
            for (int i = 0; i < 20; ++i) {
                if (!this.didSpawnHintMonster(world, player, pos)) continue;
                this.lastSpawnedHintMonsterTime = currentTime;
                break;
            }
        }
    }

    @Nullable
    public class_3443 provideFirstPiece(class_3485 structureManager, class_2794 chunkGenerator, class_5819 rand, int x, int y, int z) {
        return null;
    }

    public Optional<class_3195.class_7150> generateStub(class_3195.class_7149 context) {
        class_1923 chunkPos = context.comp_568();
        boolean dontCenter = this == LICH_TOWER || this == TROLL_CAVE || this == YETI_CAVE;
        int x = (chunkPos.field_9181 << 4) + (dontCenter ? 0 : 7);
        int z = (chunkPos.field_9180 << 4) + (dontCenter ? 0 : 7);
        int y = this.shouldAdjustToTerrain() ? class_3532.method_15340((int)context.comp_562().method_18028(x, z, class_2902.class_2903.field_13194, context.comp_569(), context.comp_564()), (int)(context.comp_562().method_16398() + 1), (int)(context.comp_562().method_16398() + 7)) : context.comp_562().method_16398();
        return Optional.ofNullable(this.provideFirstPiece(context.comp_565(), context.comp_562(), class_5819.method_43049((long)(context.comp_567() + (long)chunkPos.field_9181 * 25117L + (long)chunkPos.field_9180 * 151121L)), x, y, z)).map(piece -> this.getStructurePieceGenerationStubFunction((class_3443)piece, context, x, y, z));
    }

    @NotNull
    private class_3195.class_7150 getStructurePieceGenerationStubFunction(class_3443 startingPiece, class_3195.class_7149 context, int x, int y, int z) {
        return new class_3195.class_7150(new class_2338(x, y, z), structurePiecesBuilder -> {
            structurePiecesBuilder.method_35462(startingPiece);
            startingPiece.method_14918(startingPiece, (class_6130)structurePiecesBuilder, (class_5819)context.comp_566());
            structurePiecesBuilder.field_34944.stream().filter(TFStructureComponentTemplate.class::isInstance).map(TFStructureComponentTemplate.class::cast).forEach(t -> t.LAZY_TEMPLATE_LOADER.run());
        });
    }

    public class_2893.class_2895 getDecorationStage() {
        return class_2893.class_2895.field_13173;
    }

    public final class_3341 getComponentToAddBoundingBox(int x, int y, int z, int minX, int minY, int minZ, int spanX, int spanY, int spanZ, @Nullable class_2350 dir) {
        if (this.centerBounds) {
            x += (spanX + minX) / 4;
            y += (spanY + minY) / 4;
            z += (spanZ + minZ) / 4;
        }
        return switch (dir) {
            case class_2350.field_11039 -> new class_3341(x - spanZ + minZ, y + minY, z + minX, x + minZ, y + spanY + minY, z + spanX + minX);
            case class_2350.field_11043 -> new class_3341(x - spanX - minX, y + minY, z - spanZ - minZ, x - minX, y + spanY + minY, z - minZ);
            case class_2350.field_11034 -> new class_3341(x + minZ, y + minY, z - spanX, x + spanZ + minZ, y + spanY + minY, z + minX);
            default -> new class_3341(x + minX, y + minY, z + minZ, x + spanX + minX, y + spanY + minY, z + spanZ + minZ);
        };
    }

    public String toString() {
        return "TFLandmark{name='" + this.name + "'}";
    }

    static {
        NAME_2_TYPE = (ImmutableMap)class_156.method_656(() -> ImmutableMap.builder().put((Object)"mushroom_tower", (Object)MUSHROOM_TOWER).put((Object)"small_hollow_hill", (Object)SMALL_HILL).put((Object)"medium_hollow_hill", (Object)MEDIUM_HILL).put((Object)"large_hollow_hill", (Object)LARGE_HILL).put((Object)"hedge_maze", (Object)HEDGE_MAZE).put((Object)"quest_grove", (Object)QUEST_GROVE).put((Object)"quest_island", (Object)QUEST_ISLAND).put((Object)"naga_courtyard", (Object)NAGA_COURTYARD).put((Object)"lich_tower", (Object)LICH_TOWER).put((Object)"hydra_lair", (Object)HYDRA_LAIR).put((Object)"labyrinth", (Object)LABYRINTH).put((Object)"dark_tower", (Object)DARK_TOWER).put((Object)"knight_stronghold", (Object)KNIGHT_STRONGHOLD).put((Object)"yeti_lairs", (Object)YETI_CAVE).put((Object)"ice_tower", (Object)ICE_TOWER).put((Object)"troll_lairs", (Object)TROLL_CAVE).put((Object)"final_castle", (Object)FINAL_CASTLE).build());
        CODEC = Codec.STRING.comapFlatMap(name -> NAME_2_TYPE.containsKey(name) ? DataResult.success((Object)((TFLandmark)NAME_2_TYPE.get(name))) : DataResult.error((String)("Landmark " + name + " not recognized!")), tfFeature -> tfFeature.name);
    }
}

