/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import io.github.fabricators_of_create.porting_lib.item.CustomMapItem;
import me.alphamode.forgetags.Tags;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1806;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_20;
import net.minecraft.class_22;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3620;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;
import twilightforest.TFMazeMapData;
import twilightforest.init.TFItems;

public class MazeMapItem
extends class_1806
implements CustomMapItem {
    public static final String STR_ID = "mazemap";
    private static final int YSEARCH = 3;
    protected final boolean mapOres;

    public MazeMapItem(boolean mapOres, class_1792.class_1793 properties) {
        super(properties);
        this.mapOres = mapOres;
    }

    public static class_1799 setupNewMap(class_1937 level, int worldX, int worldZ, byte scale, boolean trackingPosition, boolean unlimitedTracking, int worldY, boolean mapOres) {
        class_1799 itemstack = new class_1799(mapOres ? (class_1935)TFItems.FILLED_ORE_MAP.get() : (class_1935)TFItems.FILLED_MAZE_MAP.get());
        MazeMapItem.createMapData(itemstack, level, worldX, worldZ, scale, trackingPosition, unlimitedTracking, (class_5321<class_1937>)level.method_27983(), worldY);
        return itemstack;
    }

    @Nullable
    public static TFMazeMapData getData(class_1799 stack, class_1937 level) {
        Integer id = MazeMapItem.method_8003((class_1799)stack);
        return id == null ? null : TFMazeMapData.getMazeMapData(level, MazeMapItem.getMapName(id));
    }

    @Nullable
    public TFMazeMapData getCustomMapData(class_1799 stack, class_1937 level) {
        TFMazeMapData mapdata = MazeMapItem.getData(stack, level);
        if (mapdata == null && !level.method_8608()) {
            mapdata = MazeMapItem.createMapData(stack, level, level.method_8401().method_215(), level.method_8401().method_166(), 0, false, false, (class_5321<class_1937>)level.method_27983(), level.method_8401().method_144());
        }
        return mapdata;
    }

    private static TFMazeMapData createMapData(class_1799 stack, class_1937 level, int x, int z, int scale, boolean trackingPosition, boolean unlimitedTracking, class_5321<class_1937> dimension, int y) {
        int i = level.method_17889();
        int mapSize = 128 * (1 << scale);
        int roundX = class_3532.method_15357((double)(((double)x + 64.0) / (double)mapSize));
        int roundZ = class_3532.method_15357((double)(((double)z + 64.0) / (double)mapSize));
        int scaledX = roundX * mapSize + mapSize / 2 - 64;
        int scaledZ = roundZ * mapSize + mapSize / 2 - 64;
        TFMazeMapData mapdata = new TFMazeMapData(scaledX, scaledZ, (byte)scale, trackingPosition, unlimitedTracking, false, dimension);
        mapdata.calculateMapCenter(level, x, y, z);
        TFMazeMapData.registerMazeMapData(level, mapdata, MazeMapItem.getMapName(i));
        stack.method_7948().method_10569("map", i);
        return mapdata;
    }

    public static String getMapName(int id) {
        return "mazemap_" + id;
    }

    public void method_7998(class_1937 level, class_1297 viewer, class_22 data) {
        if (level.method_27983() == data.field_118 && viewer instanceof class_1657) {
            int blocksPerPixel = 1 << data.field_119;
            int centerX = data.field_116;
            int centerZ = data.field_115;
            int viewerX = class_3532.method_15357((double)(viewer.method_23317() - (double)centerX)) / blocksPerPixel + 64;
            int viewerZ = class_3532.method_15357((double)(viewer.method_23321() - (double)centerZ)) / blocksPerPixel + 64;
            int viewRadiusPixels = 16;
            if (level.method_8597().comp_643()) {
                viewRadiusPixels /= 2;
            }
            class_22.class_23 mapdata$mapinfo = data.method_101((class_1657)viewer);
            ++mapdata$mapinfo.field_131;
            boolean flag = false;
            for (int xPixel = viewerX - viewRadiusPixels + 1; xPixel < viewerX + viewRadiusPixels; ++xPixel) {
                if ((xPixel & 0xF) != (mapdata$mapinfo.field_131 & 0xF) && !flag) continue;
                flag = false;
                for (int zPixel = viewerZ - viewRadiusPixels - 1; zPixel < viewerZ + viewRadiusPixels; ++zPixel) {
                    byte b1;
                    byte b0;
                    if (xPixel < 0 || zPixel < -1 || xPixel >= 128 || zPixel >= 128) continue;
                    int xPixelDist = xPixel - viewerX;
                    int zPixelDist = zPixel - viewerZ;
                    boolean shouldFuzz = xPixelDist * xPixelDist + zPixelDist * zPixelDist > (viewRadiusPixels - 2) * (viewRadiusPixels - 2);
                    int worldX = (centerX / blocksPerPixel + xPixel - 64) * blocksPerPixel;
                    int worldZ = (centerZ / blocksPerPixel + zPixel - 64) * blocksPerPixel;
                    HashMultiset multiset = HashMultiset.create();
                    class_2818 chunk = level.method_8500(new class_2338(worldX, 0, worldZ));
                    int brightness = 1;
                    if (chunk.method_12223()) continue;
                    int worldXRounded = worldX & 0xF;
                    int worldZRounded = worldZ & 0xF;
                    if (level.method_8597().comp_643()) {
                        int l3 = worldX + worldZ * 231871;
                        if (((l3 = l3 * l3 * 31287121 + l3 * 11) >> 20 & 1) == 0) {
                            multiset.add((Object)class_2246.field_10566.method_9564().method_26205((class_1922)level, class_2338.field_10980), 10);
                        } else {
                            multiset.add((Object)class_2246.field_10340.method_9564().method_26205((class_1922)level, class_2338.field_10980), 100);
                        }
                    } else {
                        int yCenter = ((TFMazeMapData)data).yCenter;
                        class_2338.class_2339 blockpos$mutableblockpos = new class_2338.class_2339(worldXRounded, yCenter, worldZRounded);
                        class_2680 state = chunk.method_8320((class_2338)blockpos$mutableblockpos);
                        multiset.add((Object)state.method_26205((class_1922)level, (class_2338)blockpos$mutableblockpos));
                        if (state.method_27852(class_2246.field_10340) || state.method_26215()) {
                            for (int i = -3; i <= 3; ++i) {
                                blockpos$mutableblockpos.method_33098(yCenter + i);
                                class_2680 searchID = chunk.method_8320((class_2338)blockpos$mutableblockpos);
                                if (!searchID.method_27852(class_2246.field_10340) || searchID.method_26215()) continue;
                                state = searchID;
                                if (i > 0) {
                                    brightness = 2;
                                }
                                if (i >= 0) break;
                                brightness = 0;
                                break;
                            }
                        }
                        if (this.mapOres) {
                            if (state.method_26164(class_3481.field_29193)) {
                                multiset.add((Object)class_3620.field_16009, 1000);
                            } else if (state.method_26164(class_3481.field_23062)) {
                                multiset.add((Object)class_3620.field_15994, 1000);
                            } else if (state.method_26164(class_3481.field_28988)) {
                                multiset.add((Object)class_3620.field_16005, 1000);
                            } else if (state.method_26164(class_3481.field_28991)) {
                                multiset.add((Object)class_3620.field_15980, 1000);
                            } else if (state.method_26164(class_3481.field_28990)) {
                                multiset.add((Object)class_3620.field_16020, 1000);
                            } else if (state.method_26164(class_3481.field_28989)) {
                                multiset.add((Object)class_3620.field_15983, 1000);
                            } else if (state.method_26164(class_3481.field_29194)) {
                                multiset.add((Object)class_3620.field_16001, 1000);
                            } else if (state.method_26164(class_3481.field_29195)) {
                                multiset.add((Object)class_3620.field_15987, 1000);
                            } else if (state.method_26204() != class_2246.field_10124 && state.method_26164(Tags.Blocks.ORES)) {
                                multiset.add((Object)class_3620.field_16030, 1000);
                            }
                        }
                    }
                    class_3620 mapcolor = (class_3620)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)class_3620.field_16008);
                    if (zPixel < 0 || xPixelDist * xPixelDist + zPixelDist * zPixelDist >= viewRadiusPixels * viewRadiusPixels || shouldFuzz && (xPixel + zPixel & 1) == 0 || (b0 = data.field_122[xPixel + zPixel * 128]) == (b1 = (byte)(mapcolor.field_16021 * 4 + brightness))) continue;
                    data.method_32370(xPixel, zPixel, b1);
                    data.method_80();
                    flag = true;
                }
            }
        }
    }

    public void method_7888(class_1799 stack, class_1937 level, class_1297 entity, int slot, boolean isSelected) {
        TFMazeMapData mapdata;
        if (!level.method_8608() && (mapdata = this.getCustomMapData(stack, level)) != null) {
            class_1657 player;
            if (entity instanceof class_1657) {
                class_20 decoration;
                class_1657 entityplayer = (class_1657)entity;
                mapdata.method_102(entityplayer, stack);
                int yProximity = class_3532.method_15357((double)(entityplayer.method_23318() - (double)mapdata.yCenter));
                if ((yProximity < -3 || yProximity > 3) && (decoration = (class_20)mapdata.field_117.get(entityplayer.method_5477().getString())) != null) {
                    mapdata.field_117.put(entityplayer.method_5477().getString(), new class_20(class_20.class_21.field_86, decoration.method_90(), decoration.method_91(), decoration.method_89(), null));
                }
            }
            if (!mapdata.field_17403 && (isSelected || entity instanceof class_1657 && (player = (class_1657)entity).method_6079() == stack)) {
                this.method_7998(level, entity, mapdata);
            }
        }
    }

    public void method_7843(class_1799 stack, class_1937 level, class_1657 player) {
    }

    @Nullable
    public class_2596<?> method_7757(class_1799 stack, class_1937 level, class_1657 player) {
        Integer id = MazeMapItem.method_8003((class_1799)stack);
        TFMazeMapData mapdata = this.getCustomMapData(stack, level);
        return id == null || mapdata == null ? null : mapdata.method_100(id, player);
    }
}

