/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.loot;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Set;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_47;
import net.minecraft.class_52;
import net.minecraft.class_5281;
import twilightforest.TwilightForestMod;

public class TFLootTables {
    private static final Set<class_2960> TF_LOOT_TABLES = Sets.newHashSet();
    private static final int DEFAULT_PLACE_FLAG = 2;
    public static final TFLootTables SMALL_HOLLOW_HILL = new TFLootTables("hill_1");
    public static final TFLootTables MEDIUM_HOLLOW_HILL = new TFLootTables("hill_2");
    public static final TFLootTables LARGE_HOLLOW_HILL = new TFLootTables("hill_3");
    public static final TFLootTables HEDGE_MAZE = new TFLootTables("hedge_maze");
    public static final TFLootTables FANCY_WELL = new TFLootTables("fancy_well");
    public static final TFLootTables WELL = new TFLootTables("well");
    public static final TFLootTables LABYRINTH_ROOM = new TFLootTables("labyrinth_room");
    public static final TFLootTables LABYRINTH_DEAD_END = new TFLootTables("labyrinth_dead_end");
    public static final TFLootTables TOWER_ROOM = new TFLootTables("tower_room");
    public static final TFLootTables TOWER_LIBRARY = new TFLootTables("tower_library");
    public static final TFLootTables BASEMENT = new TFLootTables("basement");
    public static final TFLootTables FOUNDATION_BASEMENT = new TFLootTables("foundation_basement");
    public static final TFLootTables LABYRINTH_VAULT = new TFLootTables("labyrinth_vault");
    public static final TFLootTables LABYRINTH_VAULT_JACKPOT = new TFLootTables("labyrinth_vault_jackpot");
    public static final TFLootTables DARKTOWER_CACHE = new TFLootTables("darktower_cache");
    public static final TFLootTables DARKTOWER_KEY = new TFLootTables("darktower_key");
    public static final TFLootTables DARKTOWER_BOSS = new TFLootTables("darktower_boss");
    public static final TFLootTables TREE_CACHE = new TFLootTables("tree_cache");
    public static final TFLootTables STRONGHOLD_CACHE = new TFLootTables("stronghold_cache");
    public static final TFLootTables STRONGHOLD_ROOM = new TFLootTables("stronghold_room");
    public static final TFLootTables STRONGHOLD_BOSS = new TFLootTables("stronghold_boss");
    public static final TFLootTables AURORA_CACHE = new TFLootTables("aurora_cache");
    public static final TFLootTables AURORA_ROOM = new TFLootTables("aurora_room");
    public static final TFLootTables TROLL_GARDEN = new TFLootTables("troll_garden");
    public static final TFLootTables TROLL_VAULT = new TFLootTables("troll_vault");
    public static final TFLootTables TROLL_VAULT_WITH_LAMP = new TFLootTables("troll_vault_with_lamp");
    public static final TFLootTables GRAVEYARD = new TFLootTables("graveyard");
    public static final TFLootTables QUEST_GROVE = new TFLootTables("quest_grove_dropper");
    public static final TFLootTables USELESS_LOOT = new TFLootTables("useless");
    public static final class_2960 BIGHORN_SHEEP_WHITE = TFLootTables.register("entities/bighorn_sheep/white");
    public static final class_2960 BIGHORN_SHEEP_ORANGE = TFLootTables.register("entities/bighorn_sheep/orange");
    public static final class_2960 BIGHORN_SHEEP_MAGENTA = TFLootTables.register("entities/bighorn_sheep/magenta");
    public static final class_2960 BIGHORN_SHEEP_LIGHT_BLUE = TFLootTables.register("entities/bighorn_sheep/light_blue");
    public static final class_2960 BIGHORN_SHEEP_YELLOW = TFLootTables.register("entities/bighorn_sheep/yellow");
    public static final class_2960 BIGHORN_SHEEP_LIME = TFLootTables.register("entities/bighorn_sheep/lime");
    public static final class_2960 BIGHORN_SHEEP_PINK = TFLootTables.register("entities/bighorn_sheep/pink");
    public static final class_2960 BIGHORN_SHEEP_GRAY = TFLootTables.register("entities/bighorn_sheep/gray");
    public static final class_2960 BIGHORN_SHEEP_LIGHT_GRAY = TFLootTables.register("entities/bighorn_sheep/light_gray");
    public static final class_2960 BIGHORN_SHEEP_CYAN = TFLootTables.register("entities/bighorn_sheep/cyan");
    public static final class_2960 BIGHORN_SHEEP_PURPLE = TFLootTables.register("entities/bighorn_sheep/purple");
    public static final class_2960 BIGHORN_SHEEP_BLUE = TFLootTables.register("entities/bighorn_sheep/blue");
    public static final class_2960 BIGHORN_SHEEP_BROWN = TFLootTables.register("entities/bighorn_sheep/brown");
    public static final class_2960 BIGHORN_SHEEP_GREEN = TFLootTables.register("entities/bighorn_sheep/green");
    public static final class_2960 BIGHORN_SHEEP_RED = TFLootTables.register("entities/bighorn_sheep/red");
    public static final class_2960 BIGHORN_SHEEP_BLACK = TFLootTables.register("entities/bighorn_sheep/black");
    public static final class_2960 QUESTING_RAM_REWARDS = TFLootTables.register("entities/questing_ram_rewards");
    public static final class_2960 DEATH_TOME_HURT = TFLootTables.register("entities/death_tome_hurt");
    public static final class_2960 DEATH_TOME_BOOKS = TFLootTables.register("entities/death_tome_books");
    public static final class_2960 CICADA_SQUISH_DROPS = TFLootTables.register("blocks/cicada_squish");
    public static final class_2960 FIREFLY_SQUISH_DROPS = TFLootTables.register("blocks/firefly_squish");
    public static final class_2960 MOONWORM_SQUISH_DROPS = TFLootTables.register("blocks/moonworm_squish");
    public static final class_2960 ALL_BOSSES = TFLootTables.register("entities/all_bosses");
    public final class_2960 lootTable;

    private TFLootTables(String path) {
        this.lootTable = TwilightForestMod.prefix(String.format("structures/%s", path));
    }

    public void generateChest(class_5281 world, class_2338 pos, class_2350 dir, boolean trapped) {
        this.generateLootContainer(world, pos, (class_2680)(trapped ? class_2246.field_10380 : class_2246.field_10034).method_9564().method_11657((class_2769)class_2281.field_10768, (Comparable)dir), 2);
    }

    public void generateLootContainer(class_5281 world, class_2338 pos, class_2680 state, int flags) {
        world.method_8652(pos, state, flags);
        this.generateChestContents(world, pos);
    }

    public void generateLootContainer(class_1936 world, class_2338 pos, class_2680 state, int flags, long seed) {
        world.method_8652(pos, state, flags);
        this.generateChestContents(world, pos, seed);
    }

    public void generateChestContents(class_5281 world, class_2338 pos) {
        this.generateChestContents((class_1936)world, pos, world.method_8412() * (long)pos.method_10263() + (long)pos.method_10264() ^ (long)pos.method_10260());
    }

    public void generateChestContents(class_1936 world, class_2338 pos, long seed) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof class_2621) {
            class_2621 lootContainer = (class_2621)class_25862;
            lootContainer.method_11285(this.lootTable, seed);
        }
    }

    private static class_2960 register(String id) {
        return TFLootTables.register(TwilightForestMod.prefix(id));
    }

    private static class_2960 register(class_2960 id) {
        if (TF_LOOT_TABLES.add(id)) {
            return id;
        }
        throw new IllegalArgumentException(id + " is already a registered built-in loot table");
    }

    public static void entityDropsIntoContainer(class_1309 entity, class_47 lootContext, class_2680 blockContaining, class_2338 placement) {
        class_3218 serverLevel;
        class_1937 class_19372 = entity.method_37908();
        if (class_19372 instanceof class_3218 && (serverLevel = (class_3218)class_19372).method_8652(placement, blockContaining, 2) && (class_19372 = serverLevel.method_8321(placement)) instanceof class_1263) {
            class_1263 container = (class_1263)class_19372;
            class_52 table = serverLevel.method_8503().method_3857().method_367(entity.method_5989());
            ObjectArrayList stacks = table.method_319(lootContext);
            table.method_329(container, lootContext);
            if (stacks.size() > 27) {
                for (class_1799 stack : stacks.subList(28, stacks.size())) {
                    class_1542 item = new class_1542((class_1937)serverLevel, (double)placement.method_10084().method_10263(), (double)placement.method_10084().method_10264(), (double)placement.method_10084().method_10260(), stack);
                    item.method_6976();
                    item.method_6975();
                    serverLevel.method_8649((class_1297)item);
                }
            }
        }
    }
}

