/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2944;
import net.minecraft.class_3730;
import net.minecraft.class_3746;
import net.minecraft.class_4651;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import twilightforest.init.TFBlocks;
import twilightforest.util.FeatureLogic;
import twilightforest.util.VoxelBresenhamIterator;

public final class FeaturePlacers {
    public static final BiFunction<class_3746, class_2338, Boolean> VALID_TREE_POS = class_2944::method_27371;

    public static <T extends class_1308> void placeEntity(class_1299<T> entityType, class_2338 pos, class_5425 levelAccessor) {
        class_1308 mob = (class_1308)entityType.method_5883((class_1937)levelAccessor.method_8410());
        if (mob == null) {
            return;
        }
        mob.method_5971();
        mob.method_5725(pos, 0.0f, 0.0f);
        mob.method_5943(levelAccessor, levelAccessor.method_8404(pos), class_3730.field_16474, null, null);
        levelAccessor.method_30771((class_1297)mob);
        levelAccessor.method_8652(pos, class_2246.field_10124.method_9564(), 2);
    }

    public static void drawBresenhamBranch(class_1936 world, BiConsumer<class_2338, class_2680> trunkPlacer, class_5819 random, class_2338 start, class_2338 end, class_4651 config) {
        for (class_2338 pixel : new VoxelBresenhamIterator(start, end)) {
            FeaturePlacers.placeIfValidTreePos((class_3746)world, trunkPlacer, random, pixel, config);
        }
    }

    public static void buildRoot(class_1936 world, BiConsumer<class_2338, class_2680> placer, class_5819 rand, class_2338 start, double offset, int b, class_4651 config) {
        class_2338 dest = FeatureLogic.translate(start.method_10087(b + 2), 5.0, 0.3 * (double)b + offset, 0.8);
        for (class_2338 coord : new VoxelBresenhamIterator(start.method_10074(), dest)) {
            if (FeaturePlacers.placeIfValidRootPos((class_3746)world, placer, rand, coord, config)) continue;
            return;
        }
    }

    public static void drawBresenhamTree(class_3746 world, BiConsumer<class_2338, class_2680> placer, BiFunction<class_3746, class_2338, Boolean> predicate, class_2338 from, class_2338 to, class_4651 config, class_5819 random) {
        for (class_2338 pixel : new VoxelBresenhamIterator(from, to)) {
            FeaturePlacers.placeProvidedBlock(world, placer, predicate, pixel, config, random);
        }
    }

    public static void placeProvidedBlock(class_3746 world, BiConsumer<class_2338, class_2680> worldPlacer, BiFunction<class_3746, class_2338, Boolean> predicate, class_2338 pos, class_4651 config, class_5819 random) {
        if (predicate.apply(world, pos).booleanValue()) {
            worldPlacer.accept(pos, config.method_23455(random, pos));
        }
    }

    public static void placeCircleOdd(class_3746 world, BiConsumer<class_2338, class_2680> placer, BiFunction<class_3746, class_2338, Boolean> predicate, class_5819 random, class_2338 centerPos, float radius, class_4651 config) {
        float radiusSquared = radius * radius;
        FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos, config, random);
        int x = 0;
        while ((float)x <= radius) {
            int z = 1;
            while ((float)z <= radius) {
                if ((float)(x * x + z * z) <= radiusSquared) {
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.method_10069(x, 0, z), config, random);
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.method_10069(-x, 0, -z), config, random);
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.method_10069(-z, 0, x), config, random);
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.method_10069(z, 0, -x), config, random);
                }
                ++z;
            }
            ++x;
        }
    }

    public static void placeCircleEven(class_3746 world, BiConsumer<class_2338, class_2680> placer, BiFunction<class_3746, class_2338, Boolean> predicate, class_5819 random, class_2338 centerPos, float radius, class_4651 config) {
        float radiusSquared = radius * radius;
        FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos, config, random);
        int x = 0;
        while ((float)x <= radius) {
            int z = 0;
            while ((float)z <= radius) {
                if ((float)(x * x + z * z) <= radiusSquared) {
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.method_10069(1 + x, 0, 1 + z), config, random);
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.method_10069(-x, 0, -z), config, random);
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.method_10069(-x, 0, 1 + z), config, random);
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.method_10069(1 + x, 0, -z), config, random);
                }
                ++z;
            }
            ++x;
        }
    }

    public static void placeSpheroid(class_3746 world, BiConsumer<class_2338, class_2680> placer, BiFunction<class_3746, class_2338, Boolean> predicate, class_5819 random, class_2338 centerPos, float xzRadius, float yRadius, float verticalBias, class_4651 config) {
        float xzRadiusSquared = xzRadius * xzRadius;
        float yRadiusSquared = yRadius * yRadius;
        float superRadiusSquared = xzRadiusSquared * yRadiusSquared;
        FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos, config, random);
        int y = 0;
        while ((float)y <= yRadius) {
            if (!((float)y > yRadius)) {
                FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.method_10069(0, y, 0), config, random);
                FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.method_10069(0, -y, 0), config, random);
            }
            ++y;
        }
        int x = 0;
        while ((float)x <= xzRadius) {
            int z = 1;
            while ((float)z <= xzRadius) {
                if (!((float)(x * x + z * z) > xzRadiusSquared)) {
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.method_10069(x, 0, z), config, random);
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.method_10069(-x, 0, -z), config, random);
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.method_10069(-z, 0, x), config, random);
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.method_10069(z, 0, -x), config, random);
                    int y2 = 1;
                    while ((float)y2 <= yRadius) {
                        float xzSquare = (float)(x * x + z * z) * yRadiusSquared;
                        if (xzSquare + ((float)y2 - verticalBias) * ((float)y2 - verticalBias) * xzRadiusSquared <= superRadiusSquared) {
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.method_10069(x, y2, z), config, random);
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.method_10069(-x, y2, -z), config, random);
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.method_10069(-z, y2, x), config, random);
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.method_10069(z, y2, -x), config, random);
                        }
                        if (xzSquare + ((float)y2 + verticalBias) * ((float)y2 + verticalBias) * xzRadiusSquared <= superRadiusSquared) {
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.method_10069(x, -y2, z), config, random);
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.method_10069(-x, -y2, -z), config, random);
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.method_10069(-z, -y2, x), config, random);
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.method_10069(z, -y2, -x), config, random);
                        }
                        ++y2;
                    }
                }
                ++z;
            }
            ++x;
        }
    }

    public static void placeSpheroid(class_3746 world, BiConsumer<class_2338, class_2680> placer, BiFunction<class_3746, class_2338, Boolean> predicate, class_5819 random, class_2338 centerPos, float xzRadius, float yRadius, class_4651 config) {
        float xzRadiusSquared = xzRadius * xzRadius;
        float yRadiusSquared = yRadius * yRadius;
        float superRadiusSquared = xzRadiusSquared * yRadiusSquared;
        FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos, config, random);
        int y = 0;
        while ((float)y <= yRadius) {
            if (!((float)y > yRadius)) {
                FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.method_10069(0, y, 0), config, random);
                FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.method_10069(0, -y, 0), config, random);
            }
            ++y;
        }
        int x = 0;
        while ((float)x <= xzRadius) {
            int z = 1;
            while ((float)z <= xzRadius) {
                if (!((float)(x * x + z * z) > xzRadiusSquared)) {
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.method_10069(x, 0, z), config, random);
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.method_10069(-x, 0, -z), config, random);
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.method_10069(-z, 0, x), config, random);
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.method_10069(z, 0, -x), config, random);
                    int y2 = 1;
                    while ((float)y2 <= yRadius) {
                        float xzSquare = (float)(x * x + z * z) * yRadiusSquared;
                        if (xzSquare + (float)(y2 * y2) * xzRadiusSquared <= superRadiusSquared) {
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.method_10069(x, y2, z), config, random);
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.method_10069(-x, y2, -z), config, random);
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.method_10069(-z, y2, x), config, random);
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.method_10069(z, y2, -x), config, random);
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.method_10069(x, -y2, z), config, random);
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.method_10069(-x, -y2, -z), config, random);
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.method_10069(-z, -y2, x), config, random);
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.method_10069(z, -y2, -x), config, random);
                        }
                        ++y2;
                    }
                }
                ++z;
            }
            ++x;
        }
    }

    public static boolean placeIfValidTreePos(class_3746 world, BiConsumer<class_2338, class_2680> placer, class_5819 random, class_2338 pos, class_4651 config) {
        if (class_2944.method_27371((class_3746)world, (class_2338)pos)) {
            placer.accept(pos, config.method_23455(random, pos));
            return true;
        }
        return false;
    }

    public static boolean placeIfValidRootPos(class_3746 world, BiConsumer<class_2338, class_2680> placer, class_5819 random, class_2338 pos, class_4651 config) {
        if (FeatureLogic.canRootGrowIn(world, pos)) {
            placer.accept(pos, config.method_23455(random, pos));
            return true;
        }
        return false;
    }

    public static void addFirefly(class_1936 world, class_2338 pos, int height, double angle) {
        int iAngle = (int)(angle * 4.0);
        if (iAngle == 0) {
            FeaturePlacers.setIfEmpty(world, pos.method_10069(1, height, 0), (class_2680)((class_2248)TFBlocks.FIREFLY.get()).method_9564().method_11657((class_2769)class_2318.field_10927, (Comparable)class_2350.field_11034));
        } else if (iAngle == 1) {
            FeaturePlacers.setIfEmpty(world, pos.method_10069(-1, height, 0), (class_2680)((class_2248)TFBlocks.FIREFLY.get()).method_9564().method_11657((class_2769)class_2318.field_10927, (Comparable)class_2350.field_11039));
        } else if (iAngle == 2) {
            FeaturePlacers.setIfEmpty(world, pos.method_10069(0, height, 1), (class_2680)((class_2248)TFBlocks.FIREFLY.get()).method_9564().method_11657((class_2769)class_2318.field_10927, (Comparable)class_2350.field_11035));
        } else if (iAngle == 3) {
            FeaturePlacers.setIfEmpty(world, pos.method_10069(0, height, -1), (class_2680)((class_2248)TFBlocks.FIREFLY.get()).method_9564().method_11657((class_2769)class_2318.field_10927, (Comparable)class_2350.field_11043));
        }
    }

    private static void setIfEmpty(class_1936 world, class_2338 pos, class_2680 state) {
        if (world.method_22347(pos)) {
            world.method_8652(pos, state, 3);
        }
    }

    public static class_2680 transferAllStateKeys(class_2680 stateIn, class_2248 blockOut) {
        return FeaturePlacers.transferAllStateKeys(stateIn, blockOut.method_9564());
    }

    public static class_2680 transferAllStateKeys(class_2680 stateIn, class_2680 stateOut) {
        for (class_2769 property : stateOut.method_28501()) {
            stateOut = FeaturePlacers.transferStateKey(stateIn, stateOut, property);
        }
        return stateOut;
    }

    public static <T extends Comparable<T>> class_2680 transferStateKey(class_2680 stateIn, class_2680 stateOut, class_2769<T> property) {
        if (!stateIn.method_28498(property) || !stateOut.method_28498(property)) {
            return stateOut;
        }
        return (class_2680)stateOut.method_11657(property, stateIn.method_11654(property));
    }

    public static void traceRoot(class_3746 worldReader, BiConsumer<class_2338, class_2680> worldPlacer, class_5819 random, class_4651 dirtRoot, Iterable<class_2338> posTracer) {
        for (class_2338 rootPos : posTracer) {
            if (worldReader.method_16358(rootPos, FeatureLogic.ROOT_SHOULD_SKIP) || FeaturePlacers.placeIfValidRootPos(worldReader, worldPlacer, random, rootPos, dirtRoot)) continue;
            return;
        }
    }

    public static void traceExposedRoot(class_3746 worldReader, BiConsumer<class_2338, class_2680> worldPlacer, class_5819 random, class_4651 exposedRoot, class_4651 dirtRoot, Iterable<class_2338> posTracer) {
        for (class_2338 exposedPos : posTracer) {
            if (worldReader.method_16358(exposedPos, FeatureLogic.ROOT_SHOULD_SKIP)) continue;
            if (!FeatureLogic.hasEmptyHorizontalNeighbor(worldReader, exposedPos)) {
                if (FeaturePlacers.placeIfValidRootPos(worldReader, worldPlacer, random, exposedPos, dirtRoot)) {
                    FeaturePlacers.traceRoot(worldReader, worldPlacer, random, dirtRoot, posTracer);
                }
                return;
            }
            if (!worldReader.method_16358(exposedPos, FeatureLogic::worldGenReplaceable)) {
                return;
            }
            worldPlacer.accept(exposedPos, exposedRoot.method_23455(random, exposedPos));
        }
    }
}

