/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.chunkgenerators.warp;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.floats.Float2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectSortedMap;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.stream.Stream;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6899;
import org.jetbrains.annotations.NotNull;
import twilightforest.util.Codecs;

public final class TerrainColumn
implements Comparable<TerrainColumn> {
    public static final Codec<TerrainColumn> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6899.method_40400((class_5321)class_2378.field_25114).fieldOf("key_biome").forGetter(o -> o.keyBiome), (App)Codecs.floatTreeCodec(class_1959.field_24677).fieldOf("biome_layers").forGetter(o -> o.biomes), (App)Codec.FLOAT.fieldOf("depth").forGetter(o -> Float.valueOf(o.noiseDepth)), (App)Codec.FLOAT.fieldOf("scale").forGetter(o -> Float.valueOf(o.noiseScale))).apply((Applicative)instance, TerrainColumn::new));
    private final class_5321<class_1959> resourceKey;
    private final class_6880<class_1959> keyBiome;
    private final Float2ObjectSortedMap<class_6880<class_1959>> biomes;
    private final float noiseDepth;
    private final float noiseScale;

    public TerrainColumn(class_6880<class_1959> keyBiome, Float2ObjectSortedMap<class_6880<class_1959>> biomes, float noiseDepth, float noiseScale) {
        this.keyBiome = keyBiome;
        this.resourceKey = (class_5321)this.keyBiome.method_40230().get();
        this.biomes = biomes;
        this.noiseDepth = noiseDepth;
        this.noiseScale = noiseScale;
        if (biomes instanceof Float2ObjectAVLTreeMap) {
            Float2ObjectAVLTreeMap treeMap = (Float2ObjectAVLTreeMap)biomes;
            treeMap.defaultReturnValue(this.keyBiome);
        }
    }

    public Stream<class_6880<class_1959>> getBiomes() {
        return this.biomes.float2ObjectEntrySet().stream().map(Map.Entry::getValue);
    }

    public boolean is(class_6880<class_1959> biome) {
        return ((class_1959)this.keyBiome.comp_349()).equals(biome.comp_349());
    }

    public boolean is(class_5321<class_1959> biome) {
        return this.keyBiome.method_40225(biome);
    }

    public class_6880<class_1959> getBiome(int biomeElevation, class_6880<class_1959> other) {
        return this.reduce((a, b) -> {
            float aDelta = a.getFloatKey() - (float)biomeElevation;
            float bDelta = b.getFloatKey() - (float)biomeElevation;
            return Math.abs(aDelta) <= Math.abs(bDelta) ? a : b;
        }, other);
    }

    private class_6880<class_1959> reduce(BinaryOperator<Float2ObjectMap.Entry<class_6880<class_1959>>> reducer, class_6880<class_1959> other) {
        return this.biomes.float2ObjectEntrySet().stream().reduce(reducer).map(Map.Entry::getValue).orElse(other);
    }

    public float depth() {
        return this.noiseDepth;
    }

    public float scale() {
        return this.noiseScale;
    }

    public class_5321<class_1959> getResourceKey() {
        return this.resourceKey;
    }

    @Override
    public int compareTo(@NotNull TerrainColumn o) {
        return (int)(this.noiseDepth - o.noiseDepth);
    }
}

