/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature;

import com.mojang.serialization.Codec;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6016;
import net.minecraft.class_6019;
import twilightforest.data.custom.stalactites.entry.Stalactite;
import twilightforest.util.FeatureLogic;

public class BlockSpikeFeature
extends class_3031<class_3111> {
    public static final Stalactite STONE_STALACTITE = new Stalactite(class_2246.field_10340, 0.25f, 11, 1);

    public BlockSpikeFeature(Codec<class_3111> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<class_3111> context) {
        class_5819 random = context.method_33654();
        return BlockSpikeFeature.startSpike(context.method_33652(), context.method_33655(), STONE_STALACTITE, random, false);
    }

    public static boolean startSpike(class_5281 level, class_2338 startPos, Stalactite config, class_5819 random, boolean hanging) {
        class_6019 lengthBounds = class_6019.method_35017((int)((int)((float)config.maxLength() * config.sizeVariation())), (int)config.maxLength());
        return BlockSpikeFeature.startSpike(level, startPos, config.ore(), lengthBounds.method_35008(random), lengthBounds.method_35009(), class_6016.method_34998((int)4).method_35008(random), hanging, random);
    }

    public static boolean startSpike(class_5281 level, class_2338 startPos, class_2248 ore, int length, int lengthMinimum, int clearance, boolean hang, class_5819 random) {
        class_2338.class_2339 movingPos = startPos.method_25503();
        int clearedLength = 0;
        int dY = hang ? -1 : 1;
        int i = 0;
        while (i < length) {
            clearedLength = i++;
            if (FeatureLogic.worldGenReplaceable(level.method_8320((class_2338)movingPos))) break;
            movingPos.method_10100(0, dY, 0);
        }
        movingPos.method_10100(0, dY, 0);
        int remainingScanLength = length - clearedLength + clearance;
        int finalLength = clearedLength - clearance;
        for (int i2 = 0; i2 < remainingScanLength; ++i2) {
            finalLength = clearedLength + i2;
            if (!FeatureLogic.worldGenReplaceable(level.method_8320((class_2338)movingPos))) break;
            movingPos.method_10100(0, dY, 0);
        }
        if ((finalLength = Math.min(length, finalLength)) < lengthMinimum) {
            return false;
        }
        return BlockSpikeFeature.makeSpike(level, startPos, ore, finalLength, dY, random, hang);
    }

    private static boolean makeSpike(class_5281 level, class_2338 startPos, class_2248 ore, int length, int dY, class_5819 random, boolean hang) {
        int diameter = (int)((float)length / 4.5f);
        if (!hang && !FeatureLogic.worldGenReplaceable(level.method_8320(startPos.method_10074()))) {
            return false;
        }
        for (int dx = -diameter; dx <= diameter; ++dx) {
            for (int dz = -diameter; dz <= diameter; ++dz) {
                int absz;
                int absx = Math.abs(dx);
                int dist = (int)((float)Math.max(absx, absz = Math.abs(dz)) + (float)Math.min(absx, absz) * 0.5f);
                int spikeLength = dist <= 0 ? length : random.method_43048((int)((float)length / ((float)dist + 0.25f)));
                for (int i = -1; i < spikeLength; ++i) {
                    class_2338 placement = startPos.method_10069(dx, i * dY, dz);
                    if (!FeatureLogic.worldGenReplaceable(level.method_8320(placement)) || dY <= 0 && placement.method_10264() >= level.method_8624(class_2902.class_2903.field_13203, placement.method_10263(), placement.method_10260()) - 1) continue;
                    level.method_8652(placement, ore.method_9564(), 3);
                }
            }
        }
        return true;
    }

    public static Stalactite makeRandomOreStalactite(class_5819 rand, int hillSize) {
        if (hillSize >= 3 && rand.method_43048(5) == 0) {
            return Stalactite.getStalactiteConfig().getRandomStalactiteFromList(rand, Stalactite.getStalactiteConfig().getLargeStalactites());
        }
        if (hillSize >= 2 && rand.method_43048(5) == 0) {
            return Stalactite.getStalactiteConfig().getRandomStalactiteFromList(rand, Stalactite.getStalactiteConfig().getMediumStalactites());
        }
        return Stalactite.getStalactiteConfig().getRandomStalactiteFromList(rand, Stalactite.getStalactiteConfig().getSmallStalactites());
    }
}

