/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.templates;

import com.google.common.collect.ImmutableSet;
import com.google.common.math.StatsAccumulator;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2776;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3341;
import net.minecraft.class_3485;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3614;
import net.minecraft.class_3730;
import net.minecraft.class_3828;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.entity.monster.Wraith;
import twilightforest.init.TFEntities;
import twilightforest.loot.TFLootTables;
import twilightforest.world.registration.TFStructureProcessors;

public class GraveyardFeature
extends class_3031<class_3111> {
    private static final class_2960 GRAVEYARD = TwilightForestMod.prefix("feature/graveyard/graveyard");
    private static final class_2960 TRAP = TwilightForestMod.prefix("feature/graveyard/grave_trap");
    private static final ImmutableSet<class_3614> MATERIAL_WHITELIST = ImmutableSet.of((Object)class_3614.field_15941, (Object)class_3614.field_15945, (Object)class_3614.field_15923, (Object)class_3614.field_15932, (Object)class_3614.field_15935, (Object)class_3614.field_15914, (Object[])new class_3614[0]);

    public GraveyardFeature(Codec<class_3111> config) {
        super(config);
    }

    private static boolean offsetToAverageGroundLevel(class_5281 world, class_2338.class_2339 startPos, class_2382 size) {
        StatsAccumulator heights = new StatsAccumulator();
        for (int dx = 0; dx < size.method_10263(); ++dx) {
            for (int dz = 0; dz < size.method_10260(); ++dz) {
                int y;
                int x = startPos.method_10263() + dx;
                int z = startPos.method_10260() + dz;
                for (y = world.method_8624(class_2902.class_2903.field_13203, x, z); y >= 0; --y) {
                    class_2680 state = world.method_8320(new class_2338(x, y, z));
                    if (GraveyardFeature.isBlockNotOk(state)) {
                        return false;
                    }
                    if (GraveyardFeature.isBlockOk(state)) break;
                }
                if (y < 0) {
                    return false;
                }
                heights.add((double)y);
            }
        }
        if (heights.populationStandardDeviation() > 2.0) {
            return false;
        }
        int baseY = (int)Math.round(heights.mean());
        int maxY = (int)heights.max();
        startPos.method_33098(baseY);
        return GraveyardFeature.isAreaClear((class_1922)world, startPos.method_10086(maxY - baseY + 1), startPos.method_10081(size));
    }

    private static boolean isAreaClear(class_1922 world, class_2338 min, class_2338 max) {
        for (class_2338 pos : class_2338.method_10097((class_2338)min, (class_2338)max)) {
            class_3614 material = world.method_8320(pos).method_26207();
            if (material.method_15800() || MATERIAL_WHITELIST.contains((Object)material) || material.method_15797()) continue;
            return false;
        }
        return true;
    }

    private static boolean isBlockOk(class_2680 state) {
        class_3614 material = state.method_26207();
        return material == class_3614.field_15914 || material == class_3614.field_15941 || material == class_3614.field_15945 || material == class_3614.field_15916;
    }

    private static boolean isBlockNotOk(class_2680 state) {
        class_3614 material = state.method_26207();
        return material == class_3614.field_15920 || material == class_3614.field_15922 || state.method_26204() == class_2246.field_9987;
    }

    public boolean method_13151(class_5821<class_3111> ctx) {
        class_5281 world = ctx.method_33652();
        class_2338 pos = ctx.method_33655();
        class_5819 rand = ctx.method_33654();
        int flags = 19;
        class_5819 random = world.method_8409();
        class_3485 templatemanager = world.method_8410().method_8503().method_27727();
        class_3499 base = templatemanager.method_15091(GRAVEYARD);
        if (base == null) {
            return false;
        }
        ArrayList<Pair> graves = new ArrayList<Pair>();
        class_3499 trap = templatemanager.method_15091(TRAP);
        if (trap == null) {
            return false;
        }
        for (GraveType type : GraveType.VALUES) {
            class_3499 grave = templatemanager.method_15091(type.RL);
            if (grave == null) {
                return false;
            }
            graves.add(Pair.of((Object)((Object)type), (Object)grave));
        }
        class_2470[] rotations = class_2470.values();
        class_2470 rotation = rotations[random.method_43048(rotations.length)];
        class_2415[] mirrors = class_2415.values();
        class_2415 mirror = mirrors[random.method_43048(mirrors.length + 1) % mirrors.length];
        class_2382 transformedSize = base.method_15166(rotation);
        class_2382 transformedGraveSize = ((class_3499)((Pair)graves.get(0)).getValue()).method_15166(rotation);
        class_1923 chunkpos = new class_1923(pos.method_10069(-8, 0, -8));
        class_1923 chunkendpos = new class_1923(pos.method_10069(-8, 0, -8).method_10081(transformedSize));
        class_3341 structureboundingbox = new class_3341(chunkpos.method_8326() + 8, 0, chunkpos.method_8328() + 8, chunkendpos.method_8327() + 8, 255, chunkendpos.method_8329() + 8);
        class_3492 placementsettings = new class_3492().method_15125(mirror).method_15123(rotation).method_15126(structureboundingbox).method_15112(random);
        class_2338 posSnap = chunkpos.method_8323().method_10069(8, pos.method_10264() - 1, 8);
        class_2338.class_2339 startPos = new class_2338.class_2339(posSnap.method_10263(), posSnap.method_10264(), posSnap.method_10260());
        if (!GraveyardFeature.offsetToAverageGroundLevel(world, startPos, transformedSize)) {
            return false;
        }
        class_2338 placementPos = base.method_15167((class_2338)startPos, mirror, rotation).method_10069(1, -1, 0);
        class_2382 size = transformedSize.method_34592(-1, 0, -1);
        class_2382 graveSize = transformedGraveSize.method_34592(-1, 0, -1);
        base.method_15172((class_5425)world, placementPos, placementPos, placementsettings.method_16184((class_3491)new WebTemplateProcessor()), random, flags);
        ArrayList data = new ArrayList(base.method_16445(placementPos, placementsettings, class_2246.field_10465));
        class_2338 start = startPos.method_10069(1, 1, 0);
        class_2338 end = start.method_10069(size.method_10263(), 0, size.method_10260());
        for (int x = 1; x <= size.method_10263() - 1; ++x) {
            for (int z = 1; z <= size.method_10260() - 1; ++z) {
                if (!world.method_22347(start.method_10069(x, 0, z)) || rand.method_43048(12) != 0) continue;
                world.method_8652(start.method_10069(x, 0, z), class_2246.field_10343.method_9564(), flags);
            }
        }
        class_2338 inner = start.method_10069(2, 0, 2);
        class_2338 bound = end.method_10069(-2, 0, -2);
        class_2338 innerSize = new class_2338(bound.method_10263() - inner.method_10263(), bound.method_10264() - inner.method_10264(), bound.method_10260() - inner.method_10260());
        class_2338 fixed = inner.method_10069((rotation == class_2470.field_11464 ? graveSize.method_10263() : 0) + (mirror == class_2415.field_11301 ? transformedGraveSize.method_10263() - 1 : 0) * (rotation == class_2470.field_11464 ? -1 : 1), 0, (rotation == class_2470.field_11465 ? graveSize.method_10260() : 0) + (mirror == class_2415.field_11301 ? transformedGraveSize.method_10260() - 1 : 0) * (rotation == class_2470.field_11465 ? -1 : 1));
        class_2338 fixedSize = innerSize.method_10069(-graveSize.method_10263(), 0, -graveSize.method_10260());
        class_2338 chestloc = new class_2338(random.method_43048(2) - (mirror == class_2415.field_11301 ? 1 : 0), 1, 0).method_10070(rotation);
        for (int x = 0; x <= fixedSize.method_10263(); x += rotation == class_2470.field_11463 || rotation == class_2470.field_11465 ? 2 : 5) {
            for (int z = 0; z <= fixedSize.method_10260(); z += rotation == class_2470.field_11467 || rotation == class_2470.field_11464 ? 2 : 5) {
                if (x == innerSize.method_10263() / 2 || z == innerSize.method_10260() / 2) continue;
                class_2338 placement = fixed.method_10069(x, -2, z);
                Pair grave = (Pair)graves.get(rand.method_43048(graves.size()));
                ((class_3499)grave.getValue()).method_15172((class_5425)world, placement, placement, placementsettings, random, flags);
                data.addAll(((class_3499)grave.getValue()).method_16445(placement, placementsettings, class_2246.field_10465));
                if (grave.getKey() != GraveType.Full || !random.method_43056()) continue;
                if (random.method_43048(3) == 0) {
                    placement = placement.method_10081((class_2382)new class_2338(mirror == class_2415.field_11301 ? 1 : -1, 0, mirror == class_2415.field_11300 ? 1 : -1).method_10070(rotation));
                    trap.method_15172((class_5425)world, placement, placement, placementsettings, random, flags);
                }
                data.addAll(trap.method_16445(placementPos, placementsettings, class_2246.field_10465));
                if (world.method_8652(placement.method_10081((class_2382)chestloc), ((class_2680)class_2246.field_10380.method_9564().method_11657((class_2769)class_2281.field_10768, (Comparable)class_2350.field_11039)).method_26186(rotation).method_26185(mirror), flags)) {
                    TFLootTables.GRAVEYARD.generateChestContents(world, placement.method_10081((class_2382)chestloc));
                    world.method_8652(placement.method_10081((class_2382)chestloc).method_10074(), class_2246.field_9989.method_9564(), 3);
                }
                Wraith wraith = new Wraith((class_1299<? extends Wraith>)((class_1299)TFEntities.WRAITH.get()), (class_1937)world.method_8410());
                wraith.method_5814(placement.method_10263(), placement.method_10264(), placement.method_10260());
                wraith.method_5943((class_5425)world, world.method_8404(placement), class_3730.field_16474, null, null);
                world.method_8649((class_1297)wraith);
            }
        }
        data.forEach(info -> {
            if (info.field_15595 != null && class_2776.valueOf((String)info.field_15595.method_10558("mode")) == class_2776.field_12696) {
                String s = info.field_15595.method_10558("metadata");
                class_2338 p = info.field_15597;
                if ("spawner".equals(s)) {
                    class_2636 ms;
                    world.method_8650(p, false);
                    if (random.method_43048(4) == 0 && world.method_8652(p, class_2246.field_10260.method_9564(), 3) && (ms = (class_2636)world.method_8321(p)) != null) {
                        ms.method_11390().method_8274((class_1299)TFEntities.RISING_ZOMBIE.get());
                    }
                }
            }
        });
        return true;
    }

    private static enum GraveType {
        Full(TwilightForestMod.prefix("feature/graveyard/grave_full")),
        Upper(TwilightForestMod.prefix("feature/graveyard/grave_upper")),
        Lower(TwilightForestMod.prefix("feature/graveyard/grave_lower"));

        private static final GraveType[] VALUES;
        private final class_2960 RL;

        private GraveType(class_2960 rl) {
            this.RL = rl;
        }

        static {
            VALUES = GraveType.values();
        }
    }

    public static class WebTemplateProcessor
    extends class_3491 {
        public static final WebTemplateProcessor INSTANCE = new WebTemplateProcessor();
        public static final Codec<WebTemplateProcessor> CODEC = Codec.unit(() -> INSTANCE);

        private WebTemplateProcessor() {
        }

        protected class_3828<?> method_16772() {
            return (class_3828)TFStructureProcessors.WEB.get();
        }

        @Nullable
        public class_3499.class_3501 method_15110(class_4538 worldIn, class_2338 pos, class_2338 piecepos, class_3499.class_3501 p_process_3_, class_3499.class_3501 blockInfo, class_3492 settings) {
            return blockInfo.field_15596.method_26204() == class_2246.field_10219 ? blockInfo : (settings.method_15115(pos).method_43048(5) == 0 ? new class_3499.class_3501(pos, class_2246.field_10343.method_9564(), null) : blockInfo);
        }
    }
}

