/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees;

import com.mojang.serialization.Codec;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2381;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4625;
import net.minecraft.class_4635;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import twilightforest.init.TFBlocks;
import twilightforest.util.FeatureLogic;
import twilightforest.util.VoxelBresenhamIterator;

@ParametersAreNonnullByDefault
public abstract class CanopyMushroomFeature
extends class_4625 {
    private int bugsLeft;

    public CanopyMushroomFeature(Codec<class_4635> featureConfigurationCodec) {
        super(featureConfigurationCodec);
    }

    protected int method_23372(int i, int i1, int foliageRadius, int treeHeight) {
        return treeHeight <= 3 ? 0 : (int)((float)foliageRadius * 1.5f);
    }

    protected void method_23376(class_1936 levelAccessor, class_5819 random, class_2338 pos, class_4635 featureConfiguration, int height, class_2338.class_2339 mutableBlockPos) {
        for (int i = 0; i < height; ++i) {
            mutableBlockPos.method_10101((class_2382)pos).method_10104(class_2350.field_11036, i);
            if (!levelAccessor.method_8320((class_2338)mutableBlockPos).method_26216((class_1922)levelAccessor, (class_2338)mutableBlockPos)) {
                this.method_13153((class_1945)levelAccessor, (class_2338)mutableBlockPos, featureConfiguration.field_21231.method_23455(random, pos));
                if (this.bugsLeft <= 0 || i <= height / 2 || random.method_43048(10) != 9) continue;
                this.addFirefly(levelAccessor, (class_2338)mutableBlockPos, random);
                continue;
            }
            height = i;
            break;
        }
        int numBranches = this.getBranches(random);
        float offset = random.method_43057();
        for (int b = 0; b < numBranches; ++b) {
            this.buildABranch(levelAccessor, pos, height - 6 + b, this.getLength(random), 0.3 * (double)b + (double)offset, random, new class_4635(featureConfiguration.field_21230, featureConfiguration.field_21231, featureConfiguration.field_21232 - 1));
        }
    }

    protected void addFirefly(class_1936 levelAccessor, class_2338 pos, class_5819 random) {
        class_2350 direction = class_2350.method_10162((class_5819)random);
        if (direction.method_10166() != class_2350.class_2351.field_11052) {
            class_2338.class_2339 bugPos = new class_2338.class_2339();
            bugPos.method_10101((class_2382)pos).method_10098(direction);
            if (!levelAccessor.method_8320((class_2338)bugPos).method_26216((class_1922)levelAccessor, (class_2338)bugPos)) {
                class_2680 bugState = (class_2680)((class_2248)TFBlocks.FIREFLY.get()).method_9564().method_11657((class_2769)class_2318.field_10927, (Comparable)direction);
                this.method_13153((class_1945)levelAccessor, (class_2338)bugPos, bugState);
                --this.bugsLeft;
            }
        }
    }

    protected int method_23377(class_5819 random) {
        return 9 + random.method_43048(5);
    }

    protected abstract int getBranches(class_5819 var1);

    protected abstract double getLength(class_5819 var1);

    private void buildABranch(class_1936 levelAccessor, class_2338 pos, int height, double length, double angle, class_5819 random, class_4635 featureConfiguration) {
        class_2680 blockstate;
        class_2338 src = pos.method_10086(height);
        class_2338 dest = FeatureLogic.translate(src, length, angle, 0.2);
        for (class_2338 pixel : new VoxelBresenhamIterator(src, new class_2338(dest.method_10263(), src.method_10264(), dest.method_10260()))) {
            blockstate = featureConfiguration.field_21231.method_23455(random, pos);
            if (blockstate.method_28498((class_2769)class_2381.field_11166) && blockstate.method_28498((class_2769)class_2381.field_11169)) {
                blockstate = (class_2680)((class_2680)blockstate.method_11657((class_2769)class_2381.field_11169, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2381.field_11166, (Comparable)Boolean.valueOf(true));
            }
            this.method_13153((class_1945)levelAccessor, pixel, blockstate);
        }
        int max = Math.max(src.method_10264(), dest.method_10264());
        for (int i = Math.min(src.method_10264(), dest.method_10264()); i < max + 1; ++i) {
            blockstate = featureConfiguration.field_21231.method_23455(random, pos);
            if (blockstate.method_28498((class_2769)class_2381.field_11169) && i == Math.min(src.method_10264(), dest.method_10264())) {
                blockstate = (class_2680)blockstate.method_11657((class_2769)class_2381.field_11169, (Comparable)Boolean.valueOf(true));
            }
            class_2338 blockPos = new class_2338(dest.method_10263(), i, dest.method_10260());
            this.method_13153((class_1945)levelAccessor, blockPos, blockstate);
            if (this.bugsLeft <= 0 || i <= Math.min(src.method_10264(), dest.method_10264()) / 2 || random.method_43048(20) != 0) continue;
            this.addFirefly(levelAccessor, blockPos, random);
        }
        this.method_23375(levelAccessor, random, dest, 1, new class_2338.class_2339(), featureConfiguration);
    }

    protected void method_23375(class_1936 levelAccessor, class_5819 random, class_2338 pos, int height, class_2338.class_2339 mutableBlockPos, class_4635 featureConfiguration) {
        int i = featureConfiguration.field_21232;
        for (int x = -i; x <= i; ++x) {
            for (int z = -i; z <= i; ++z) {
                boolean zMinMax;
                boolean xIsMin = x == -i;
                boolean xIsMax = x == i;
                boolean zIsMin = z == -i;
                boolean zIsMax = z == i;
                boolean xMinMax = xIsMin || xIsMax;
                boolean bl = zMinMax = zIsMin || zIsMax;
                if (xMinMax && zMinMax) continue;
                mutableBlockPos.method_25504((class_2382)pos, x, height, z);
                if (levelAccessor.method_8320((class_2338)mutableBlockPos).method_26216((class_1922)levelAccessor, (class_2338)mutableBlockPos)) continue;
                boolean xMinOrZ = xIsMin || zMinMax && x == 1 - i;
                boolean xMaxOrZ = xIsMax || zMinMax && x == i - 1;
                boolean zMinOrX = zIsMin || xMinMax && z == 1 - i;
                boolean zMaxOrX = zIsMax || xMinMax && z == i - 1;
                class_2680 blockstate = featureConfiguration.field_21230.method_23455(random, pos);
                if (blockstate.method_28498((class_2769)class_2381.field_11167) && blockstate.method_28498((class_2769)class_2381.field_11172) && blockstate.method_28498((class_2769)class_2381.field_11171) && blockstate.method_28498((class_2769)class_2381.field_11170)) {
                    blockstate = (class_2680)((class_2680)((class_2680)((class_2680)blockstate.method_11657((class_2769)class_2381.field_11167, (Comparable)Boolean.valueOf(xMinOrZ))).method_11657((class_2769)class_2381.field_11172, (Comparable)Boolean.valueOf(xMaxOrZ))).method_11657((class_2769)class_2381.field_11171, (Comparable)Boolean.valueOf(zMinOrX))).method_11657((class_2769)class_2381.field_11170, (Comparable)Boolean.valueOf(zMaxOrX));
                }
                this.method_13153((class_1945)levelAccessor, (class_2338)mutableBlockPos, blockstate);
            }
        }
    }

    public boolean method_13151(class_5821<class_4635> context) {
        this.bugsLeft = Math.max(0, context.method_33654().method_43048(10) - 4) / 2;
        return super.method_13151(context);
    }
}

