/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import io.github.fabricators_of_create.porting_lib.util.IPlantable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3746;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import twilightforest.init.TFBlocks;
import twilightforest.util.FeatureLogic;
import twilightforest.util.FeaturePlacers;
import twilightforest.util.FeatureUtil;
import twilightforest.world.components.feature.config.TFTreeFeatureConfig;
import twilightforest.world.components.feature.trees.CanopyTreeFeature;

@ParametersAreNonnullByDefault
public class OakCanopyTreeFeature
extends CanopyTreeFeature {
    private final List<class_2338> leaves = FabricLoader.getInstance().isModLoaded("c2me") ? new CopyOnWriteArrayList<class_2338>() : Lists.newArrayList();

    public OakCanopyTreeFeature(Codec<TFTreeFeatureConfig> config) {
        super(config);
    }

    @Override
    protected boolean generate(class_5281 world, class_5819 random, class_2338 pos, BiConsumer<class_2338, class_2680> trunkPlacer, BiConsumer<class_2338, class_2680> leavesPlacer, BiConsumer<class_2338, class_2680> decorationPlacer, TFTreeFeatureConfig config) {
        int treeHeight = config.minHeight;
        if (random.method_43048(config.chanceAddFiveFirst) == 0) {
            treeHeight += random.method_43048(treeHeight / 2);
            if (random.method_43048(config.chanceAddFiveSecond) == 0) {
                treeHeight += random.method_43048(5);
            }
        }
        if (world.method_31601(pos.method_10264() + treeHeight)) {
            return false;
        }
        class_2680 state = world.method_8320(pos.method_10074());
        if (!state.method_26204().canSustainPlant(state, (class_1922)world, pos.method_10074(), class_2350.field_11036, (IPlantable)TFBlocks.CANOPY_SAPLING.get())) {
            return false;
        }
        this.leaves.clear();
        this.buildTrunk((class_1936)world, trunkPlacer, random, pos, treeHeight, config);
        int numBranches = 12 + random.method_43048(9);
        float bangle = random.method_43057();
        for (int b = 0; b < numBranches; ++b) {
            float btilt = 0.15f + random.method_43057() * 0.35f;
            this.buildBranch((class_1936)world, pos, trunkPlacer, treeHeight - 10 + b / 2, 5.0, bangle, btilt, false, random, config);
            bangle += random.method_43057() * 0.4f;
            if (!(bangle > 1.0f)) continue;
            bangle -= 1.0f;
        }
        for (class_2338 leafPos : this.leaves) {
            this.makeLeafBlob((class_3746)world, leavesPlacer, random, leafPos, config);
        }
        OakCanopyTreeFeature.makeRoots((class_1936)world, trunkPlacer, decorationPlacer, random, pos, config);
        OakCanopyTreeFeature.makeRoots((class_1936)world, trunkPlacer, decorationPlacer, random, pos.method_10078(), config);
        OakCanopyTreeFeature.makeRoots((class_1936)world, trunkPlacer, decorationPlacer, random, pos.method_10072(), config);
        OakCanopyTreeFeature.makeRoots((class_1936)world, trunkPlacer, decorationPlacer, random, pos.method_10078().method_10072(), config);
        return true;
    }

    private void makeLeafBlob(class_3746 world, BiConsumer<class_2338, class_2680> leafPlacer, class_5819 rand, class_2338 leafPos, TFTreeFeatureConfig config) {
        FeaturePlacers.placeSpheroid(world, leafPlacer, FeaturePlacers.VALID_TREE_POS, rand, leafPos, 2.5f, 2.5f, config.leavesProvider);
    }

    private static void makeRoots(class_1936 world, BiConsumer<class_2338, class_2680> trunkPlacer, BiConsumer<class_2338, class_2680> decoPlacer, class_5819 random, class_2338 pos, TFTreeFeatureConfig config) {
        if (FeatureUtil.hasAirAround(world, pos.method_10074())) {
            FeaturePlacers.placeIfValidTreePos((class_3746)world, trunkPlacer, random, pos.method_10074(), config.trunkProvider);
        } else {
            FeaturePlacers.placeIfValidRootPos((class_3746)world, decoPlacer, random, pos.method_10074(), config.rootsProvider);
        }
        int numRoots = 1 + random.method_43048(2);
        float offset = random.method_43057();
        for (int b = 0; b < numRoots; ++b) {
            FeaturePlacers.buildRoot(world, decoPlacer, random, pos, offset, b, config.rootsProvider);
        }
    }

    private void buildTrunk(class_1936 world, BiConsumer<class_2338, class_2680> trunkPlacer, class_5819 rand, class_2338 pos, int treeHeight, TFTreeFeatureConfig config) {
        class_2350 direction;
        class_2350.class_2351 axis;
        for (int dy = 0; dy < treeHeight; ++dy) {
            FeaturePlacers.placeIfValidTreePos((class_3746)world, trunkPlacer, rand, pos.method_10069(0, dy, 0), config.trunkProvider);
            FeaturePlacers.placeIfValidTreePos((class_3746)world, trunkPlacer, rand, pos.method_10069(1, dy, 0), config.trunkProvider);
            FeaturePlacers.placeIfValidTreePos((class_3746)world, trunkPlacer, rand, pos.method_10069(0, dy, 1), config.trunkProvider);
            FeaturePlacers.placeIfValidTreePos((class_3746)world, trunkPlacer, rand, pos.method_10069(1, dy, 1), config.trunkProvider);
        }
        if (rand.method_43048(3) == 0 && (axis = (direction = class_2350.method_10162((class_5819)rand)).method_10166()) != class_2350.class_2351.field_11052) {
            class_2338.class_2339 bugPos = new class_2338.class_2339();
            bugPos.method_10101((class_2382)pos.method_10069(direction == class_2350.field_11034 ? 1 : 0, rand.method_43048(treeHeight) / 2 + 10, direction == class_2350.field_11035 ? 1 : 0));
            bugPos.method_10098(direction).method_10100(axis == class_2350.class_2351.field_11051 ? rand.method_43048(2) : 0, 0, axis == class_2350.class_2351.field_11048 ? rand.method_43048(2) : 0);
            if (!world.method_8320((class_2338)bugPos).method_26216((class_1922)world, (class_2338)bugPos)) {
                class_2680 bugState = (class_2680)((class_2248)TFBlocks.FIREFLY.get()).method_9564().method_11657((class_2769)class_2318.field_10927, (Comparable)direction);
                this.method_13153((class_1945)world, (class_2338)bugPos, bugState);
            }
        }
        this.leaves.add(pos.method_10069(0, treeHeight, 0));
    }

    @Override
    void buildBranch(class_1936 world, class_2338 pos, BiConsumer<class_2338, class_2680> trunkPlacer, int height, double length, double angle, double tilt, boolean trunk, class_5819 treeRNG, TFTreeFeatureConfig config) {
        class_2338 src = pos.method_10086(height);
        class_2338 dest = FeatureLogic.translate(src, length, angle, tilt);
        int limit = 5;
        if (dest.method_10263() - pos.method_10263() < -limit) {
            dest = new class_2338(pos.method_10263() - limit, dest.method_10264(), dest.method_10260());
        }
        if (dest.method_10263() - pos.method_10263() > limit) {
            dest = new class_2338(pos.method_10263() + limit, dest.method_10264(), dest.method_10260());
        }
        if (dest.method_10260() - pos.method_10260() < -limit) {
            dest = new class_2338(dest.method_10263(), dest.method_10264(), pos.method_10260() - limit);
        }
        if (dest.method_10260() - pos.method_10260() > limit) {
            dest = new class_2338(dest.method_10263(), dest.method_10264(), pos.method_10260() + limit);
        }
        if (trunk) {
            FeaturePlacers.drawBresenhamTree((class_3746)world, trunkPlacer, FeaturePlacers.VALID_TREE_POS, src, dest, config.trunkProvider, treeRNG);
        } else {
            FeaturePlacers.drawBresenhamBranch(world, trunkPlacer, treeRNG, src, dest, config.branchProvider);
        }
        FeaturePlacers.placeIfValidTreePos((class_3746)world, trunkPlacer, treeRNG, dest.method_10078(), config.branchProvider);
        FeaturePlacers.placeIfValidTreePos((class_3746)world, trunkPlacer, treeRNG, dest.method_10067(), config.branchProvider);
        FeaturePlacers.placeIfValidTreePos((class_3746)world, trunkPlacer, treeRNG, dest.method_10095(), config.branchProvider);
        FeaturePlacers.placeIfValidTreePos((class_3746)world, trunkPlacer, treeRNG, dest.method_10072(), config.branchProvider);
        this.leaves.add(dest);
    }
}

