/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.placements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2794;
import net.minecraft.class_5444;
import net.minecraft.class_5819;
import net.minecraft.class_6797;
import net.minecraft.class_6798;
import twilightforest.init.TFFeatureModifiers;
import twilightforest.init.TFLandmark;
import twilightforest.util.LegacyLandmarkPlacements;
import twilightforest.world.components.chunkgenerators.ChunkGeneratorTwilight;

public class AvoidLandmarkModifier
extends class_6797 {
    public static final Codec<AvoidLandmarkModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("occupies_surface").forGetter(o -> o.occupiesSurface), (App)Codec.BOOL.fieldOf("occupies_underground").forGetter(o -> o.occupiesUnderground), (App)Codec.INT.fieldOf("additional_clearance").forGetter(o -> o.additionalClearance)).apply((Applicative)instance, AvoidLandmarkModifier::new)).flatXmap(AvoidLandmarkModifier::validate, AvoidLandmarkModifier::validate);
    private final boolean occupiesSurface;
    private final boolean occupiesUnderground;
    private final int additionalClearance;

    public AvoidLandmarkModifier(boolean occupiesSurface, boolean occupiesUnderground, int additionalClearance) {
        this.occupiesSurface = occupiesSurface;
        this.occupiesUnderground = occupiesUnderground;
        this.additionalClearance = additionalClearance;
    }

    public static AvoidLandmarkModifier checkSurface() {
        return new AvoidLandmarkModifier(true, false, 0);
    }

    public static AvoidLandmarkModifier checkUnderground() {
        return new AvoidLandmarkModifier(false, true, 0);
    }

    public static AvoidLandmarkModifier checkBoth() {
        return new AvoidLandmarkModifier(true, true, 0);
    }

    public Stream<class_2338> method_14452(class_5444 worldDecoratingHelper, class_5819 random, class_2338 blockPos) {
        class_2794 class_27942 = worldDecoratingHelper.method_34383().method_8410().method_14178().method_12129();
        if (!(class_27942 instanceof ChunkGeneratorTwilight)) {
            return Stream.of(blockPos);
        }
        ChunkGeneratorTwilight tfChunkGen = (ChunkGeneratorTwilight)class_27942;
        class_2338.class_2339 featurePos = LegacyLandmarkPlacements.getNearestCenterXZ(blockPos.method_10263() >> 4, blockPos.method_10260() >> 4).method_25503();
        TFLandmark landmark = tfChunkGen.pickLandmarkForChunk(new class_1923((class_2338)featurePos), worldDecoratingHelper.method_34383());
        if (!(this.occupiesSurface && !landmark.isSurfaceDecorationsAllowed() || this.occupiesUnderground && !landmark.isUndergroundDecoAllowed())) {
            return Stream.of(blockPos);
        }
        featurePos.method_10103(Math.abs(featurePos.method_10263() - blockPos.method_10263()), 0, Math.abs(featurePos.method_10260() - blockPos.method_10260()));
        int size = landmark.size * 16 + this.additionalClearance;
        return featurePos.method_10263() < size && featurePos.method_10260() < size ? Stream.empty() : Stream.of(blockPos);
    }

    public class_6798<?> method_39615() {
        return (class_6798)TFFeatureModifiers.NO_STRUCTURE.get();
    }

    private static DataResult<AvoidLandmarkModifier> validate(AvoidLandmarkModifier config) {
        return config.occupiesSurface || config.occupiesUnderground ? DataResult.success((Object)((Object)config)) : DataResult.error((String)"Feature Decorator cannot occupy neither surface nor underground");
    }
}

