/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.finalcastle;

import java.util.function.Predicate;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3614;
import net.minecraft.class_3773;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6130;
import net.minecraft.class_6625;
import net.minecraft.class_6626;
import twilightforest.init.BiomeKeys;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFLandmark;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.util.BoundingBoxUtils;
import twilightforest.util.RotationUtil;
import twilightforest.world.components.structures.TFStructureComponentOld;
import twilightforest.world.components.structures.finalcastle.FinalCastleDungeonEntranceComponent;
import twilightforest.world.components.structures.finalcastle.FinalCastleDungeonExitComponent;
import twilightforest.world.components.structures.lichtower.TowerWingComponent;

public class FinalCastleDungeonRoom31Component
extends TowerWingComponent {
    public int level;

    public FinalCastleDungeonRoom31Component(class_6625 ctx, class_2487 nbt) {
        this((class_3773)TFStructurePieceTypes.TFFCDunR31.get(), nbt);
    }

    public FinalCastleDungeonRoom31Component(class_3773 piece, class_2487 nbt) {
        super(piece, nbt);
    }

    public FinalCastleDungeonRoom31Component(class_3773 piece, TFLandmark feature, int i, int x, int y, int z, class_2350 direction, int level) {
        super(piece, feature, i, x, y, z);
        this.method_14926(direction);
        this.spawnListIndex = 2;
        this.size = 31;
        this.height = 7;
        this.level = level;
        this.field_15315 = feature.getComponentToAddBoundingBox(x, y, z, -15, 0, -15, this.size - 1, this.height - 1, this.size - 1, class_2350.field_11035);
    }

    @Override
    public void method_14918(class_3443 parent, class_6130 list, class_5819 rand) {
        int i;
        class_2470 direction;
        int maxSpread;
        if (parent instanceof TFStructureComponentOld) {
            this.deco = ((TFStructureComponentOld)parent).deco;
        }
        int mySpread = this.method_14923() - parent.method_14923();
        int n = maxSpread = this.level == 1 ? 2 : 3;
        if (mySpread == maxSpread && !this.isExitBuildForLevel(parent)) {
            direction = RotationUtil.getRandomRotation(rand);
            for (i = 0; i < 8 && !this.isExitBuildForLevel(parent); ++i) {
                if (!this.addDungeonExit(list, rand, direction = direction.method_10501(RotationUtil.ROTATIONS[i & 3]))) continue;
                this.setExitBuiltForLevel(parent, true);
            }
        }
        if (mySpread < maxSpread) {
            direction = RotationUtil.getRandomRotation(rand);
            for (i = 0; i < 12; ++i) {
                direction = direction.method_10501(RotationUtil.ROTATIONS[i & 3]);
                this.addDungeonRoom(parent, list, rand, direction, this.level);
            }
        }
    }

    private boolean isExitBuildForLevel(class_3443 parent) {
        if (parent instanceof FinalCastleDungeonEntranceComponent) {
            return ((FinalCastleDungeonEntranceComponent)parent).hasExit;
        }
        return false;
    }

    private void setExitBuiltForLevel(class_3443 parent, boolean exit) {
        if (parent instanceof FinalCastleDungeonEntranceComponent) {
            ((FinalCastleDungeonEntranceComponent)parent).hasExit = exit;
        }
    }

    protected boolean addDungeonRoom(class_3443 parent, class_6130 list, class_5819 rand, class_2470 rotation, int level) {
        rotation = rotation.method_10501(this.field_15313);
        class_2338 rc = this.getNewRoomCoords(rand, rotation);
        FinalCastleDungeonRoom31Component dRoom = new FinalCastleDungeonRoom31Component((class_3773)TFStructurePieceTypes.TFFCDunR31.get(), this.getFeatureType(), this.field_15316 + 1, rc.method_10263(), rc.method_10264(), rc.method_10260(), rotation.method_10503(class_2350.field_11035), level);
        class_3341 largerBB = BoundingBoxUtils.clone(dRoom.method_14935());
        if (list instanceof class_6626) {
            class_6626 start = (class_6626)list;
            class_3443 intersect = TFStructureComponentOld.findIntersectingExcluding(start.field_34944, largerBB, this);
            if (intersect == null) {
                list.method_35462((class_3443)dRoom);
                dRoom.method_14918(parent, list, rand);
                return true;
            }
        }
        return false;
    }

    protected boolean addDungeonExit(class_6130 list, class_5819 rand, class_2470 rotation) {
        rotation = rotation.method_10501(this.field_15313);
        class_2338 rc = this.getNewRoomCoords(rand, rotation);
        FinalCastleDungeonExitComponent dRoom = new FinalCastleDungeonExitComponent(this.getFeatureType(), this.field_15316 + 1, rc.method_10263(), rc.method_10264(), rc.method_10260(), rotation.method_10503(class_2350.field_11035), this.level);
        if (list instanceof class_6626) {
            class_6626 start = (class_6626)list;
            class_3443 intersect = TFStructureComponentOld.findIntersectingExcluding(start.field_34944, dRoom.method_14935(), this);
            if (intersect == null) {
                list.method_35462((class_3443)dRoom);
                dRoom.method_14918(this, list, rand);
                return true;
            }
        }
        return false;
    }

    private class_2338 getNewRoomCoords(class_5819 rand, class_2470 rotation) {
        int offset = rand.method_43048(15) - 9;
        if (rand.method_43056()) {
            offset += this.size;
        }
        return switch (rotation) {
            case class_2470.field_11463 -> new class_2338(this.field_15315.method_35415() + offset, this.field_15315.method_35416(), this.field_15315.method_35420() + 9);
            case class_2470.field_11464 -> new class_2338(this.field_15315.method_35415() - 9, this.field_15315.method_35416(), this.field_15315.method_35417() + offset);
            case class_2470.field_11465 -> new class_2338(this.field_15315.method_35415() + offset, this.field_15315.method_35416(), this.field_15315.method_35417() - 9);
            default -> new class_2338(this.field_15315.method_35418() + 9, this.field_15315.method_35416(), this.field_15315.method_35417() + offset);
        };
    }

    @Override
    public void method_14931(class_5281 world, class_5138 manager, class_2794 generator, class_5819 rand, class_3341 sbb, class_1923 chunkPosIn, class_2338 blockPos) {
        Predicate<class_1959> plateauBiomes = biome -> biome == world.method_30349().method_33309(class_2378.field_25114).method_29107(BiomeKeys.THORNLANDS) || biome == world.method_30349().method_33309(class_2378.field_25114).method_29107(BiomeKeys.FINAL_PLATEAU);
        if (this.isBoundingBoxOutsideBiomes(world, plateauBiomes)) {
            return;
        }
        class_5819 decoRNG = class_5819.method_43049((long)(world.method_8412() + (long)this.field_15315.method_35415() * 321534781L ^ (long)this.field_15315.method_35417() * 756839L));
        this.fillWithAir(world, sbb, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1, state -> state.method_26207() == class_3614.field_15914);
        class_2680 floor = ((class_2248)TFBlocks.CASTLE_BRICK.get()).method_9564();
        class_2680 border = ((class_2248)TFBlocks.THICK_CASTLE_BRICK.get()).method_9564();
        Predicate<class_2680> replacing = state -> {
            class_3614 material = state.method_26207();
            return material == class_3614.field_15914 || material == class_3614.field_15959;
        };
        int cs = 7;
        this.fillWithBlocks(world, sbb, 7, -1, 7, this.size - 1 - 7, -1, this.size - 1 - 7, border, floor, replacing);
        this.fillWithBlocks(world, sbb, 7, this.height, 7, this.size - 1 - 7, this.height, this.size - 1 - 7, border, floor, replacing);
        class_2680 forceField = this.getForceFieldColor(decoRNG);
        class_2680 castleMagic = this.getRuneColor(forceField);
        for (class_2470 rotation : RotationUtil.ROTATIONS) {
            this.fillBlocksRotated(world, sbb, 7, 0, 8, 7, this.height - 1, this.size - 2 - 7, forceField, rotation);
            for (int z = 7; z < this.size - 1 - 7; z += 4) {
                this.fillBlocksRotated(world, sbb, 7, 0, z, 7, this.height - 1, z, castleMagic, rotation);
                int y = (z - 7) % 8 == 0 ? decoRNG.method_43048(3) : decoRNG.method_43048(3) + 4;
                this.fillBlocksRotated(world, sbb, 7, y, z + 1, 7, y, z + 3, castleMagic, rotation);
            }
        }
    }

    protected class_2680 getRuneColor(class_2680 forceFieldColor) {
        return forceFieldColor.method_27852((class_2248)TFBlocks.GREEN_FORCE_FIELD.get()) ? ((class_2248)TFBlocks.YELLOW_CASTLE_RUNE_BRICK.get()).method_9564() : ((class_2248)TFBlocks.BLUE_CASTLE_RUNE_BRICK.get()).method_9564();
    }

    protected class_2680 getForceFieldColor(class_5819 decoRNG) {
        int i = decoRNG.method_43048(2) + 3;
        if (i == 3) {
            return ((class_2248)TFBlocks.GREEN_FORCE_FIELD.get()).method_9564();
        }
        return ((class_2248)TFBlocks.BLUE_FORCE_FIELD.get()).method_9564();
    }
}

