/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.finalcastle;

import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3773;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6130;
import net.minecraft.class_6625;
import net.minecraft.class_6626;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFLandmark;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.util.BoundingBoxUtils;
import twilightforest.util.RotationUtil;
import twilightforest.world.components.structures.TFStructureComponentOld;
import twilightforest.world.components.structures.finalcastle.FinalCastleBellTower21Component;
import twilightforest.world.components.structures.finalcastle.FinalCastleBridgeComponent;
import twilightforest.world.components.structures.finalcastle.FinalCastleDamagedTowerComponent;
import twilightforest.world.components.structures.finalcastle.FinalCastleEntranceTowerComponent;
import twilightforest.world.components.structures.finalcastle.FinalCastleFoundation13Component;
import twilightforest.world.components.structures.finalcastle.FinalCastleRoof13ConicalComponent;
import twilightforest.world.components.structures.finalcastle.FinalCastleRoof13CrenellatedComponent;
import twilightforest.world.components.structures.lichtower.TowerWingComponent;

public class FinalCastleMazeTower13Component
extends TowerWingComponent {
    public static final int LOWEST_DOOR = 108;
    public static final int HIGHEST_DOOR = 186;
    public final class_2680 color;

    public FinalCastleMazeTower13Component(class_3773 piece, class_2487 nbt) {
        super(piece, nbt);
        this.color = class_2512.method_10681((class_2487)nbt.method_10562("color"));
    }

    public FinalCastleMazeTower13Component(class_6625 ctx, class_2487 nbt) {
        this((class_3773)TFStructurePieceTypes.TFFCSiTo.get(), nbt);
    }

    public FinalCastleMazeTower13Component(class_3773 piece, TFLandmark feature, class_5819 rand, int i, int x, int y, int z, class_2680 color, class_2350 direction) {
        super(piece, feature, i, x, y, z);
        this.method_14926(direction);
        this.color = color;
        this.size = 13;
        int floors = rand.method_43048(3) + 2;
        this.height = floors * 8 + 1;
        int entranceFloor = rand.method_43048(floors);
        if (y - entranceFloor * 8 < 108) {
            entranceFloor = 0;
        }
        if (y + (floors - entranceFloor) * 8 > 186) {
            entranceFloor = floors - 1;
        }
        this.field_15315 = feature.getComponentToAddBoundingBox(x, y, z, -6, -(entranceFloor * 8), -6, this.size - 1, this.height, this.size - 1, class_2350.field_11035);
        this.addOpening(0, entranceFloor * 8 + 1, this.size / 2, class_2470.field_11464);
    }

    @Override
    protected void method_14943(class_6625 ctx, class_2487 tagCompound) {
        super.method_14943(ctx, tagCompound);
        tagCompound.method_10566("color", (class_2520)class_2512.method_10686((class_2680)this.color));
    }

    public FinalCastleMazeTower13Component(class_3773 piece, TFLandmark feature, int i, int x, int y, int z, int floors, int entranceFloor, class_2680 color, class_2350 direction) {
        super(piece, feature, i, x, y, z);
        this.method_14926(direction);
        this.color = color;
        this.size = 13;
        this.height = floors * 8 + 1;
        this.field_15315 = feature.getComponentToAddBoundingBox(x, y, z, -6, -(entranceFloor * 8), -6, this.size - 1, this.height, this.size - 1, class_2350.field_11035);
        this.addOpening(0, entranceFloor * 8 + 1, this.size / 2, class_2470.field_11464);
    }

    @Override
    public void method_14918(class_3443 parent, class_6130 list, class_5819 rand) {
        if (parent != null && parent instanceof TFStructureComponentOld) {
            this.deco = ((TFStructureComponentOld)parent).deco;
        }
        FinalCastleFoundation13Component foundation = new FinalCastleFoundation13Component((class_3773)TFStructurePieceTypes.TFFCToF13.get(), this.getFeatureType(), 4, this, this.method_35458().method_10263(), this.method_35458().method_10264(), this.method_35458().method_10260());
        list.method_35462((class_3443)foundation);
        foundation.method_14918(this, list, rand);
        TFStructureComponentOld roof = rand.method_43056() ? new FinalCastleRoof13ConicalComponent(this.getFeatureType(), rand, 4, this, this.method_35458().method_10263(), this.method_35458().method_10264(), this.method_35458().method_10260()) : new FinalCastleRoof13CrenellatedComponent(this.getFeatureType(), 4, this, this.method_35458().method_10263(), this.method_35458().method_10264(), this.method_35458().method_10260());
        list.method_35462((class_3443)roof);
        roof.method_14918(this, list, rand);
    }

    public void buildTowards(class_3443 parent, class_6130 list, class_5819 rand, class_2338 dest) {
        this.method_14918(parent, list, rand);
        if (this.method_14923() < 20) {
            if (this.isWithinRange(dest.method_10263(), dest.method_10260(), this.field_15315.method_35415() + 6, this.field_15315.method_35417() + 6, 30)) {
                int howFar = 20;
                if (!this.buildEndTowerTowards(list, rand, dest, this.findBestDirectionTowards(dest), howFar) && !this.buildEndTowerTowards(list, rand, dest, this.findSecondDirectionTowards(dest), howFar)) {
                    this.buildEndTowerTowards(list, rand, dest, this.findThirdDirectionTowards(dest), howFar);
                }
            } else {
                int howFar = 14 + rand.method_43048(24);
                class_2350 facing = this.findBestDirectionTowards(dest);
                if (!(facing != this.method_14934() && this.buildContinueTowerTowards(list, rand, dest, facing, howFar) || (facing = this.findSecondDirectionTowards(dest)) != this.method_14934() && this.buildContinueTowerTowards(list, rand, dest, facing, howFar) || (facing = this.findThirdDirectionTowards(dest)) != this.method_14934() && this.buildContinueTowerTowards(list, rand, dest, facing, howFar))) {
                    this.buildContinueTowerTowards(list, rand, dest, this.method_14934(), howFar);
                }
            }
        }
        this.buildNonCriticalTowers(list, rand);
    }

    protected void buildNonCriticalTowers(class_6130 list, class_5819 rand) {
        class_2350 dir = RotationUtil.getRandomFacing(rand);
        class_2470 relativeRotation = RotationUtil.getRelativeRotation(this.method_14934(), dir);
        if (this.openingTowards[relativeRotation.ordinal()] || this.buildDamagedTower(list, rand, dir) || !this.buildDamagedTower(list, rand, dir = RotationUtil.getRandomFacing(rand))) {
            // empty if block
        }
    }

    private class_2350 findBestDirectionTowards(class_2338 dest) {
        int cx = this.field_15315.method_35415() + 6;
        int cz = this.field_15315.method_35417() + 6;
        int dx = cx - dest.method_10263();
        int dz = cz - dest.method_10260();
        class_2350 absoluteDir = Math.abs(dx) > Math.abs(dz) ? (dx >= 0 ? class_2350.field_11034 : class_2350.field_11039) : (dz >= 0 ? class_2350.field_11035 : class_2350.field_11043);
        return absoluteDir;
    }

    private class_2350 findSecondDirectionTowards(class_2338 dest) {
        int cx = this.field_15315.method_35415() + 6;
        int cz = this.field_15315.method_35417() + 6;
        int dx = cx - dest.method_10263();
        int dz = cz - dest.method_10260();
        class_2350 absoluteDir = Math.abs(dx) < Math.abs(dz) ? (dx >= 0 ? class_2350.field_11034 : class_2350.field_11039) : (dz >= 0 ? class_2350.field_11035 : class_2350.field_11043);
        return absoluteDir;
    }

    private class_2350 findThirdDirectionTowards(class_2338 dest) {
        class_2350[] cardinals;
        class_2350 first = this.findBestDirectionTowards(dest);
        class_2350 second = this.findSecondDirectionTowards(dest);
        for (class_2350 f : cardinals = new class_2350[]{class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039}) {
            if (f == first || f == second || f == class_2470.field_11464.method_10503(this.method_14934())) continue;
            return f;
        }
        return this.method_14934();
    }

    private boolean buildContinueTowerTowards(class_6130 list, class_5819 rand, class_2338 dest, class_2350 facing, int howFar) {
        class_2338 opening = this.getValidOpeningCC(rand, facing);
        int adjustmentRange = 60;
        if (this.isWithinRange(dest.method_10263(), dest.method_10260(), this.field_15315.method_35415() + 6, this.field_15315.method_35417() + 6, adjustmentRange)) {
            opening = new class_2338(opening.method_10263(), this.adjustOpening(opening.method_10264(), dest), opening.method_10260());
        }
        class_2338 tc = this.offsetTowerCCoords(opening.method_10263(), opening.method_10264(), opening.method_10260(), howFar, facing);
        if (list instanceof class_6626) {
            int centerZ;
            class_6626 start2 = (class_6626)list;
            class_3443 start = (class_3443)start2.field_34944.get(0);
            int centerX = start.method_14935().method_35415() + 128 >> 8 << 8;
            if (this.isWithinRange(centerX, centerZ = start.method_14935().method_35417() + 128 >> 8 << 8, tc.method_10263(), tc.method_10260(), 128)) {
                FinalCastleMazeTower13Component sTower = new FinalCastleMazeTower13Component((class_3773)TFStructurePieceTypes.TFFCSiTo.get(), this.getFeatureType(), rand, this.method_14923() + 1, tc.method_10263(), tc.method_10264(), tc.method_10260(), this.color, facing);
                class_3341 largerBB = new class_3341(sTower.method_14935().method_35415() - 6, 0, sTower.method_14935().method_35417() - 6, sTower.method_14935().method_35418() + 6, 255, sTower.method_14935().method_35420() + 6);
                class_3443 intersect = list.method_35461(largerBB);
                if (intersect == null) {
                    list.method_35462((class_3443)sTower);
                    sTower.buildTowards(this, list, rand, dest);
                    class_2338 bc = this.offsetTowerCCoords(opening.method_10263(), opening.method_10264(), opening.method_10260(), 1, facing);
                    FinalCastleBridgeComponent bridge = new FinalCastleBridgeComponent(this.getFeatureType(), this.method_14923() + 1, bc.method_10263(), bc.method_10264(), bc.method_10260(), howFar - 7, facing);
                    list.method_35462((class_3443)bridge);
                    bridge.method_14918(this, list, rand);
                    this.addOpening(opening.method_10263(), opening.method_10264() + 1, opening.method_10260(), facing);
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    protected boolean buildDamagedTower(class_6130 list, class_5819 rand, class_2350 facing) {
        class_2338 opening = this.getValidOpeningCC(rand, facing);
        int howFar = 14 + rand.method_43048(24);
        class_2338 tc = this.offsetTowerCCoords(opening.method_10263(), opening.method_10264(), opening.method_10260(), howFar, facing);
        FinalCastleMazeTower13Component eTower = this.makeNewDamagedTower(rand, facing, tc);
        class_3341 largerBB = BoundingBoxUtils.cloneWithAdjustments(eTower.method_14935(), -6, 0, -6, 6, 0, 6);
        class_3443 intersect = list.method_35461(largerBB);
        if (intersect == null) {
            list.method_35462((class_3443)eTower);
            eTower.method_14918(this, list, rand);
            class_2338 bc = this.offsetTowerCCoords(opening.method_10263(), opening.method_10264(), opening.method_10260(), 1, facing);
            FinalCastleBridgeComponent bridge = new FinalCastleBridgeComponent(this.getFeatureType(), this.method_14923() + 1, bc.method_10263(), bc.method_10264(), bc.method_10260(), howFar - 7, facing);
            list.method_35462((class_3443)bridge);
            bridge.method_14918(this, list, rand);
            this.addOpening(opening.method_10263(), opening.method_10264() + 1, opening.method_10260(), facing);
            return true;
        }
        return false;
    }

    protected FinalCastleMazeTower13Component makeNewDamagedTower(class_5819 rand, class_2350 facing, class_2338 tc) {
        return new FinalCastleDamagedTowerComponent((class_3773)TFStructurePieceTypes.TFFCDamT.get(), this.getFeatureType(), rand, this.method_14923() + 1, tc.method_10263(), tc.method_10264(), tc.method_10260(), facing);
    }

    private int adjustOpening(int posY, class_2338 dest) {
        int openY = posY;
        int realOpeningY = this.method_14924(openY);
        if (realOpeningY - dest.method_10264() < 12) {
            openY = this.height - 9;
        } else if (dest.method_10264() - realOpeningY < 12) {
            openY = 0;
        }
        return openY;
    }

    private boolean buildEndTowerTowards(class_6130 list, class_5819 rand, class_2338 dest, class_2350 facing, int howFar) {
        class_2338 opening = this.getValidOpeningCC(rand, facing);
        opening = new class_2338(opening.method_10263(), this.adjustOpening(opening.method_10264(), dest), opening.method_10260());
        class_2338 tc = this.offsetTowerCCoords(opening.method_10263(), opening.method_10264(), opening.method_10260(), howFar, facing);
        FinalCastleMazeTower13Component eTower = this.color == ((class_2248)TFBlocks.YELLOW_CASTLE_RUNE_BRICK.get()).method_9564() ? new FinalCastleEntranceTowerComponent(this.getFeatureType(), this.method_14923() + 1, tc.method_10263(), tc.method_10264(), tc.method_10260(), facing) : new FinalCastleBellTower21Component(this.getFeatureType(), this.method_14923() + 1, tc.method_10263(), tc.method_10264(), tc.method_10260(), facing);
        class_3341 largerBB = BoundingBoxUtils.cloneWithAdjustments(eTower.method_14935(), -6, 0, -6, 6, 0, 6);
        class_3443 intersect = list.method_35461(largerBB);
        if (intersect == null) {
            list.method_35462((class_3443)eTower);
            eTower.method_14918(this, list, rand);
            class_2338 bc = this.offsetTowerCCoords(opening.method_10263(), opening.method_10264(), opening.method_10260(), 1, facing);
            FinalCastleBridgeComponent bridge = new FinalCastleBridgeComponent(this.getFeatureType(), this.method_14923() + 1, bc.method_10263(), bc.method_10264(), bc.method_10260(), howFar - 7, facing);
            list.method_35462((class_3443)bridge);
            bridge.method_14918(this, list, rand);
            this.addOpening(opening.method_10263(), opening.method_10264() + 1, opening.method_10260(), facing);
            return true;
        }
        return false;
    }

    private boolean isWithinRange(int centerX, int centerZ, int posX, int posZ, int range) {
        return Math.abs(centerX - posX) < range && Math.abs(centerZ - posZ) < range;
    }

    public class_2338 getValidOpeningCC(class_5819 rand, class_2350 facing) {
        class_2470 relative = RotationUtil.getRelativeRotation(this.method_14934(), facing);
        int floors = this.height / 8;
        if (relative == class_2470.field_11467 || relative == class_2470.field_11464) {
            int rx = relative == class_2470.field_11467 ? 12 : 0;
            int rz = 6;
            int ry = rand.method_43048(floors) * 8;
            return new class_2338(rx, ry, rz);
        }
        if (relative == class_2470.field_11463 || relative == class_2470.field_11465) {
            int rx = 6;
            int rz = relative == class_2470.field_11463 ? 12 : 0;
            int ry = rand.method_43048(floors) * 8;
            return new class_2338(rx, ry, rz);
        }
        return new class_2338(0, 0, 0);
    }

    @Override
    protected class_2338 offsetTowerCCoords(int x, int y, int z, int howFar, class_2350 direction) {
        int dx = this.method_14928(x, z);
        int dy = this.method_14924(y);
        int dz = this.method_14941(x, z);
        switch (direction) {
            case field_11035: {
                dx += howFar;
                break;
            }
            case field_11039: {
                dz += howFar;
                break;
            }
            case field_11043: {
                dx -= howFar;
                break;
            }
            case field_11034: {
                dz -= howFar;
                break;
            }
        }
        return new class_2338(dx, dy, dz);
    }

    @Override
    public void method_14931(class_5281 worldIn, class_5138 manager, class_2794 generator, class_5819 rand, class_3341 sbb, class_1923 chunkPosIn, class_2338 blockPos) {
        class_5819 decoRNG = class_5819.method_43049((long)(worldIn.method_8412() + (long)this.field_15315.method_35415() * 321534781L ^ (long)this.field_15315.method_35417() * 756839L));
        this.method_14938(worldIn, sbb, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1, false, rand, this.deco.randomBlocks);
        for (int x = 0; x < this.size; ++x) {
            for (int z = 0; z < this.size; ++z) {
                this.method_14936(worldIn, this.deco.blockState, x, -1, z, sbb);
            }
        }
        int numBranches = 2 + decoRNG.method_43048(4) + decoRNG.method_43048(3);
        for (int i = 0; i < numBranches; ++i) {
            this.makeGlyphBranches(worldIn, decoRNG, this.getGlyphMeta(), sbb);
        }
        this.addFloors(worldIn, sbb);
        this.makeOpenings(worldIn, sbb);
    }

    public class_2680 getGlyphMeta() {
        if (this.color == null) {
            TwilightForestMod.LOGGER.warn("Final Castle tower has null for glyph color, this is a bug.");
            return ((class_2248)TFBlocks.BLUE_CASTLE_RUNE_BRICK.get()).method_9564();
        }
        return this.color;
    }

    private void addFloors(class_5281 world, class_3341 sbb) {
        int floors = this.highestOpening / 8 + 1;
        class_2470 rotation = class_2470.field_11463;
        for (int i = 1; i < floors; ++i) {
            this.method_14940(world, sbb, 1, i * 8, 1, 11, i * 8, 11, this.deco.blockState, this.deco.blockState, false);
            rotation = rotation.method_10501(class_2470.field_11464);
            this.addStairsDown(world, sbb, rotation, i * 8);
        }
        if (this.hasAccessibleRoof()) {
            this.addStairsDown(world, sbb, RotationUtil.ROTATIONS[floors + 2 & 3], this.height - 1);
        }
    }

    protected boolean hasAccessibleRoof() {
        return this.height - this.highestOpening < 9;
    }

    private void addStairsDown(class_5281 world, class_3341 sbb, class_2470 rotation, int y) {
        int sz;
        int sy;
        int sx;
        int i;
        for (i = 0; i < 4; ++i) {
            sx = 8 - i;
            sy = y - i;
            sz = 9;
            this.setBlockStateRotated(world, FinalCastleMazeTower13Component.getStairState(this.deco.stairState, class_2350.field_11039, false), sx, sy, sz, rotation, sbb);
            this.setBlockStateRotated(world, this.deco.blockState, sx, sy - 1, sz, rotation, sbb);
            this.setBlockStateRotated(world, FinalCastleMazeTower13Component.getStairState(this.deco.stairState, class_2350.field_11039, false), sx, sy, sz - 1, rotation, sbb);
            this.setBlockStateRotated(world, this.deco.blockState, sx, sy - 1, sz - 1, rotation, sbb);
            this.fillAirRotated(world, sbb, sx, sy + 1, sz - 1, sx, sy + 3, sz, rotation);
        }
        this.fillBlocksRotated(world, sbb, 3, y - 4, 8, 4, y - 4, 9, this.deco.blockState, rotation);
        for (i = 0; i < 4; ++i) {
            sx = 4;
            sy = y - i - 4;
            sz = 7 - i;
            this.setBlockStateRotated(world, FinalCastleMazeTower13Component.getStairState(this.deco.stairState, class_2350.field_11043, false), sx, sy, sz, rotation, sbb);
            this.setBlockStateRotated(world, this.deco.blockState, sx, sy - 1, sz, rotation, sbb);
            this.setBlockStateRotated(world, FinalCastleMazeTower13Component.getStairState(this.deco.stairState, class_2350.field_11043, false), sx - 1, sy, sz, rotation, sbb);
            this.setBlockStateRotated(world, this.deco.blockState, sx - 1, sy - 1, sz, rotation, sbb);
            this.fillAirRotated(world, sbb, sx, sy + 1, sz, sx - 1, sy + 3, sz, rotation);
        }
    }

    @Override
    protected void makeDoorOpening(class_5281 world, int dx, int dy, int dz, class_3341 sbb) {
        class_2680 doorState = this.doorColor();
        if (dx == 0 || dx == this.size - 1) {
            this.method_14940(world, sbb, dx, dy - 1, dz - 2, dx, dy + 4, dz + 2, this.deco.accentState, AIR, false);
            this.method_14940(world, sbb, dx, dy, dz - 1, dx, dy + 3, dz + 1, doorState, AIR, false);
        }
        if (dz == 0 || dz == this.size - 1) {
            this.method_14940(world, sbb, dx - 2, dy - 1, dz, dx + 2, dy + 4, dz, this.deco.accentState, AIR, false);
            this.method_14940(world, sbb, dx - 1, dy, dz, dx + 1, dy + 3, dz, doorState, AIR, false);
        }
    }

    public class_2680 doorColor() {
        if (this.color == ((class_2248)TFBlocks.PINK_CASTLE_RUNE_BRICK.get()).method_9564()) {
            return ((class_2248)TFBlocks.PINK_CASTLE_DOOR.get()).method_9564();
        }
        if (this.color == ((class_2248)TFBlocks.BLUE_CASTLE_RUNE_BRICK.get()).method_9564()) {
            return ((class_2248)TFBlocks.BLUE_CASTLE_DOOR.get()).method_9564();
        }
        if (this.color == ((class_2248)TFBlocks.YELLOW_CASTLE_RUNE_BRICK.get()).method_9564()) {
            return ((class_2248)TFBlocks.YELLOW_CASTLE_DOOR.get()).method_9564();
        }
        if (this.color == ((class_2248)TFBlocks.VIOLET_CASTLE_RUNE_BRICK.get()).method_9564()) {
            return ((class_2248)TFBlocks.VIOLET_CASTLE_DOOR.get()).method_9564();
        }
        TwilightForestMod.LOGGER.warn("Couldn't add door to tower, rune color couldn't be read");
        return class_2246.field_10124.method_9564();
    }
}

