/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.minotaurmaze;

import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3773;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6130;
import net.minecraft.class_6625;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFLandmark;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.world.components.structures.TFMaze;
import twilightforest.world.components.structures.TFStructureComponentOld;
import twilightforest.world.components.structures.minotaurmaze.MazeCorridorComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeCorridorIronFenceComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeCorridorRootsComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeCorridorShroomsComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeDeadEndChestComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeDeadEndComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeDeadEndFountainComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeDeadEndFountainLavaComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeDeadEndPaintingComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeDeadEndRootsComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeDeadEndShroomsComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeDeadEndTorchesComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeDeadEndTrappedChestComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeDeadEndTripwireChestComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeMushRoomComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeRoomBossComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeRoomCollapseComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeRoomComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeRoomExitComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeRoomFountainComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeRoomSpawnerChestsComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeRoomVaultComponent;
import twilightforest.world.components.structures.minotaurmaze.MazestoneProcessor;

public class MinotaurMazeComponent
extends TFStructureComponentOld {
    TFMaze maze;
    int[] rcoords;
    private final int level;

    public MinotaurMazeComponent(class_6625 ctx, class_2487 nbt) {
        super((class_3773)TFStructurePieceTypes.TFMMaze.get(), nbt);
        this.level = nbt.method_10550("mazeLevel");
        this.rcoords = nbt.method_10561("roomCoords");
        this.maze = new TFMaze(this.getMazeSize(), this.getMazeSize());
        this.setFixedMazeSeed();
        for (int i = 2; i < this.rcoords.length; ++i) {
            this.rcoords[i] = 0;
        }
        this.addRoomsToMaze(this.rcoords[0], this.rcoords[1], (this.rcoords.length + 1) / 2);
        this.maze.generateRecursiveBacktracker(0, 0);
    }

    public MinotaurMazeComponent(TFLandmark feature, int index, int x, int y, int z, int entranceX, int entranceZ, int level) {
        super((class_3773)TFStructurePieceTypes.TFMMaze.get(), feature, index, x, y, z);
        this.method_14926(class_2350.field_11035);
        this.level = level;
        this.field_15315 = feature.getComponentToAddBoundingBox(x, y, z, -this.getRadius(), 0, -this.getRadius(), this.getRadius() * 2 + 2, 5, this.getRadius() * 2 + 2, class_2350.field_11035);
        this.maze = new TFMaze(this.getMazeSize(), this.getMazeSize());
        this.setFixedMazeSeed();
        int nrooms = 7;
        this.rcoords = new int[nrooms * 2];
        this.addRoomsToMaze(entranceX, entranceZ, nrooms);
        this.maze.generateRecursiveBacktracker(0, 0);
    }

    private void addRoomsToMaze(int entranceX, int entranceZ, int nrooms) {
        this.rcoords[0] = entranceX;
        this.rcoords[1] = entranceZ;
        this.maze.carveRoom1(entranceX, entranceZ);
        for (int i = 1; i < nrooms; ++i) {
            int rz;
            int rx;
            while (this.isNearRoom(rx = this.maze.rand.method_43048(this.getMazeSize() - 2) + 1, rz = this.maze.rand.method_43048(this.getMazeSize() - 2) + 1, this.rcoords, i == 1 ? 7 : 4)) {
            }
            this.maze.carveRoom1(rx, rz);
            this.rcoords[i * 2] = rx;
            this.rcoords[i * 2 + 1] = rz;
        }
    }

    private void setFixedMazeSeed() {
        this.maze.setSeed((long)this.field_15315.method_35415() * 90342903L + (long)this.field_15315.method_35416() * 90342903L ^ (long)this.field_15315.method_35417());
    }

    public MinotaurMazeComponent(TFLandmark feature, int index, int x, int y, int z, int level) {
        this(feature, index, x, y, z, 11, 11, level);
    }

    @Override
    protected void method_14943(class_6625 ctx, class_2487 tagCompound) {
        super.method_14943(ctx, tagCompound);
        tagCompound.method_10569("mazeLevel", this.level);
        tagCompound.method_10539("roomCoords", this.rcoords);
    }

    protected MazeRoomComponent makeRoom(class_5819 random, int i, int dx, int dz) {
        int worldX = this.field_15315.method_35415() + dx * 5 - 4;
        int worldY = this.field_15315.method_35416();
        int worldZ = this.field_15315.method_35417() + dz * 5 - 4;
        MazeRoomComponent room = i == 0 ? new MazeRoomComponent((class_3773)TFStructurePieceTypes.TFMMR.get(), this.getFeatureType(), 3 + i, random, worldX, worldY, worldZ) : (i == 1 ? (this.level == 1 ? new MazeRoomExitComponent(this.getFeatureType(), 3 + i, random, worldX, worldY, worldZ) : new MazeRoomBossComponent(this.getFeatureType(), 3 + i, random, worldX, worldY, worldZ)) : (i == 2 || i == 3 ? (this.level == 1 ? new MazeRoomCollapseComponent(this.getFeatureType(), 3 + i, random, worldX, worldY, worldZ) : new MazeMushRoomComponent(this.getFeatureType(), 3 + i, random, worldX, worldY, worldZ)) : (i == 4 ? (this.level == 1 ? new MazeRoomFountainComponent(this.getFeatureType(), 3 + i, random, worldX, worldY, worldZ) : new MazeRoomVaultComponent(this.getFeatureType(), 3 + i, random, worldX, worldY, worldZ)) : new MazeRoomSpawnerChestsComponent(this.getFeatureType(), 3 + i, random, worldX, worldY, worldZ))));
        return room;
    }

    protected void decorateDeadEndsCorridors(class_5819 random, class_6130 list) {
        for (int x = 0; x < this.maze.width; ++x) {
            for (int z = 0; z < this.maze.depth; ++z) {
                TFStructureComponentOld component = null;
                if (!this.maze.isWall(x, z, x - 1, z) && this.maze.isWall(x, z, x + 1, z) && this.maze.isWall(x, z, x, z - 1) && this.maze.isWall(x, z, x, z + 1)) {
                    component = this.makeDeadEnd(random, x, z, class_2350.field_11034);
                }
                if (this.maze.isWall(x, z, x - 1, z) && !this.maze.isWall(x, z, x + 1, z) && this.maze.isWall(x, z, x, z - 1) && this.maze.isWall(x, z, x, z + 1)) {
                    component = this.makeDeadEnd(random, x, z, class_2350.field_11039);
                }
                if (this.maze.isWall(x, z, x - 1, z) && this.maze.isWall(x, z, x + 1, z) && !this.maze.isWall(x, z, x, z - 1) && this.maze.isWall(x, z, x, z + 1)) {
                    component = this.makeDeadEnd(random, x, z, class_2350.field_11035);
                }
                if (this.maze.isWall(x, z, x - 1, z) && this.maze.isWall(x, z, x + 1, z) && this.maze.isWall(x, z, x, z - 1) && !this.maze.isWall(x, z, x, z + 1)) {
                    component = this.makeDeadEnd(random, x, z, class_2350.field_11043);
                }
                if (!this.maze.isWall(x, z, x - 1, z) && !this.maze.isWall(x, z, x + 1, z) && this.maze.isWall(x, z, x, z - 1) && this.maze.isWall(x, z, x, z + 1) && this.maze.isWall(x - 1, z, x - 1, z - 1) && this.maze.isWall(x - 1, z, x - 1, z + 1) && this.maze.isWall(x + 1, z, x + 1, z - 1) && this.maze.isWall(x + 1, z, x + 1, z + 1)) {
                    component = this.makeCorridor(random, x, z, class_2350.field_11039);
                }
                if (!this.maze.isWall(x, z, x, z - 1) && !this.maze.isWall(x, z, x, z + 1) && this.maze.isWall(x, z, x - 1, z) && this.maze.isWall(x, z, x + 1, z) && this.maze.isWall(x, z - 1, x - 1, z - 1) && this.maze.isWall(x, z - 1, x + 1, z - 1) && this.maze.isWall(x, z + 1, x - 1, z + 1) && this.maze.isWall(x, z + 1, x + 1, z + 1)) {
                    component = this.makeCorridor(random, x, z, class_2350.field_11035);
                }
                if (component == null) continue;
                list.method_35462((class_3443)component);
                component.method_14918(this, list, random);
            }
        }
    }

    protected MazeDeadEndComponent makeDeadEnd(class_5819 random, int dx, int dz, class_2350 rotation) {
        int worldX = this.field_15315.method_35415() + dx * 5 + 1;
        int worldY = this.field_15315.method_35416();
        int worldZ = this.field_15315.method_35417() + dz * 5 + 1;
        int decorationType = random.method_43048(8);
        return switch (decorationType) {
            case 1 -> new MazeDeadEndChestComponent((class_3773)TFStructurePieceTypes.TFMMDEC.get(), this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
            case 2 -> {
                if (random.method_43056()) {
                    yield new MazeDeadEndTripwireChestComponent(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
                }
                yield new MazeDeadEndTrappedChestComponent(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
            }
            case 3 -> new MazeDeadEndTorchesComponent(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
            case 4 -> new MazeDeadEndFountainComponent((class_3773)TFStructurePieceTypes.TFMMDEF.get(), this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
            case 5 -> new MazeDeadEndFountainLavaComponent(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
            case 6 -> new MazeDeadEndPaintingComponent(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
            case 7 -> {
                if (this.level == 1) {
                    yield new MazeDeadEndRootsComponent((class_3773)TFStructurePieceTypes.TFMMDER.get(), this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
                }
                yield new MazeDeadEndShroomsComponent(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
            }
            default -> new MazeDeadEndComponent((class_3773)TFStructurePieceTypes.TFMMDE.get(), this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
        };
    }

    protected MazeCorridorComponent makeCorridor(class_5819 random, int dx, int dz, class_2350 rotation) {
        int worldX = this.field_15315.method_35415() + dx * 5 + 1;
        int worldY = this.field_15315.method_35416();
        int worldZ = this.field_15315.method_35417() + dz * 5 + 1;
        int decorationType = random.method_43048(5);
        return switch (decorationType) {
            case 1 -> new MazeCorridorComponent((class_3773)TFStructurePieceTypes.TFMMC.get(), this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
            case 2 -> new MazeCorridorIronFenceComponent(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
            case 3 -> null;
            case 4 -> {
                if (this.level == 1) {
                    yield new MazeCorridorRootsComponent(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
                }
                yield new MazeCorridorShroomsComponent(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
            }
            default -> null;
        };
    }

    public void method_14918(class_3443 structurecomponent, class_6130 list, class_5819 random) {
        super.method_14918(structurecomponent, list, random);
        if (this.level == 1) {
            int centerX = this.field_15315.method_35415() + (this.field_15315.method_35418() - this.field_15315.method_35415()) / 2;
            int centerZ = this.field_15315.method_35417() + (this.field_15315.method_35420() - this.field_15315.method_35417()) / 2;
            MinotaurMazeComponent maze = new MinotaurMazeComponent(this.getFeatureType(), 1, centerX, this.field_15315.method_35416() - 10, centerZ, this.rcoords[2], this.rcoords[3], 2);
            list.method_35462((class_3443)maze);
            maze.method_14918(this, list, random);
        }
        for (int i = 0; i < this.rcoords.length / 2; ++i) {
            int dx = this.rcoords[i * 2];
            int dz = this.rcoords[i * 2 + 1];
            MazeRoomComponent room = this.makeRoom(random, i, dx, dz);
            list.method_35462((class_3443)room);
            room.method_14918(this, list, random);
        }
        this.decorateDeadEndsCorridors(random, list);
    }

    public void method_14931(class_5281 world, class_5138 manager, class_2794 generator, class_5819 rand, class_3341 sbb, class_1923 chunkPosIn, class_2338 blockPos) {
        class_2680 bedrock = class_2246.field_9987.method_9564();
        class_2680 stone = class_2246.field_10340.method_9564();
        if (this.level == 2) {
            this.method_14940(world, sbb, 0, -1, 0, this.getDiameter() + 2, 6, this.getDiameter() + 2, bedrock, AIR, false);
        }
        this.method_14942(world, sbb, 1, 1, 1, this.getDiameter(), 4, this.getDiameter());
        boolean onlyReplaceCeiling = this.level == 1;
        this.method_14940(world, sbb, 1, 5, 1, this.getDiameter(), 5, this.getDiameter(), ((class_2248)TFBlocks.MAZESTONE.get()).method_9564(), stone, onlyReplaceCeiling);
        this.method_14940(world, sbb, 1, 0, 1, this.getDiameter(), 0, this.getDiameter(), ((class_2248)TFBlocks.MAZESTONE_MOSAIC.get()).method_9564(), stone, false);
        this.maze.headBlockState = ((class_2248)TFBlocks.DECORATIVE_MAZESTONE.get()).method_9564();
        this.maze.wallBlockState = ((class_2248)TFBlocks.MAZESTONE_BRICK.get()).method_9564();
        this.maze.rootBlockState = ((class_2248)TFBlocks.DECORATIVE_MAZESTONE.get()).method_9564();
        this.maze.pillarBlockState = ((class_2248)TFBlocks.CUT_MAZESTONE.get()).method_9564();
        this.maze.wallBlocks = new MazestoneProcessor();
        this.maze.torchRarity = 0.05f;
        this.maze.tall = 2;
        this.maze.head = 1;
        this.maze.roots = 1;
        this.maze.oddBias = 4;
        this.maze.copyToStructure(world, manager, generator, 1, 2, 1, this, sbb);
    }

    public int getMazeSize() {
        return 22;
    }

    public int getRadius() {
        return (int)((double)this.getMazeSize() * 2.5);
    }

    public int getDiameter() {
        return this.getMazeSize() * 5;
    }

    protected boolean isNearRoom(int dx, int dz, int[] rcoords, int range) {
        if (dx == 1 && dz == 1) {
            return true;
        }
        for (int i = 0; i < rcoords.length / 2; ++i) {
            int rx = rcoords[i * 2];
            int rz = rcoords[i * 2 + 1];
            if (rx == 0 && rz == 0 || Math.abs(dx - rx) >= range || Math.abs(dz - rz) >= range) continue;
            return true;
        }
        return false;
    }
}

