/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.start;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import org.jetbrains.annotations.Nullable;
import twilightforest.world.components.structures.start.LandmarkStructure;
import twilightforest.world.components.structures.util.AdvancementLockedStructure;
import twilightforest.world.components.structures.util.ControlledSpawns;
import twilightforest.world.components.structures.util.DecorationClearance;
import twilightforest.world.components.structures.util.StructureHints;

public abstract class ProgressionStructure
extends LandmarkStructure
implements AdvancementLockedStructure,
StructureHints {
    final AdvancementLockedStructure.AdvancementLockConfig advancementLockConfig;
    final StructureHints.HintConfig hintConfig;
    private long lastSpawnedHintMonsterTime;

    protected static <S extends ProgressionStructure> Products.P5<RecordCodecBuilder.Mu<S>, AdvancementLockedStructure.AdvancementLockConfig, StructureHints.HintConfig, ControlledSpawns.ControlledSpawningConfig, DecorationClearance.DecorationConfig, class_3195.class_7302> progressionCodec(RecordCodecBuilder.Instance<S> instance) {
        return instance.group((App)AdvancementLockedStructure.AdvancementLockConfig.CODEC.fieldOf("advancements_required").forGetter(s -> s.advancementLockConfig), (App)StructureHints.HintConfig.FLAT_CODEC.forGetter(s -> s.hintConfig)).and(ProgressionStructure.landmarkCodec(instance));
    }

    public ProgressionStructure(AdvancementLockedStructure.AdvancementLockConfig advancementLockConfig, StructureHints.HintConfig hintConfig, ControlledSpawns.ControlledSpawningConfig controlledSpawningConfig, DecorationClearance.DecorationConfig decorationConfig, class_3195.class_7302 structureSettings) {
        super(controlledSpawningConfig, decorationConfig, structureSettings);
        this.advancementLockConfig = advancementLockConfig;
        this.hintConfig = hintConfig;
    }

    @Override
    public List<class_2960> getRequiredAdvancements() {
        return this.advancementLockConfig.requiredAdvancements();
    }

    @Override
    public void trySpawnHintMonster(class_1937 world, class_1657 player, class_2338 pos) {
        long currentTime = world.method_8510();
        if (currentTime < this.lastSpawnedHintMonsterTime) {
            this.lastSpawnedHintMonsterTime = 0L;
        }
        if (currentTime - this.lastSpawnedHintMonsterTime > 1200L) {
            for (int i = 0; i < 20; ++i) {
                if (!this.didSpawnHintMonster(world, player, pos)) continue;
                this.lastSpawnedHintMonsterTime = currentTime;
                break;
            }
        }
    }

    @Override
    public class_1799 createHintBook() {
        return this.hintConfig.hintItem().method_7972();
    }

    @Override
    @Nullable
    public class_1308 createHintMonster(class_1937 world) {
        return (class_1308)this.hintConfig.hintMob().method_5883(world);
    }
}

