/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.vmp.common.networking.priority;

import com.google.common.base.Preconditions;
import com.ishland.vmp.common.config.Config;
import com.ishland.vmp.common.util.SimpleObjectPool;
import com.ishland.vmp.deps.raknetify.fabric.common.connection.RakNetMultiChannel;
import com.ishland.vmp.mixins.access.IChunkDeltaUpdateS2CPacket;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPromise;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.ReferenceCountUtil;
import it.unimi.dsi.fastutil.ints.Int2ReferenceFunction;
import it.unimi.dsi.fastutil.ints.Int2ReferenceLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectFunction;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.shorts.Short2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Comparator;
import java.util.PriorityQueue;
import javax.annotation.Nullable;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2620;
import net.minecraft.class_2622;
import net.minecraft.class_2623;
import net.minecraft.class_2626;
import net.minecraft.class_2637;
import net.minecraft.class_2666;
import net.minecraft.class_2672;
import net.minecraft.class_2673;
import net.minecraft.class_2676;
import net.minecraft.class_2678;
import net.minecraft.class_2680;
import net.minecraft.class_2693;
import net.minecraft.class_2724;
import net.minecraft.class_2877;
import net.minecraft.class_2960;
import net.minecraft.class_4076;
import net.minecraft.class_4273;
import net.minecraft.class_4282;
import net.minecraft.class_5194;
import org.jetbrains.annotations.NotNull;

public class PacketPriorityHandler
extends ChannelDuplexHandler {
    private static final int IP_TOS_LOWDELAY = 16;
    private static final int IP_TOS_THROUGHPUT = 8;
    private static final int IP_TOS_RELIABILITY = 4;
    private static final int DEFAULT_SNDBUF = 8192;
    public static final Object SYNC_REQUEST_OBJECT = new Object();
    public static final Object SYNC_REQUEST_OBJECT_DIM_CHANGE = new Object();
    public static final Object START_PRIORITY = new Object();
    private static final Comparator<PendingPacket> cmp = Comparator.comparingInt(PendingPacket::priority).thenComparingLong(PendingPacket::orderIndex);
    private static final IntOpenHashSet channelToIgnoreWhenSync = new IntOpenHashSet(new int[]{1});
    private final class_2540 empty = new class_2540(Unpooled.wrappedBuffer((byte[])new byte[64]));
    private final PriorityQueue<PendingPacket> queue = new PriorityQueue<PendingPacket>(cmp);
    private boolean isEnabled = false;
    private long currentOrderIndex = 0L;
    private final Long2IntOpenHashMap sentChunkPacketHashes = new Long2IntOpenHashMap();
    private final LongOpenHashSet actuallySentChunks = new LongOpenHashSet();
    private final Long2ObjectLinkedOpenHashMap<ChunkUpdateQueue> chunkUpdateQueues = new Long2ObjectLinkedOpenHashMap();
    private final SimpleObjectPool<Short2ObjectLinkedOpenHashMap<?>> short2ObjectLinkedOpenHashMapPool = new SimpleObjectPool<Short2ObjectLinkedOpenHashMap>(unused -> new Short2ObjectLinkedOpenHashMap(), Short2ObjectLinkedOpenHashMap::clear, Short2ObjectLinkedOpenHashMap::clear, 256);
    private final SimpleObjectPool<ChunkUpdateQueue> chunkUpdateQueueSimpleObjectPool = new SimpleObjectPool<ChunkUpdateQueue>(unused -> new ChunkUpdateQueue(), ChunkUpdateQueue::clear, ChunkUpdateQueue::clear, 256);
    private final SimpleObjectPool<SectionUpdateQueue> sectionUpdateQueueSimpleObjectPool = new SimpleObjectPool<SectionUpdateQueue>(unused -> new SectionUpdateQueue(), SectionUpdateQueue::clear, SectionUpdateQueue::clear, 256);
    private int serverViewDistance = 3;
    private int chunkCenterX = 0;
    private int chunkCenterZ = 0;
    private class_2960 dimension = null;

    public static void setupPacketPriority(Channel channel) {
        if (Config.USE_PACKET_PRIORITY_SYSTEM && channel instanceof SocketChannel) {
            channel.pipeline().addLast("vmp_packet_priority", (ChannelHandler)new PacketPriorityHandler());
            channel.config().setOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(4096, 8192));
            channel.config().setOption(ChannelOption.IP_TOS, (Object)24);
        }
    }

    private boolean shouldDropPacketEarly(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        class_1923 chunkPos;
        if (msg instanceof class_2724) {
            class_2724 packet = (class_2724)msg;
            class_2960 changedDimension = packet.method_11779().method_29177();
            if (changedDimension.equals((Object)this.dimension)) {
                this.userEventTriggered(ctx, SYNC_REQUEST_OBJECT);
            } else {
                this.dimension = changedDimension;
                this.userEventTriggered(ctx, SYNC_REQUEST_OBJECT_DIM_CHANGE);
            }
        } else if (msg instanceof class_2678) {
            class_2678 packet = (class_2678)msg;
            this.dimension = packet.comp_95().method_29177();
            int lastViewDistance = this.serverViewDistance;
            this.serverViewDistance = packet.comp_98() + 1;
            if (lastViewDistance != this.serverViewDistance) {
                this.ensureChunkInVD(ctx);
            }
        } else if (msg instanceof class_2672) {
            class_2672 packet = (class_2672)msg;
            if (this.isInRange(packet.method_11523(), packet.method_11524())) {
                long pos2 = class_1923.method_8331((int)packet.method_11523(), (int)packet.method_11524());
                this.sentChunkPacketHashes.put(pos2, System.identityHashCode(packet));
                this.clearChunkUpdateQueue(pos2);
            } else {
                System.err.println("Not sending chunk [%d, %d] as it is not in view distance".formatted(packet.method_11523(), packet.method_11524()));
            }
        } else if (msg instanceof class_2666) {
            class_2666 packet = (class_2666)msg;
            long pos3 = class_1923.method_8331((int)packet.method_11487(), (int)packet.method_11485());
            this.sentChunkPacketHashes.remove(pos3);
            this.actuallySentChunks.remove(pos3);
            this.clearChunkUpdateQueue(pos3);
        } else if (msg instanceof class_4273) {
            class_4273 packet = (class_4273)msg;
            int lastViewDistance = this.serverViewDistance;
            this.serverViewDistance = packet.method_20206() + 1;
            if (lastViewDistance != this.serverViewDistance) {
                this.ensureChunkInVD(ctx);
            }
        } else if (msg instanceof class_4282) {
            class_4282 packet = (class_4282)msg;
            this.chunkCenterX = packet.method_20322();
            this.chunkCenterZ = packet.method_20323();
            this.ensureChunkInVD(ctx);
        } else if (Config.USE_PACKET_PRIORITY_SYSTEM_BLOCK_UPDATE_CONSOLIDATION && ChunkUpdateQueue.chunkUpdatePackets.containsKey(msg.getClass()) && this.sentChunkPacketHashes.containsKey((chunkPos = (class_1923)((Object2ObjectFunction)ChunkUpdateQueue.chunkUpdatePackets.get(msg.getClass())).apply(msg)).method_8324())) {
            ((ChunkUpdateQueue)this.chunkUpdateQueues.computeIfAbsent(chunkPos.method_8324(), pos -> this.chunkUpdateQueueSimpleObjectPool.alloc().submitChunk(new class_1923(pos)))).consumePacket(ReferenceCountUtil.retain((Object)msg), promise);
            return true;
        }
        return false;
    }

    private void clearChunkUpdateQueue(long pos) {
        if (this.chunkUpdateQueues.containsKey(pos)) {
            ChunkUpdateQueue chunkUpdateQueue = (ChunkUpdateQueue)this.chunkUpdateQueues.remove(pos);
            chunkUpdateQueue.clear();
            this.chunkUpdateQueueSimpleObjectPool.release(chunkUpdateQueue);
        }
    }

    private boolean shouldDropPacket(Object msg) {
        if (msg instanceof class_2672) {
            boolean isValidHash;
            class_2672 packet = (class_2672)msg;
            long coord = class_1923.method_8331((int)packet.method_11523(), (int)packet.method_11524());
            int hash = this.sentChunkPacketHashes.getOrDefault(coord, Integer.MIN_VALUE);
            boolean bl = isValidHash = hash != Integer.MIN_VALUE || this.sentChunkPacketHashes.containsKey(coord);
            if (!isValidHash) {
                return true;
            }
            if (hash != System.identityHashCode(packet)) {
                return true;
            }
            this.actuallySentChunks.add(coord);
        }
        return false;
    }

    private void ensureChunkInVD(ChannelHandlerContext ctx) {
        ObjectIterator iterator = this.sentChunkPacketHashes.long2IntEntrySet().fastIterator();
        while (iterator.hasNext()) {
            int z;
            Long2IntMap.Entry entry = (Long2IntMap.Entry)iterator.next();
            long pos = entry.getLongKey();
            int x = class_1923.method_8325((long)pos);
            if (this.isInRange(x, z = class_1923.method_8332((long)pos))) continue;
            iterator.remove();
            ctx.write((Object)new class_2666(x, z));
            this.actuallySentChunks.remove(pos);
            this.clearChunkUpdateQueue(pos);
        }
    }

    private boolean isInRange(int x, int z) {
        return Math.max(Math.abs(x - this.chunkCenterX), Math.abs(z - this.chunkCenterZ)) <= this.serverViewDistance;
    }

    private void adjustSendBuffer(ChannelHandlerContext ctx) {
        int sendBuffer = ctx.channel().isWritable() ? 8192 : (int)(16384L + ctx.channel().bytesBeforeWritable());
        ctx.channel().config().setOption(ChannelOption.SO_SNDBUF, (Object)sendBuffer);
        ctx.flush();
    }

    public void channelActive(@NotNull ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        this.adjustSendBuffer(ctx);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        long orderIndex = this.currentOrderIndex++;
        if (this.shouldDropPacketEarly(ctx, msg, promise)) {
            ReferenceCountUtil.release((Object)msg);
            return;
        }
        if (this.isEnabled) {
            if (this.writesAllowed(ctx) && this.queue.isEmpty()) {
                if (!this.shouldDropPacket(msg)) {
                    ctx.write(msg, promise);
                } else {
                    ReferenceCountUtil.release((Object)msg);
                    promise.trySuccess();
                }
            } else {
                this.queue.add(new PendingRawPacket(msg, promise, orderIndex, RakNetMultiChannel.getPacketChannelOverride(msg.getClass())));
            }
        } else {
            super.write(ctx, msg, promise);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt == SYNC_REQUEST_OBJECT || evt == SYNC_REQUEST_OBJECT_DIM_CHANGE) {
            PendingPacket pendingPacket;
            this.isEnabled = false;
            if (evt == SYNC_REQUEST_OBJECT_DIM_CHANGE) {
                for (Long2ObjectMap.Entry entry : this.chunkUpdateQueues.long2ObjectEntrySet()) {
                    ((ChunkUpdateQueue)entry.getValue()).clear();
                    this.chunkUpdateQueueSimpleObjectPool.release((ChunkUpdateQueue)entry.getValue());
                }
                this.chunkUpdateQueues.clear();
                this.actuallySentChunks.clear();
                this.sentChunkPacketHashes.clear();
            }
            ObjectArrayList retainedPackets = new ObjectArrayList(this.queue.size() / 12);
            while ((pendingPacket = this.queue.poll()) != null) {
                if (!channelToIgnoreWhenSync.contains(pendingPacket.priority())) continue;
                retainedPackets.add((Object)pendingPacket);
            }
            this.queue.addAll((Collection<PendingPacket>)retainedPackets);
            System.out.println("VMP: Stopped priority handler, retained %d packets".formatted(retainedPackets.size()));
            this.tryFlushPackets(ctx, true);
        } else if (evt == START_PRIORITY) {
            this.isEnabled = true;
            System.out.println("VMP: Started priority handler");
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        super.channelWritabilityChanged(ctx);
        if (!ctx.channel().isOpen()) {
            return;
        }
        this.adjustSendBuffer(ctx);
        if (ctx.channel().isWritable()) {
            this.tryFlushPackets(ctx, false);
        }
    }

    public void flush(ChannelHandlerContext ctx) throws Exception {
        this.tryFlushPackets(ctx, false);
    }

    private void tryFlushPackets(ChannelHandlerContext ctx, boolean ignoreWritability) {
        PendingPacket pendingPacket;
        if (this.queue.isEmpty()) {
            this.tryFlushBlockUpdates(ctx, ignoreWritability);
        }
        while ((ignoreWritability || this.writesAllowed(ctx)) && (pendingPacket = this.queue.peek()) != null) {
            boolean flushedBlockUpdates = pendingPacket.orderIndex() > 6L && this.tryFlushBlockUpdates(ctx, ignoreWritability);
            if (flushedBlockUpdates) continue;
            this.queue.poll();
            Object msg = pendingPacket.msg();
            if (this.shouldDropPacket(msg)) {
                pendingPacket.release();
                continue;
            }
            pendingPacket.dispatch(ctx);
        }
        ctx.flush();
    }

    private boolean tryFlushBlockUpdates(ChannelHandlerContext ctx, boolean ignoreWritability) {
        ObjectBidirectionalIterator iterator = this.chunkUpdateQueues.long2ObjectEntrySet().fastIterator();
        boolean hasWork = false;
        while ((ignoreWritability || this.writesAllowed(ctx)) && iterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
            if (!this.actuallySentChunks.contains(entry.getLongKey())) continue;
            ChunkUpdateQueue queue = (ChunkUpdateQueue)entry.getValue();
            PendingPacket pendingPacket = queue.producePacket(ctx);
            if (pendingPacket == null) {
                iterator.remove();
                this.chunkUpdateQueueSimpleObjectPool.release(queue);
                continue;
            }
            Object msg = pendingPacket.msg();
            if (this.shouldDropPacket(msg)) {
                pendingPacket.release();
                continue;
            }
            pendingPacket.dispatch(ctx);
            hasWork = true;
        }
        return hasWork;
    }

    public void channelInactive(@NotNull ChannelHandlerContext ctx) throws Exception {
        if (this.isEnabled) {
            this.tryFlushPackets(ctx, true);
        }
        super.channelInactive(ctx);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        if (this.isEnabled) {
            this.tryFlushPackets(ctx, true);
        }
        super.close(ctx, promise);
    }

    private boolean writesAllowed(ChannelHandlerContext ctx) {
        return ctx.channel().isWritable();
    }

    private class ChunkUpdateQueue {
        private static final Object2ObjectOpenHashMap<Class<?>, Object2ObjectFunction<Object, class_1923>> chunkUpdatePackets = new Object2ObjectOpenHashMap();
        private static final Object2ObjectOpenHashMap<Class<?>, Object2ObjectFunction<Object, class_2338>> packet2BlockPos = new Object2ObjectOpenHashMap();
        private final Int2ReferenceLinkedOpenHashMap<SectionUpdateQueue> sectionQueues = new Int2ReferenceLinkedOpenHashMap();
        private final Object2ObjectLinkedOpenHashMap<Class<?>, SimplePendingPacket> sequencedQueuedPackets = new Object2ObjectLinkedOpenHashMap();
        private final ObjectArrayList<SimplePendingPacket> queuedPackets = new ObjectArrayList();
        private class_1923 chunkPos;

        private ChunkUpdateQueue() {
        }

        private static class_1923 identifyChunkUpdatePacket(Object msg) {
            Object2ObjectFunction function = (Object2ObjectFunction)chunkUpdatePackets.get(msg.getClass());
            return function != null ? (class_1923)function.get(msg) : null;
        }

        public ChunkUpdateQueue submitChunk(class_1923 chunkPos) {
            Preconditions.checkState((this.chunkPos == null ? 1 : 0) != 0);
            this.chunkPos = chunkPos;
            return this;
        }

        public void consumePacket(Object msg, ChannelPromise promise) {
            if (msg instanceof class_2637) {
                class_2637 packet = (class_2637)msg;
                packet.method_30621(this::handleBlockUpdate);
            } else if (msg instanceof class_2626) {
                class_2626 packet = (class_2626)msg;
                this.handleBlockUpdate(packet.method_11309(), packet.method_11308());
            } else if (msg instanceof class_2676) {
                class_2676 packet = (class_2676)msg;
            } else if (packet2BlockPos.containsKey(msg.getClass())) {
                class_2338 pos = (class_2338)((Object2ObjectFunction)packet2BlockPos.get(msg.getClass())).apply(msg);
                ((Short2ObjectLinkedOpenHashMap)((SectionUpdateQueue)this.sectionQueues.computeIfAbsent((int)class_4076.method_18675((int)pos.method_10264()), (Int2ReferenceFunction)(Int2ReferenceFunction)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$consumePacket$17(int ), (I)Lcom/ishland/vmp/common/networking/priority/PacketPriorityHandler$SectionUpdateQueue;)((ChunkUpdateQueue)this))).perBlockSequencedQueuedPackets.computeIfAbsent(msg.getClass(), unused -> PacketPriorityHandler.this.short2ObjectLinkedOpenHashMapPool.alloc())).putAndMoveToLast(class_4076.method_19454((class_2338)pos), (Object)new SimplePendingPacket(msg, promise));
            } else {
                this.queuedPackets.add((Object)new SimplePendingPacket(msg, promise));
            }
        }

        private void handleBlockUpdate(class_2338 pos, class_2680 state) {
            ((SectionUpdateQueue)this.sectionQueues.computeIfAbsent((int)class_4076.method_18675((int)pos.method_10264()), (Int2ReferenceFunction)(Int2ReferenceFunction)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$handleBlockUpdate$19(int ), (I)Lcom/ishland/vmp/common/networking/priority/PacketPriorityHandler$SectionUpdateQueue;)((ChunkUpdateQueue)this))).blockUpdates.putAndMoveToLast(class_4076.method_19454((class_2338)pos), (Object)state);
        }

        public PendingPacket producePacket(ChannelHandlerContext ctx) {
            if (!this.sectionQueues.isEmpty()) {
                ObjectBidirectionalIterator iterator = this.sectionQueues.int2ReferenceEntrySet().fastIterator();
                while (iterator.hasNext()) {
                    Int2ReferenceMap.Entry entry = (Int2ReferenceMap.Entry)iterator.next();
                    SimplePendingPacket simplePendingPacket = ((SectionUpdateQueue)entry.getValue()).tryProduce(ctx, class_4076.method_18681((class_1923)this.chunkPos, (int)entry.getIntKey()));
                    if (simplePendingPacket != null) {
                        return this.makePacket(simplePendingPacket);
                    }
                    PacketPriorityHandler.this.sectionUpdateQueueSimpleObjectPool.release((SectionUpdateQueue)entry.getValue());
                    iterator.remove();
                }
            }
            if (!this.sequencedQueuedPackets.isEmpty()) {
                return this.makePacket((SimplePendingPacket)this.sequencedQueuedPackets.removeFirst());
            }
            if (!this.queuedPackets.isEmpty()) {
                return this.makePacket((SimplePendingPacket)this.queuedPackets.remove(0));
            }
            return null;
        }

        private PendingPacket makePacket(SimplePendingPacket packet) {
            return new PendingRawPacket(packet.packet, packet.promise, PacketPriorityHandler.this.currentOrderIndex++, 6);
        }

        public void clear() {
            this.chunkPos = null;
            for (Int2ReferenceMap.Entry entry : this.sectionQueues.int2ReferenceEntrySet()) {
                ((SectionUpdateQueue)entry.getValue()).clear();
                PacketPriorityHandler.this.sectionUpdateQueueSimpleObjectPool.release((SectionUpdateQueue)entry.getValue());
            }
            this.sectionQueues.clear();
            for (Int2ReferenceMap.Entry entry : this.sequencedQueuedPackets.object2ObjectEntrySet()) {
                ((SimplePendingPacket)entry.getValue()).promise.trySuccess();
                ReferenceCountUtil.release((Object)((SimplePendingPacket)entry.getValue()).packet);
            }
            this.sequencedQueuedPackets.clear();
            for (SimplePendingPacket packet : this.queuedPackets) {
                packet.promise.trySuccess();
                ReferenceCountUtil.release((Object)packet.packet);
            }
            this.queuedPackets.clear();
        }

        private /* synthetic */ SectionUpdateQueue lambda$handleBlockUpdate$19(int unused) {
            return PacketPriorityHandler.this.sectionUpdateQueueSimpleObjectPool.alloc();
        }

        private /* synthetic */ SectionUpdateQueue lambda$consumePacket$17(int unused) {
            return PacketPriorityHandler.this.sectionUpdateQueueSimpleObjectPool.alloc();
        }

        static {
            chunkUpdatePackets.put(class_5194.class, packet -> new class_1923(((class_5194)packet).method_27275()));
            chunkUpdatePackets.put(class_2693.class, packet -> new class_1923(((class_2693)packet).method_11677()));
            chunkUpdatePackets.put(class_2877.class, packet -> new class_1923(((class_2877)packet).method_12510()));
            chunkUpdatePackets.put(class_2623.class, packet -> new class_1923(((class_2623)packet).method_11298()));
            chunkUpdatePackets.put(class_2626.class, packet -> new class_1923(((class_2626)packet).method_11309()));
            chunkUpdatePackets.put(class_2637.class, packet -> ((IChunkDeltaUpdateS2CPacket)packet).getSectionPos().method_18692());
            chunkUpdatePackets.put(class_2673.class, packet -> new class_1923(((class_2673)packet).method_11531()));
            chunkUpdatePackets.put(class_2620.class, packet -> new class_1923(((class_2620)packet).method_11277()));
            chunkUpdatePackets.put(class_2622.class, packet -> new class_1923(((class_2622)packet).method_11293()));
            chunkUpdatePackets.put(class_2676.class, packet -> new class_1923(((class_2676)packet).method_11558(), ((class_2676)packet).method_11554()));
            packet2BlockPos.put(class_5194.class, packet -> ((class_5194)packet).method_27275());
            packet2BlockPos.put(class_2693.class, packet -> ((class_2693)packet).method_11677());
            packet2BlockPos.put(class_2877.class, packet -> ((class_2877)packet).method_12510());
            packet2BlockPos.put(class_2623.class, packet -> ((class_2623)packet).method_11298());
            packet2BlockPos.put(class_2673.class, packet -> ((class_2673)packet).method_11531());
            packet2BlockPos.put(class_2620.class, packet -> ((class_2620)packet).method_11277());
            packet2BlockPos.put(class_2622.class, packet -> ((class_2622)packet).method_11293());
        }

        private record SimplePendingPacket(Object packet, ChannelPromise promise) {
        }
    }

    private record PendingRawPacket(Object msg, ChannelPromise promise, long orderIndex, int priority) implements PendingPacket
    {
        @Override
        public void dispatch(ChannelHandlerContext ctx) {
            ctx.write(this.msg, this.promise);
        }

        @Override
        public void release() {
            ReferenceCountUtil.release((Object)this.msg);
            this.promise.trySuccess();
        }
    }

    private static interface PendingPacket {
        @Nullable
        public Object msg();

        public void dispatch(ChannelHandlerContext var1);

        public void release();

        public long orderIndex();

        public int priority();
    }

    private final class SectionUpdateQueue {
        private final ObjectArrayList<ChannelPromise> blockUpdatePromises = new ObjectArrayList();
        private final Short2ObjectLinkedOpenHashMap<class_2680> blockUpdates = new Short2ObjectLinkedOpenHashMap();
        private final Object2ObjectOpenHashMap<Class<?>, Short2ObjectLinkedOpenHashMap<ChunkUpdateQueue.SimplePendingPacket>> perBlockSequencedQueuedPackets = new Object2ObjectOpenHashMap();

        private SectionUpdateQueue() {
        }

        public void clear() {
            for (ChannelPromise promise : this.blockUpdatePromises) {
                promise.trySuccess();
            }
            this.blockUpdatePromises.clear();
            this.blockUpdates.clear();
            for (Object2ObjectMap.Entry entry : this.perBlockSequencedQueuedPackets.object2ObjectEntrySet()) {
                for (Short2ObjectMap.Entry packetEntry : ((Short2ObjectLinkedOpenHashMap)entry.getValue()).short2ObjectEntrySet()) {
                    ((ChunkUpdateQueue.SimplePendingPacket)packetEntry.getValue()).promise.trySuccess();
                    ReferenceCountUtil.release((Object)((ChunkUpdateQueue.SimplePendingPacket)packetEntry.getValue()).packet);
                }
                PacketPriorityHandler.this.short2ObjectLinkedOpenHashMapPool.release((Short2ObjectLinkedOpenHashMap)entry.getValue());
            }
            this.perBlockSequencedQueuedPackets.clear();
        }

        private ChunkUpdateQueue.SimplePendingPacket tryProduce(ChannelHandlerContext ctx, class_4076 chunkSectionPos) {
            if (!this.blockUpdates.isEmpty()) {
                ChannelPromise[] futures = (ChannelPromise[])this.blockUpdatePromises.toArray(ChannelPromise[]::new);
                this.blockUpdatePromises.clear();
                ChannelPromise promise = ctx.newPromise();
                promise.addListener(future -> {
                    for (ChannelPromise channelPromise : futures) {
                        if (future.isSuccess()) {
                            channelPromise.trySuccess();
                            continue;
                        }
                        channelPromise.tryFailure(future.cause());
                    }
                });
                PacketPriorityHandler.this.empty.setIndex(0, PacketPriorityHandler.this.empty.capacity());
                class_2637 msg = new class_2637(PacketPriorityHandler.this.empty);
                PacketPriorityHandler.this.empty.setIndex(0, PacketPriorityHandler.this.empty.capacity());
                int size = this.blockUpdates.size();
                short[] positions = new short[size];
                class_2680[] blockStates = new class_2680[size];
                ObjectBidirectionalIterator iterator = this.blockUpdates.short2ObjectEntrySet().fastIterator();
                int i = 0;
                while (iterator.hasNext()) {
                    Short2ObjectMap.Entry entry = (Short2ObjectMap.Entry)iterator.next();
                    positions[i] = entry.getShortKey();
                    blockStates[i] = (class_2680)entry.getValue();
                    ++i;
                }
                this.blockUpdates.clear();
                ((IChunkDeltaUpdateS2CPacket)msg).setSectionPos(chunkSectionPos);
                ((IChunkDeltaUpdateS2CPacket)msg).setPositions(positions);
                ((IChunkDeltaUpdateS2CPacket)msg).setBlockStates(blockStates);
                ((IChunkDeltaUpdateS2CPacket)msg).setNoLightingUpdates(false);
                return new ChunkUpdateQueue.SimplePendingPacket(msg, promise);
            }
            if (!this.perBlockSequencedQueuedPackets.isEmpty()) {
                ObjectIterator iterator = this.perBlockSequencedQueuedPackets.object2ObjectEntrySet().fastIterator();
                while (iterator.hasNext()) {
                    Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)iterator.next();
                    Short2ObjectLinkedOpenHashMap map = (Short2ObjectLinkedOpenHashMap)entry.getValue();
                    if (!map.isEmpty()) {
                        return (ChunkUpdateQueue.SimplePendingPacket)map.removeFirst();
                    }
                    PacketPriorityHandler.this.short2ObjectLinkedOpenHashMapPool.release(map);
                    iterator.remove();
                }
            }
            return null;
        }

        public String toString() {
            return "SectionUpdateQueue[blockUpdatePromises=" + this.blockUpdatePromises + ", blockUpdates=" + this.blockUpdates + ", perBlockSequencedQueuedPackets=" + this.perBlockSequencedQueuedPackets + "]";
        }
    }
}

