/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.vmp.deps.raknetify.fabric.common.connection;

import com.google.common.collect.Sets;
import com.ishland.vmp.deps.raknetify.fabric.mixin.access.INetworkState;
import com.ishland.vmp.deps.raknetify.fabric.mixin.access.INetworkStatePacketHandler;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;
import net.minecraft.class_2539;
import net.minecraft.class_2598;

public class RakNetMultiChannel {
    private static final Set<Class<?>> unordered = RakNetMultiChannel.createClassSet(new String[]{"net/minecraft/class_2670", "net/minecraft/class_2827", "net/minecraft/class_2661", "net/minecraft/class_6373", "net/minecraft/class_6374", "net/minecraft/class_2720", "net/minecraft/class_2856", "net/minecraft/class_2617", "net/minecraft/class_2859", "net/minecraft/class_2729"});
    private static final Set<Class<?>> channel1 = RakNetMultiChannel.createClassSet(new String[]{"net/minecraft/class_2629", "net/minecraft/class_5888", "net/minecraft/class_5903", "net/minecraft/class_5904", "net/minecraft/class_5905", "net/minecraft/class_5892", "net/minecraft/class_2635", "net/minecraft/class_7439", "net/minecraft/class_7519", "net/minecraft/class_7438", "net/minecraft/class_7494", "net/minecraft/class_7618", "net/minecraft/class_7597", "net/minecraft/class_7617", "net/minecraft/class_7640", "net/minecraft/class_7495", "net/minecraft/class_5894", "net/minecraft/class_2748", "net/minecraft/class_2749", "net/minecraft/class_2656", "net/minecraft/class_2772", "net/minecraft/class_2736", "net/minecraft/class_2751", "net/minecraft/class_2757", "net/minecraft/class_2779", "net/minecraft/class_2641", "net/minecraft/class_2639", "net/minecraft/class_2805", "net/minecraft/class_7472", "net/minecraft/class_7496", "net/minecraft/class_2811", "net/minecraft/class_2797", "net/minecraft/class_2813", "net/minecraft/class_2848", "net/minecraft/class_2803", "net/minecraft/class_2803", "net/minecraft/class_4210", "net/minecraft/class_4211", "net/minecraft/class_4463", "net/minecraft/class_2708", "net/minecraft/class_2846", "net/minecraft/class_2851", "net/minecraft/class_2707", "net/minecraft/class_2761", "net/minecraft/class_2632", "net/minecraft/class_5900", "net/minecraft/class_2788", "net/minecraft/class_2790", "net/minecraft/class_2703", "net/minecraft/class_2613", "net/minecraft/class_2755", "net/minecraft/class_2762"});
    private static final Set<Class<?>> channel2 = RakNetMultiChannel.createClassSet(new String[]{"net/minecraft/class_5890", "net/minecraft/class_5891", "net/minecraft/class_2716", "net/minecraft/class_2604", "net/minecraft/class_2616", "net/minecraft/class_2663", "net/minecraft/class_2684$class_2685", "net/minecraft/class_2684$class_2687", "net/minecraft/class_2684$class_2686", "net/minecraft/class_2726", "net/minecraft/class_2739", "net/minecraft/class_2740", "net/minecraft/class_2743", "net/minecraft/class_2744", "net/minecraft/class_2752", "net/minecraft/class_2777", "net/minecraft/class_2781", "net/minecraft/class_2783", "net/minecraft/class_2718", "net/minecraft/class_2610", "net/minecraft/class_2612", "net/minecraft/class_2606", "net/minecraft/class_2885", "net/minecraft/class_2886", "net/minecraft/class_2824", "net/minecraft/class_2828", "net/minecraft/class_2828$class_5911", "net/minecraft/class_2828$class_2829", "net/minecraft/class_2828$class_2830", "net/minecraft/class_2828$class_2831", "net/minecraft/class_2664", "net/minecraft/class_2678", "net/minecraft/class_2668", "net/minecraft/class_2759", "net/minecraft/class_2775", "net/minecraft/class_2696", "net/minecraft/class_2734", "net/minecraft/class_2692", "net/minecraft/class_2836", "net/minecraft/class_2833", "net/minecraft/class_2879", "net/minecraft/class_2684", "net/minecraft/class_2698"});
    private static final Set<Class<?>> channel3 = RakNetMultiChannel.createClassSet(new String[]{"net/minecraft/class_2884", "net/minecraft/class_2793", "net/minecraft/class_2795", "net/minecraft/class_2822", "net/minecraft/class_2774", "net/minecraft/class_2645", "net/minecraft/class_2648", "net/minecraft/class_3944", "net/minecraft/class_2651", "net/minecraft/class_2653", "net/minecraft/class_3895", "net/minecraft/class_2649", "net/minecraft/class_2713", "net/minecraft/class_2735", "net/minecraft/class_3943", "net/minecraft/class_2820", "net/minecraft/class_2853", "net/minecraft/class_5427", "net/minecraft/class_2855", "net/minecraft/class_2815", "net/minecraft/class_2873", "net/minecraft/class_2840", "net/minecraft/class_2838", "net/minecraft/class_2863", "net/minecraft/class_2866", "net/minecraft/class_2870", "net/minecraft/class_2871", "net/minecraft/class_3753", "net/minecraft/class_2842", "net/minecraft/class_2868", "net/minecraft/class_2875", "net/minecraft/class_2695", "net/minecraft/class_5889", "net/minecraft/class_5895", "net/minecraft/class_5896", "net/minecraft/class_5897", "net/minecraft/class_5898", "net/minecraft/class_5899", "net/minecraft/class_2799", "net/minecraft/class_2724", "net/minecraft/class_2817", "net/minecraft/class_2658", "net/minecraft/class_2809", "net/minecraft/class_2644", "net/minecraft/class_2730"});
    private static final Set<Class<?>> channel4 = RakNetMultiChannel.createClassSet(new String[]{"net/minecraft/class_2683", "net/minecraft/class_2660", "net/minecraft/class_2765", "net/minecraft/class_2767", "net/minecraft/class_2770", "net/minecraft/class_2675", "net/minecraft/class_5747"});
    private static final Set<Class<?>> channel7 = RakNetMultiChannel.createClassSet(new String[]{"net/minecraft/class_5194", "net/minecraft/class_2693", "net/minecraft/class_2877", "net/minecraft/class_2623", "net/minecraft/class_4282", "net/minecraft/class_4273", "net/minecraft/class_6682", "net/minecraft/class_2666", "net/minecraft/class_2626", "net/minecraft/class_2637", "net/minecraft/class_2673", "net/minecraft/class_2620", "net/minecraft/class_2672", "net/minecraft/class_2622", "net/minecraft/class_2676"});
    private static final Set<Class<?>> unreliable = RakNetMultiChannel.createClassSet(new String[0]);
    private static final Object2IntOpenHashMap<Class<?>> classToChannelIdOverride = new Object2IntOpenHashMap();
    private static final Set<Class<?>> foundUnknownClasses;

    private RakNetMultiChannel() {
    }

    private static Set<Class<?>> createClassSet(String[] classNames) {
        MappingResolver mappingResolver = FabricLoader.getInstance().getMappingResolver();
        boolean isIntermediaryNamespace = mappingResolver.getCurrentRuntimeNamespace().equals("intermediary");
        HashSet classHashSet = new HashSet();
        for (String className : classNames) {
            String intermediary = mappingResolver.mapClassName("intermediary", className.replace('/', '.'));
            if (!isIntermediaryNamespace && intermediary.equals(className)) {
                System.err.println("Raknetify: Warning: Failed to remap %s for raknet multi-channel".formatted(intermediary));
            }
            try {
                classHashSet.add(Class.forName(intermediary));
            }
            catch (ClassNotFoundException e) {
                System.out.println("Raknetify: Warning: %s not found for raknet multi-channel".formatted(intermediary));
            }
        }
        return classHashSet;
    }

    public static int getPacketChannelOverride(Class<?> clazz) {
        if (clazz == null) {
            System.err.println("Raknetify: Warning: Tried to send packet without setting packet class");
            return 0;
        }
        int channelOverride = classToChannelIdOverride.getInt(clazz);
        if (channelOverride == Integer.MAX_VALUE) {
            if (foundUnknownClasses.add(clazz)) {
                MappingResolver mappingResolver = FabricLoader.getInstance().getMappingResolver();
                String intermediary = mappingResolver.unmapClassName("intermediary", clazz.getName());
                System.err.println("Raknetify: Warning: unknown packet type %s (%s) for raknet multi-channel".formatted(intermediary.replace('.', '/'), clazz.getName()));
            }
            channelOverride = 7;
        }
        return channelOverride;
    }

    public static void init() {
    }

    public static void iterateKnownPackets() {
        for (Map.Entry<class_2598, class_2539.class_4532<?>> entry : ((INetworkState)class_2539.field_20591).getPacketHandlers().entrySet()) {
            for (Object2IntMap.Entry type : ((INetworkStatePacketHandler)entry.getValue()).getPacketIds().object2IntEntrySet()) {
                RakNetMultiChannel.getPacketChannelOverride((Class)type.getKey());
            }
        }
    }

    static {
        classToChannelIdOverride.defaultReturnValue(Integer.MAX_VALUE);
        unordered.forEach(clazz -> classToChannelIdOverride.put(clazz, -1));
        channel1.forEach(clazz -> classToChannelIdOverride.put(clazz, 1));
        channel2.forEach(clazz -> classToChannelIdOverride.put(clazz, 2));
        channel3.forEach(clazz -> classToChannelIdOverride.put(clazz, 3));
        channel4.forEach(clazz -> classToChannelIdOverride.put(clazz, 4));
        channel7.forEach(clazz -> classToChannelIdOverride.put(clazz, 7));
        unreliable.forEach(clazz -> classToChannelIdOverride.put(clazz, -2));
        foundUnknownClasses = Sets.newConcurrentHashSet();
    }
}

