/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.vmp.mixins.chunk.loading.async_chunk_on_player_login;

import com.ishland.vmp.common.chunk.loading.async_chunks_on_player_login.AsyncChunkLoadUtil;
import com.ishland.vmp.common.chunk.loading.async_chunks_on_player_login.IAsyncChunkPlayer;
import com.ishland.vmp.common.config.Config;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_2799;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3738;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3244.class})
public abstract class MixinServerPlayNetworkHandler {
    @Shadow
    public class_3222 field_14140;
    @Shadow
    @Final
    private MinecraftServer field_14148;
    @Shadow
    @Final
    private static Logger field_14121;
    @Shadow
    @Final
    public class_2535 field_14127;
    @Unique
    private boolean isPerformingRespawn = false;

    @Shadow
    public abstract void method_12068(class_2799 var1);

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerEntity;updatePositionAndAngles(DDDFF)V"))
    private void suppressUpdatePositionDuringChunkLoad(class_3222 instance, double x, double y, double z, float yaw, float pitch) {
        if (((IAsyncChunkPlayer)instance).isChunkLoadCompleted()) {
            instance.method_5641(x, y, z, yaw, pitch);
        }
    }

    @Inject(method={"onClientStatus"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/NetworkThreadUtils;forceMainThread(Lnet/minecraft/network/Packet;Lnet/minecraft/network/listener/PacketListener;Lnet/minecraft/server/world/ServerWorld;)V", shift=At.Shift.AFTER)}, cancellable=true)
    private void performAsyncRespawn(class_2799 packet, CallbackInfo ci) {
        if (packet.method_12119() == class_2799.class_2800.field_12774) {
            if (AsyncChunkLoadUtil.isRespawnChunkLoadFinished()) {
                return;
            }
            if (!this.field_14140.field_13989 && this.field_14140.method_6032() > 0.0f) {
                return;
            }
            ci.cancel();
            if (this.isPerformingRespawn) {
                return;
            }
            this.isPerformingRespawn = true;
            class_3218 spawnPointWorld = this.field_14148.method_3847(this.field_14140.method_26281());
            spawnPointWorld = spawnPointWorld != null ? spawnPointWorld : this.field_14148.method_30002();
            class_2338 spawnPointPosition = this.field_14140.method_26280();
            spawnPointPosition = spawnPointPosition != null ? spawnPointPosition : spawnPointWorld.method_43126();
            class_1923 pos = new class_1923(spawnPointPosition);
            if (Config.SHOW_ASYNC_LOADING_MESSAGES) {
                this.field_14140.method_7353((class_2561)class_2561.method_43470((String)"Performing respawn..."), true);
            }
            long startTime = System.nanoTime();
            AsyncChunkLoadUtil.scheduleChunkLoad(spawnPointWorld, pos).whenCompleteAsync((unused, throwable) -> {
                if (!this.field_14127.method_10758()) {
                    return;
                }
                if (Config.SHOW_ASYNC_LOADING_MESSAGES) {
                    field_14121.info("Async chunk loading for player {} completed", (Object)this.field_14140.method_5477().getString());
                }
                this.isPerformingRespawn = false;
                try {
                    AsyncChunkLoadUtil.setIsRespawnChunkLoadFinished(true);
                    this.method_12068(packet);
                }
                finally {
                    AsyncChunkLoadUtil.setIsRespawnChunkLoadFinished(false);
                }
                if (Config.SHOW_ASYNC_LOADING_MESSAGES) {
                    this.field_14140.method_7353((class_2561)class_2561.method_43470((String)"Respawn finished after %.1fms".formatted((double)(System.nanoTime() - startTime) / 1000000.0)), true);
                }
            }, runnable -> this.field_14148.method_18858((Runnable)new class_3738(0, runnable)));
        }
    }
}

