/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.vmp.mixins.networking.priority.sync;

import com.ishland.vmp.common.networking.priority.PacketPriorityHandler;
import com.ishland.vmp.mixins.access.IClientConnection;
import io.netty.channel.Channel;
import io.netty.channel.socket.SocketChannel;
import net.minecraft.class_2535;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3324.class})
public class MixinPlayerManager {
    @Inject(method={"respawnPlayer"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerEntity;onSpawn()V", shift=At.Shift.AFTER)})
    private void afterMoveToAnotherWorld(class_3222 player, boolean alive, CallbackInfoReturnable<class_3222> cir) {
        Channel channel = ((IClientConnection)player.field_13987.field_14127).getChannel();
        if (channel == null) {
            System.err.println("VMP: Warning: %s don't have valid channel when teleporting to another dimension, not starting priority handling".formatted(this));
            return;
        }
        if (channel instanceof SocketChannel) {
            channel.pipeline().fireUserEventTriggered(PacketPriorityHandler.START_PRIORITY);
        }
    }

    @Inject(method={"onPlayerConnect"}, at={@At(value="RETURN")})
    private void postJoin(class_2535 connection, class_3222 player, CallbackInfo ci) {
        Channel channel = ((IClientConnection)connection).getChannel();
        if (channel == null) {
            System.err.println("VMP: Warning: %s don't have valid channel when logged in, not sending sync packet".formatted(this));
            return;
        }
        if (channel instanceof SocketChannel) {
            channel.pipeline().fireUserEventTriggered(PacketPriorityHandler.START_PRIORITY);
        }
    }
}

