/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.waveycapes.renderlayers;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.tr7zw.waveycapes.CapeRenderInfo;
import dev.tr7zw.waveycapes.CapeRenderer;
import dev.tr7zw.waveycapes.NMSUtil;
import dev.tr7zw.waveycapes.PlayerModelAccess;
import dev.tr7zw.waveycapes.VanillaCapeRenderer;
import dev.tr7zw.waveycapes.WaveyCapesBase;
import dev.tr7zw.waveycapes.support.ModSupport;
import dev.tr7zw.waveycapes.support.SupportManager;
import dev.tr7zw.waveycapes.util.NMSHelper;
import dev.tr7zw.waveycapes.versionless.CapeHolder;
import dev.tr7zw.waveycapes.versionless.CapeMovement;
import dev.tr7zw.waveycapes.versionless.CapeStyle;
import dev.tr7zw.waveycapes.versionless.ModBase;
import dev.tr7zw.waveycapes.versionless.WindMode;
import dev.tr7zw.waveycapes.versionless.sim.BasicSimulation;
import dev.tr7zw.waveycapes.versionless.util.Vector3;
import net.minecraft.class_1159;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_583;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;

public class CustomCapeRenderLayer
extends class_3887<class_742, class_591<class_742>> {
    private static final int PART_COUNT = 16;
    private class_630[] customCape = NMSUtil.buildCape(64, 64, x -> 0, y -> y);
    private static VanillaCapeRenderer vanillaCape = new VanillaCapeRenderer();

    public CustomCapeRenderLayer(class_3883<class_742, class_591<class_742>> renderLayerParent) {
        super(renderLayerParent);
    }

    public void render(class_4587 poseStack, class_4597 multiBufferSource, int i, class_742 abstractClientPlayer, float f, float g, float delta, float j, float k, float l) {
        CapeRenderInfo capeRenderInfo = new CapeRenderInfo(abstractClientPlayer);
        if (capeRenderInfo.isPlayerInvisible()) {
            return;
        }
        CapeRenderer renderer = this.getCapeRenderer(capeRenderInfo, multiBufferSource);
        if (renderer == null) {
            return;
        }
        if (capeRenderInfo.hasElytraEquipped()) {
            return;
        }
        class_583 class_5832 = this.method_17165();
        if (class_5832 instanceof PlayerModelAccess) {
            PlayerModelAccess pma = (PlayerModelAccess)class_5832;
            if (!pma.getCloak().field_3665) {
                return;
            }
        }
        CapeHolder holder = capeRenderInfo.getCapeHolder();
        holder.updateSimulation(16);
        poseStack.method_22903();
        ((class_591)this.method_17165()).field_3391.method_22703(poseStack);
        if (ModBase.config.capeStyle == CapeStyle.SMOOTH && renderer.vanillaUvValues()) {
            this.renderSmoothCape(poseStack, multiBufferSource, renderer, capeRenderInfo, delta, i);
        } else {
            class_630[] parts = this.customCape;
            for (int part = 0; part < 16; ++part) {
                class_630 model = parts[part];
                this.modifyPoseStack(poseStack, capeRenderInfo, delta, part);
                renderer.render(capeRenderInfo, part, model, poseStack, multiBufferSource, i, class_4608.field_21444);
                poseStack.method_22909();
            }
        }
        poseStack.method_22909();
    }

    private void renderSmoothCape(class_4587 poseStack, class_4597 multiBufferSource, CapeRenderer capeRenderer, CapeRenderInfo capeRenderInfo, float delta, int light) {
        class_4588 bufferBuilder = capeRenderer.getVertexConsumer(multiBufferSource, capeRenderInfo);
        if (bufferBuilder == null) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        class_1159 oldPositionMatrix = null;
        for (int part = 0; part < 16; ++part) {
            this.modifyPoseStack(poseStack, capeRenderInfo, delta, part);
            if (oldPositionMatrix == null) {
                oldPositionMatrix = poseStack.method_23760().method_23761();
            }
            if (part == 0) {
                CustomCapeRenderLayer.addTopVertex(bufferBuilder, poseStack.method_23760().method_23761(), oldPositionMatrix, 0.3f, 0.0f, 0.0f, -0.3f, 0.0f, -0.06f, part, light);
            }
            if (part == 15) {
                CustomCapeRenderLayer.addBottomVertex(bufferBuilder, poseStack.method_23760().method_23761(), poseStack.method_23760().method_23761(), 0.3f, (float)(part + 1) * 0.06f, 0.0f, -0.3f, (float)(part + 1) * 0.06f, -0.06f, part, light);
            }
            CustomCapeRenderLayer.addLeftVertex(bufferBuilder, poseStack.method_23760().method_23761(), oldPositionMatrix, -0.3f, (float)(part + 1) * 0.06f, 0.0f, -0.3f, (float)part * 0.06f, -0.06f, part, light);
            CustomCapeRenderLayer.addRightVertex(bufferBuilder, poseStack.method_23760().method_23761(), oldPositionMatrix, 0.3f, (float)(part + 1) * 0.06f, 0.0f, 0.3f, (float)part * 0.06f, -0.06f, part, light);
            CustomCapeRenderLayer.addBackVertex(bufferBuilder, poseStack.method_23760().method_23761(), oldPositionMatrix, 0.3f, (float)(part + 1) * 0.06f, -0.06f, -0.3f, (float)part * 0.06f, -0.06f, part, light);
            CustomCapeRenderLayer.addFrontVertex(bufferBuilder, oldPositionMatrix, poseStack.method_23760().method_23761(), 0.3f, (float)(part + 1) * 0.06f, 0.0f, -0.3f, (float)part * 0.06f, 0.0f, part, light);
            oldPositionMatrix = new class_1159(poseStack.method_23760().method_23761());
            poseStack.method_22909();
        }
    }

    private void modifyPoseStack(class_4587 poseStack, CapeRenderInfo capeRenderInfo, float h, int part) {
        if (WaveyCapesBase.config.capeMovement != CapeMovement.VANILLA) {
            this.modifyPoseStackSimulation(poseStack, capeRenderInfo, h, part);
            return;
        }
        this.modifyPoseStackVanilla(poseStack, capeRenderInfo.getPlayer(), h, part);
    }

    private void modifyPoseStackSimulation(class_4587 poseStack, CapeRenderInfo capeRenderInfo, float delta, int part) {
        BasicSimulation simulation = capeRenderInfo.getCapeHolder().getSimulation();
        poseStack.method_22903();
        poseStack.method_22904(0.0, 0.0, 0.125);
        float x = simulation.getPoints().get(part).getLerpX(delta) - simulation.getPoints().get(0).getLerpX(delta);
        if (x > 0.0f) {
            x = 0.0f;
        }
        float y = simulation.getPoints().get(0).getLerpY(delta) - (float)part - simulation.getPoints().get(part).getLerpY(delta);
        float z = simulation.getPoints().get(0).getLerpZ(delta) - simulation.getPoints().get(part).getLerpZ(delta);
        float sidewaysRotationOffset = 0.0f;
        float partRotation = this.getRotation(delta, part, simulation);
        float height = 0.0f;
        float naturalWindSwing = this.getNatrualWindSwing(part, capeRenderInfo.isPlayerUnderwater());
        poseStack.method_22907(NMSHelper.XP.method_23214(6.0f + height + naturalWindSwing));
        poseStack.method_22907(NMSHelper.ZP.method_23214(sidewaysRotationOffset / 2.0f));
        poseStack.method_22907(NMSHelper.YP.method_23214(180.0f - sidewaysRotationOffset / 2.0f));
        poseStack.method_22904((double)(-z / 16.0f), (double)(y / 16.0f), (double)(x / 16.0f));
        poseStack.method_22904(0.0, 0.03, -0.03);
        poseStack.method_22904(0.0, (double)((float)part * 1.0f / 16.0f), (double)(part * 0 / 16));
        poseStack.method_22907(NMSHelper.XP.method_23214(-partRotation));
        poseStack.method_22904(0.0, (double)((float)(-part) * 1.0f / 16.0f), (double)(-part * 0 / 16));
        poseStack.method_22904(0.0, -0.03, 0.03);
    }

    private float getRotation(float delta, int part, BasicSimulation simulation) {
        if (part == 15) {
            return this.getRotation(delta, part - 1, simulation);
        }
        return (float)this.getAngle(simulation.getPoints().get(part).getLerpedPos(delta), simulation.getPoints().get(part + 1).getLerpedPos(delta));
    }

    private double getAngle(Vector3 a, Vector3 b) {
        Vector3 angle = b.subtract(a);
        return Math.toDegrees(Math.atan2(angle.x, angle.y)) + 180.0;
    }

    private void modifyPoseStackVanilla(class_4587 poseStack, class_742 abstractClientPlayer, float h, int part) {
        poseStack.method_22903();
        poseStack.method_22904(0.0, 0.0, 0.125);
        double d = class_3532.method_16436((double)h, (double)abstractClientPlayer.field_7524, (double)abstractClientPlayer.field_7500) - class_3532.method_16436((double)h, (double)abstractClientPlayer.field_6014, (double)abstractClientPlayer.method_23317());
        double e = class_3532.method_16436((double)h, (double)abstractClientPlayer.field_7502, (double)abstractClientPlayer.field_7521) - class_3532.method_16436((double)h, (double)abstractClientPlayer.field_6036, (double)abstractClientPlayer.method_23318());
        double m = class_3532.method_16436((double)h, (double)abstractClientPlayer.field_7522, (double)abstractClientPlayer.field_7499) - class_3532.method_16436((double)h, (double)abstractClientPlayer.field_5969, (double)abstractClientPlayer.method_23321());
        float n = abstractClientPlayer.field_6220 + abstractClientPlayer.field_6283 - abstractClientPlayer.field_6220;
        double o = class_3532.method_15374((float)(n * ((float)Math.PI / 180)));
        double p = -class_3532.method_15362((float)(n * ((float)Math.PI / 180)));
        float height = (float)e * 10.0f;
        height = class_3532.method_15363((float)height, (float)-6.0f, (float)32.0f);
        float swing = (float)(d * o + m * p) * CustomCapeRenderLayer.easeOutSine(0.0625f * (float)part) * 100.0f;
        swing = class_3532.method_15363((float)swing, (float)0.0f, (float)(150.0f * CustomCapeRenderLayer.easeOutSine(0.0625f * (float)part)));
        float sidewaysRotationOffset = (float)(d * p - m * o) * 100.0f;
        sidewaysRotationOffset = class_3532.method_15363((float)sidewaysRotationOffset, (float)-20.0f, (float)20.0f);
        float t = class_3532.method_16439((float)h, (float)abstractClientPlayer.field_7505, (float)abstractClientPlayer.field_7483);
        float naturalWindSwing = this.getNatrualWindSwing(part, abstractClientPlayer.method_5869());
        poseStack.method_22907(NMSHelper.XP.method_23214(6.0f + swing / 2.0f + (height += class_3532.method_15374((float)(class_3532.method_16439((float)h, (float)abstractClientPlayer.field_6039, (float)abstractClientPlayer.field_5973) * 6.0f)) * 32.0f * t) + naturalWindSwing));
        poseStack.method_22907(NMSHelper.ZP.method_23214(sidewaysRotationOffset / 2.0f));
        poseStack.method_22907(NMSHelper.YP.method_23214(180.0f - sidewaysRotationOffset / 2.0f));
    }

    private float getNatrualWindSwing(int part, boolean underwater) {
        long highlightedPart = System.currentTimeMillis() / (long)(underwater ? 9 : 3) % 360L;
        float relativePart = (float)(part + 1) / 16.0f;
        if (WaveyCapesBase.config.windMode == WindMode.WAVES) {
            return (float)(Math.sin(Math.toRadians(relativePart * 360.0f - (float)highlightedPart)) * 3.0);
        }
        return 0.0f;
    }

    private static void addBackVertex(class_4588 bufferBuilder, class_1159 matrix, class_1159 oldMatrix, float x1, float y1, float z1, float x2, float y2, float z2, int part, int light) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
            class_1159 k = matrix;
            matrix = oldMatrix;
            oldMatrix = k;
        }
        float minU = 0.015625f;
        float maxU = 0.171875f;
        float minV = 0.03125f;
        float maxV = 0.53125f;
        float deltaV = maxV - minV;
        float vPerPart = deltaV / 16.0f;
        maxV = minV + vPerPart * (float)(part + 1);
        NMSHelper.addVertex(bufferBuilder, oldMatrix, x1, y2, z1, maxU, minV += vPerPart * (float)part, class_4608.field_21444, light, 1, 0, 0);
        NMSHelper.addVertex(bufferBuilder, oldMatrix, x2, y2, z1, minU, minV, class_4608.field_21444, light, 1, 0, 0);
        NMSHelper.addVertex(bufferBuilder, matrix, x2, y1, z2, minU, maxV, class_4608.field_21444, light, 1, 0, 0);
        NMSHelper.addVertex(bufferBuilder, matrix, x1, y1, z2, maxU, maxV, class_4608.field_21444, light, 1, 0, 0);
    }

    private static void addFrontVertex(class_4588 bufferBuilder, class_1159 matrix, class_1159 oldMatrix, float x1, float y1, float z1, float x2, float y2, float z2, int part, int light) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
            class_1159 k = matrix;
            matrix = oldMatrix;
            oldMatrix = k;
        }
        float minU = 0.1875f;
        float maxU = 0.34375f;
        float minV = 0.03125f;
        float maxV = 0.53125f;
        float deltaV = maxV - minV;
        float vPerPart = deltaV / 16.0f;
        maxV = minV + vPerPart * (float)(part + 1);
        NMSHelper.addVertex(bufferBuilder, oldMatrix, x1, y1, z1, minU, maxV, class_4608.field_21444, light, 1, 0, 0);
        NMSHelper.addVertex(bufferBuilder, oldMatrix, x2, y1, z1, maxU, maxV, class_4608.field_21444, light, 1, 0, 0);
        NMSHelper.addVertex(bufferBuilder, matrix, x2, y2, z2, maxU, minV += vPerPart * (float)part, class_4608.field_21444, light, 1, 0, 0);
        NMSHelper.addVertex(bufferBuilder, matrix, x1, y2, z2, minU, minV, class_4608.field_21444, light, 1, 0, 0);
    }

    private static void addLeftVertex(class_4588 bufferBuilder, class_1159 matrix, class_1159 oldMatrix, float x1, float y1, float z1, float x2, float y2, float z2, int part, int light) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        float minU = 0.0f;
        float maxU = 0.015625f;
        float minV = 0.03125f;
        float maxV = 0.53125f;
        float deltaV = maxV - minV;
        float vPerPart = deltaV / 16.0f;
        maxV = minV + vPerPart * (float)(part + 1);
        NMSHelper.addVertex(bufferBuilder, matrix, x2, y1, z1, minU, maxV, class_4608.field_21444, light, 1, 0, 0);
        NMSHelper.addVertex(bufferBuilder, matrix, x2, y1, z2, maxU, maxV, class_4608.field_21444, light, 1, 0, 0);
        NMSHelper.addVertex(bufferBuilder, oldMatrix, x2, y2, z2, maxU, minV += vPerPart * (float)part, class_4608.field_21444, light, 1, 0, 0);
        NMSHelper.addVertex(bufferBuilder, oldMatrix, x2, y2, z1, minU, minV, class_4608.field_21444, light, 1, 0, 0);
    }

    private static void addRightVertex(class_4588 bufferBuilder, class_1159 matrix, class_1159 oldMatrix, float x1, float y1, float z1, float x2, float y2, float z2, int part, int light) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        float minU = 0.171875f;
        float maxU = 0.1875f;
        float minV = 0.03125f;
        float maxV = 0.53125f;
        float deltaV = maxV - minV;
        float vPerPart = deltaV / 16.0f;
        maxV = minV + vPerPart * (float)(part + 1);
        NMSHelper.addVertex(bufferBuilder, matrix, x2, y1, z2, minU, maxV, class_4608.field_21444, light, 1, 0, 0);
        NMSHelper.addVertex(bufferBuilder, matrix, x2, y1, z1, maxU, maxV, class_4608.field_21444, light, 1, 0, 0);
        NMSHelper.addVertex(bufferBuilder, oldMatrix, x2, y2, z1, maxU, minV += vPerPart * (float)part, class_4608.field_21444, light, 1, 0, 0);
        NMSHelper.addVertex(bufferBuilder, oldMatrix, x2, y2, z2, minU, minV, class_4608.field_21444, light, 1, 0, 0);
    }

    private static void addBottomVertex(class_4588 bufferBuilder, class_1159 matrix, class_1159 oldMatrix, float x1, float y1, float z1, float x2, float y2, float z2, int part, int light) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        float minU = 0.171875f;
        float maxU = 0.328125f;
        float minV = 0.0f;
        float maxV = 0.03125f;
        float deltaV = maxV - minV;
        float vPerPart = deltaV / 16.0f;
        maxV = minV + vPerPart * (float)(part + 1);
        NMSHelper.addVertex(bufferBuilder, oldMatrix, x1, y2, z2, maxU, minV += vPerPart * (float)part, class_4608.field_21444, light, 1, 0, 0);
        NMSHelper.addVertex(bufferBuilder, oldMatrix, x2, y2, z2, minU, minV, class_4608.field_21444, light, 1, 0, 0);
        NMSHelper.addVertex(bufferBuilder, matrix, x2, y1, z1, minU, maxV, class_4608.field_21444, light, 1, 0, 0);
        NMSHelper.addVertex(bufferBuilder, matrix, x1, y1, z1, maxU, maxV, class_4608.field_21444, light, 1, 0, 0);
    }

    private static void addTopVertex(class_4588 bufferBuilder, class_1159 matrix, class_1159 oldMatrix, float x1, float y1, float z1, float x2, float y2, float z2, int part, int light) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        float minU = 0.015625f;
        float maxU = 0.171875f;
        float minV = 0.0f;
        float maxV = 0.03125f;
        float deltaV = maxV - minV;
        float vPerPart = deltaV / 16.0f;
        maxV = minV + vPerPart * (float)(part + 1);
        NMSHelper.addVertex(bufferBuilder, oldMatrix, x1, y2, z1, maxU, maxV, class_4608.field_21444, light, 0, 1, 0);
        NMSHelper.addVertex(bufferBuilder, oldMatrix, x2, y2, z1, minU, maxV, class_4608.field_21444, light, 0, 1, 0);
        NMSHelper.addVertex(bufferBuilder, matrix, x2, y1, z2, minU, minV += vPerPart * (float)part, class_4608.field_21444, light, 0, 1, 0);
        NMSHelper.addVertex(bufferBuilder, matrix, x1, y1, z2, maxU, minV, class_4608.field_21444, light, 0, 1, 0);
    }

    private CapeRenderer getCapeRenderer(CapeRenderInfo capeRenderInfo, class_4597 multiBufferSource) {
        for (ModSupport support : SupportManager.getSupportedMods()) {
            if (!support.shouldBeUsed(capeRenderInfo)) continue;
            return support.getRenderer();
        }
        if (capeRenderInfo.getCapeTexture() == null || !capeRenderInfo.isCapeVisible()) {
            return null;
        }
        CustomCapeRenderLayer.vanillaCape.vertexConsumer = multiBufferSource.getBuffer(class_1921.method_23576((class_2960)capeRenderInfo.getCapeTexture()));
        return vanillaCape;
    }

    private static float easeOutSine(float x) {
        return class_3532.method_15374((float)((float)((double)x * Math.PI / 2.0)));
    }
}

