/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block.entity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.container.ImplementedContainer;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.waystones.api.IAttunementItem;
import net.blay09.mods.waystones.api.IMutableWaystone;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.block.WarpPlateBlock;
import net.blay09.mods.waystones.block.entity.ModBlockEntities;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WarpMode;
import net.blay09.mods.waystones.core.Waystone;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.core.WaystoneTypes;
import net.blay09.mods.waystones.item.AttunedShardItem;
import net.blay09.mods.waystones.item.ModItems;
import net.blay09.mods.waystones.menu.WarpPlateContainer;
import net.blay09.mods.waystones.worldgen.namegen.NameGenerationMode;
import net.blay09.mods.waystones.worldgen.namegen.NameGenerator;
import net.minecraft.class_124;
import net.minecraft.class_1262;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_5425;
import org.jetbrains.annotations.Nullable;

public class WarpPlateBlockEntity
extends WaystoneBlockEntityBase
implements ImplementedContainer {
    private final WeakHashMap<class_1297, Integer> ticksPassedPerEntity = new WeakHashMap();
    private final Random random = new Random();
    private final class_3913 dataAccess;
    private final class_2371<class_1799> items = class_2371.method_10213((int)5, (Object)class_1799.field_8037);
    private int attunementTicks;
    private boolean readyForAttunement;
    private boolean completedFirstAttunement;
    private int lastAttunementSlot;

    public WarpPlateBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)ModBlockEntities.warpPlate.get(), blockPos, blockState);
        this.dataAccess = new class_3913(){

            public int method_17390(int i) {
                return WarpPlateBlockEntity.this.attunementTicks;
            }

            public void method_17391(int i, int j) {
                WarpPlateBlockEntity.this.attunementTicks = j;
            }

            public int method_17389() {
                return 1;
            }
        };
    }

    public class_2371<class_1799> getItems() {
        return this.items;
    }

    public class_1799 method_5434(int slot, int count) {
        if (!this.completedFirstAttunement) {
            return class_1799.field_8037;
        }
        return super.method_5434(slot, count);
    }

    public class_1799 method_5441(int slot) {
        if (!this.completedFirstAttunement) {
            return class_1799.field_8037;
        }
        return super.method_5441(slot);
    }

    @Override
    public void initializeFromExisting(class_5425 world, Waystone existingWaystone, class_1799 itemStack) {
        super.initializeFromExisting(world, existingWaystone, itemStack);
        class_2487 tag = itemStack.method_7969();
        boolean bl = this.completedFirstAttunement = tag != null && tag.method_10577("CompletedFirstAttunement");
        if (!this.completedFirstAttunement) {
            this.initializeInventory();
        }
    }

    @Override
    public void initializeWaystone(class_5425 world, @Nullable class_1309 player, boolean wasGenerated) {
        super.initializeWaystone(world, player, wasGenerated);
        IWaystone waystone = this.getWaystone();
        if (waystone instanceof IMutableWaystone) {
            String name = NameGenerator.get(world.method_8503()).getName(waystone, world.method_8409(), NameGenerationMode.RANDOM_ONLY);
            ((IMutableWaystone)((Object)waystone)).setName(name);
        }
        WaystoneSyncManager.sendWaystoneUpdateToAll(world.method_8503(), waystone);
        this.initializeInventory();
    }

    private void initializeInventory() {
        this.method_5447(0, new class_1799((class_1935)class_1802.field_8145));
        this.method_5447(1, new class_1799((class_1935)ModItems.warpDust));
        this.method_5447(2, new class_1799((class_1935)ModItems.warpDust));
        this.method_5447(3, new class_1799((class_1935)ModItems.warpDust));
        this.method_5447(4, new class_1799((class_1935)ModItems.warpDust));
    }

    @Override
    protected class_2960 getWaystoneType() {
        return WaystoneTypes.WARP_PLATE;
    }

    @Override
    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        class_1262.method_5426((class_2487)tag, this.items);
        tag.method_10556("ReadyForAttunement", this.readyForAttunement);
        tag.method_10556("CompletedFirstAttunement", this.completedFirstAttunement);
        tag.method_10569("LastAttunementSlot", this.lastAttunementSlot);
    }

    @Override
    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        class_1262.method_5429((class_2487)compound, this.items);
        this.readyForAttunement = compound.method_10577("ReadyForAttunement");
        this.completedFirstAttunement = compound.method_10577("CompletedFirstAttunement");
        this.lastAttunementSlot = compound.method_10550("LastAttunementSlot");
    }

    public BalmMenuProvider getMenuProvider() {
        return new BalmMenuProvider(){

            public class_2561 method_5476() {
                return class_2561.method_43471((String)"container.waystones.warp_plate");
            }

            public class_1703 createMenu(int i, class_1661 playerInventory, class_1657 player) {
                return new WarpPlateContainer(i, WarpPlateBlockEntity.this, WarpPlateBlockEntity.this.dataAccess, playerInventory);
            }

            public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
                buf.method_10807(WarpPlateBlockEntity.this.field_11867);
            }
        };
    }

    @Override
    public class_3908 getSettingsMenuProvider() {
        return null;
    }

    public void onEntityCollision(class_1297 entity) {
        Integer ticksPassed = this.ticksPassedPerEntity.putIfAbsent(entity, 0);
        if (ticksPassed == null || ticksPassed != -1) {
            this.field_11863.method_8652(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)WarpPlateBlock.ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    private boolean isEntityOnWarpPlate(class_1297 entity) {
        return entity.method_23317() >= (double)this.field_11867.method_10263() && entity.method_23317() < (double)(this.field_11867.method_10263() + 1) && entity.method_23318() >= (double)this.field_11867.method_10264() && entity.method_23318() < (double)(this.field_11867.method_10264() + 1) && entity.method_23321() >= (double)this.field_11867.method_10260() && entity.method_23321() < (double)(this.field_11867.method_10260() + 1);
    }

    public void serverTick() {
        class_238 boundsAbove;
        List entities;
        if (this.isReadyForAttunement()) {
            ++this.attunementTicks;
            if (this.attunementTicks >= this.getMaxAttunementTicks()) {
                this.attunementTicks = 0;
                class_1799 attunedShard = new class_1799((class_1935)ModItems.attunedShard);
                AttunedShardItem.setWaystoneAttunedTo(attunedShard, this.getWaystone());
                this.method_5447(0, attunedShard);
                for (int i = 1; i <= 4; ++i) {
                    this.method_5447(i, class_1799.field_8037);
                }
                this.completedFirstAttunement = true;
            }
        } else {
            this.attunementTicks = 0;
        }
        if (((Boolean)this.method_11010().method_11654((class_2769)WarpPlateBlock.ACTIVE)).booleanValue() && (entities = this.field_11863.method_8333((class_1297)null, boundsAbove = new class_238((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), (double)(this.field_11867.method_10263() + 1), (double)(this.field_11867.method_10264() + 1), (double)(this.field_11867.method_10260() + 1)), class_1301.field_6154)).isEmpty()) {
            this.field_11863.method_8652(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)WarpPlateBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
            this.ticksPassedPerEntity.clear();
        }
        int useTime = this.getWarpPlateUseTime();
        Iterator<Map.Entry<class_1297, Integer>> iterator = this.ticksPassedPerEntity.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<class_1297, Integer> entry = iterator.next();
            class_1297 entity = entry.getKey();
            Integer ticksPassed = entry.getValue();
            if (!entity.method_5805() || !this.isEntityOnWarpPlate(entity)) {
                iterator.remove();
                continue;
            }
            if (ticksPassed > useTime) {
                IWaystone targetWaystone = this.getTargetWaystone();
                if (targetWaystone != null && targetWaystone.isValid()) {
                    this.teleportToWarpPlate(entity, targetWaystone);
                }
                if (entity instanceof class_1657) {
                    if (targetWaystone == null) {
                        chatComponent = class_2561.method_43471((String)"chat.waystones.warp_plate_has_no_target");
                        chatComponent.method_27692(class_124.field_1079);
                        ((class_1657)entity).method_7353((class_2561)chatComponent, true);
                    } else if (!targetWaystone.isValid()) {
                        chatComponent = class_2561.method_43471((String)"chat.waystones.warp_plate_has_invalid_target");
                        chatComponent.method_27692(class_124.field_1079);
                        ((class_1657)entity).method_7353((class_2561)chatComponent, true);
                    }
                }
                iterator.remove();
                continue;
            }
            if (ticksPassed == -1) continue;
            entry.setValue(ticksPassed + 1);
        }
        if (this.method_5438(0).method_7909() != class_1802.field_8145) {
            this.completedFirstAttunement = true;
        }
    }

    private int getWarpPlateUseTime() {
        float useTimeMultiplier = 1.0f;
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 itemStack = this.method_5438(i);
            if (itemStack.method_7909() == class_1802.field_27063) {
                useTimeMultiplier -= 0.016f * (float)itemStack.method_7947();
                continue;
            }
            if (itemStack.method_7909() != class_1802.field_8777) continue;
            useTimeMultiplier += 0.016f * (float)itemStack.method_7947();
        }
        int configuredUseTime = WaystonesConfig.getActive().cooldowns.warpPlateUseTime;
        return class_3532.method_15340((int)((int)((float)configuredUseTime * useTimeMultiplier)), (int)1, (int)(configuredUseTime * 2));
    }

    private void teleportToWarpPlate(class_1297 entity, IWaystone targetWaystone) {
        PlayerWaystoneManager.tryTeleportToWaystone(entity, targetWaystone, WarpMode.WARP_PLATE, this.getWaystone()).ifLeft(entities -> entities.forEach(this::applyWarpPlateEffects));
    }

    private void applyWarpPlateEffects(class_1297 entity) {
        int fireSeconds = 0;
        int poisonSeconds = 0;
        int blindSeconds = 0;
        int featherFallSeconds = 0;
        int fireResistanceSeconds = 0;
        int witherSeconds = 0;
        int potency = 1;
        ArrayList<class_1799> curativeItems = new ArrayList<class_1799>();
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 itemStack = this.method_5438(i);
            if (itemStack.method_7909() == class_1802.field_8183) {
                fireSeconds += itemStack.method_7947();
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8635) {
                poisonSeconds += itemStack.method_7947();
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8794) {
                blindSeconds += itemStack.method_7947();
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8103 || itemStack.method_7909() == class_1802.field_21086) {
                curativeItems.add(itemStack);
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8477) {
                potency = Math.min(4, potency + itemStack.method_7947());
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8153) {
                featherFallSeconds = Math.min(8, featherFallSeconds + itemStack.method_7947());
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8135) {
                fireResistanceSeconds = Math.min(8, fireResistanceSeconds + itemStack.method_7947());
                continue;
            }
            if (itemStack.method_7909() != class_1802.field_17515) continue;
            witherSeconds += itemStack.method_7947();
        }
        if (entity instanceof class_1309) {
            if (fireSeconds > 0) {
                entity.method_5639(fireSeconds);
            }
            if (poisonSeconds > 0) {
                ((class_1309)entity).method_6092(new class_1293(class_1294.field_5899, poisonSeconds * 20, potency));
            }
            if (blindSeconds > 0) {
                ((class_1309)entity).method_6092(new class_1293(class_1294.field_5919, blindSeconds * 20, potency));
            }
            if (featherFallSeconds > 0) {
                ((class_1309)entity).method_6092(new class_1293(class_1294.field_5906, featherFallSeconds * 20, potency));
            }
            if (fireResistanceSeconds > 0) {
                ((class_1309)entity).method_6092(new class_1293(class_1294.field_5918, fireResistanceSeconds * 20, potency));
            }
            if (witherSeconds > 0) {
                ((class_1309)entity).method_6092(new class_1293(class_1294.field_5920, witherSeconds * 20, potency));
            }
            for (class_1799 curativeItem : curativeItems) {
                Balm.getHooks().curePotionEffects((class_1309)entity, curativeItem);
            }
        }
    }

    private boolean isReadyForAttunement() {
        return this.readyForAttunement && this.method_5438(0).method_7909() == class_1802.field_8145 && this.method_5438(1).method_7909() == ModItems.warpDust && this.method_5438(2).method_7909() == ModItems.warpDust && this.method_5438(3).method_7909() == ModItems.warpDust && this.method_5438(4).method_7909() == ModItems.warpDust;
    }

    @Nullable
    public IWaystone getTargetWaystone() {
        boolean useRoundRobin = false;
        ArrayList<class_1799> attunedShards = new ArrayList<class_1799>();
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 itemStack = this.method_5438(i);
            if (itemStack.method_7909() instanceof IAttunementItem) {
                IWaystone waystoneAttunedTo = ((IAttunementItem)itemStack.method_7909()).getWaystoneAttunedTo(this.field_11863.method_8503(), itemStack);
                if (waystoneAttunedTo == null || waystoneAttunedTo.getWaystoneUid().equals(this.getWaystone().getWaystoneUid())) continue;
                attunedShards.add(itemStack);
                continue;
            }
            if (itemStack.method_7909() != class_1802.field_8155) continue;
            useRoundRobin = true;
        }
        if (!attunedShards.isEmpty()) {
            this.lastAttunementSlot = (this.lastAttunementSlot + 1) % attunedShards.size();
            class_1799 itemStack = useRoundRobin ? (class_1799)attunedShards.get(this.lastAttunementSlot) : (class_1799)attunedShards.get(this.random.nextInt(attunedShards.size()));
            return ((IAttunementItem)itemStack.method_7909()).getWaystoneAttunedTo(this.field_11863.method_8503(), itemStack);
        }
        return null;
    }

    public int getMaxAttunementTicks() {
        return 30;
    }

    public void markReadyForAttunement() {
        this.readyForAttunement = true;
    }

    public void markEntityForCooldown(class_1297 entity) {
        this.ticksPassedPerEntity.put(entity, -1);
    }

    public boolean isCompletedFirstAttunement() {
        return this.completedFirstAttunement;
    }

    public class_3913 getContainerData() {
        return this.dataAccess;
    }
}

