/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wirelesschargers;

import com.supermartijn642.wirelesschargers.ChargerBlockEntity;
import com.supermartijn642.wirelesschargers.ChargerType;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import team.reborn.energy.api.EnergyStorage;

public class ChargerApiProviders {
    public static void register() {
        for (ChargerType type : ChargerType.values()) {
            EnergyStorage.SIDED.registerForBlockEntity((entity, direction) -> new ChargerEnergyStorage((ChargerBlockEntity)((Object)entity)), type.getBlockEntityType());
        }
    }

    private static class ChargerEnergyStorage
    extends SnapshotParticipant<Integer>
    implements EnergyStorage {
        private final ChargerBlockEntity entity;

        private ChargerEnergyStorage(ChargerBlockEntity entity) {
            this.entity = entity;
        }

        protected Integer createSnapshot() {
            return this.entity.getEnergyStored();
        }

        protected void readSnapshot(Integer snapshot) {
            this.entity.setEnergyStored(snapshot);
        }

        public boolean supportsInsertion() {
            return true;
        }

        public long insert(long maxAmount, TransactionContext transaction) {
            StoragePreconditions.notNegative((long)maxAmount);
            maxAmount = Math.min(maxAmount, 0x3FFFFFFFL);
            this.updateSnapshots(transaction);
            return this.entity.receiveEnergy((int)maxAmount, false);
        }

        public boolean supportsExtraction() {
            return false;
        }

        public long extract(long maxAmount, TransactionContext transaction) {
            return 0L;
        }

        public long getAmount() {
            return this.entity.getEnergyStored();
        }

        public long getCapacity() {
            return this.entity.getMaxEnergyStored();
        }
    }
}

