/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wirelesschargers;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.block.BaseBlockEntity;
import com.supermartijn642.core.block.TickableBlockEntity;
import com.supermartijn642.wirelesschargers.ChargerType;
import com.supermartijn642.wirelesschargers.TrinketsSlotStorage;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3545;
import team.reborn.energy.api.EnergyStorage;

public class ChargerBlockEntity
extends BaseBlockEntity
implements TickableBlockEntity {
    private static final int SEARCH_BLOCKS_PER_TICK = 5;
    private static final Set<class_2350> CAPABILITY_DIRECTIONS = EnumSet.allOf(class_2350.class);
    public final ChargerType type;
    private int energy;
    private boolean highlightArea;
    private RedstoneMode redstoneMode = RedstoneMode.DISABLED;
    private boolean isRedstonePowered;
    private int blockSearchX;
    private int blockSearchY;
    private int blockSearchZ;
    private final Map<class_2338, class_2350> chargeableBlocks = new LinkedHashMap<class_2338, class_2350>();
    public int renderingTickCount = 0;
    public float renderingRotationSpeed;
    public float renderingRotation;

    public ChargerBlockEntity(ChargerType type, class_2338 pos, class_2680 state) {
        super(type.getBlockEntityType(), pos, state);
        this.type = type;
    }

    public void update() {
        if (this.field_11863.field_9236) {
            ++this.renderingTickCount;
            if (!this.redstoneMode.canOperate(this.isRedstonePowered)) {
                this.renderingRotationSpeed = Math.max(0.0f, this.renderingRotationSpeed - 0.02f);
                this.renderingRotation += this.renderingRotationSpeed;
                return;
            }
            this.renderingRotationSpeed = Math.min(this.renderingRotationSpeed + 0.02f, this.getEnergyFillPercentage());
            this.renderingRotation += this.renderingRotationSpeed;
        } else {
            boolean spawnParticles = false;
            if (this.type.canChargeBlocks) {
                for (int i = 0; i < 5; ++i) {
                    class_2338 offset = new class_2338(this.blockSearchX, this.blockSearchY, this.blockSearchZ);
                    class_2338 class_23382 = this.field_11867.method_10081((class_2382)offset);
                    if (!class_23382.equals((Object)this.field_11867)) {
                        class_2586 entity = this.field_11863.method_8321(class_23382);
                        boolean canAcceptEnergy = false;
                        for (class_2350 direction : CAPABILITY_DIRECTIONS) {
                            EnergyStorage storage;
                            if (entity == null || entity instanceof ChargerBlockEntity || (storage = (EnergyStorage)EnergyStorage.SIDED.find(this.field_11863, class_23382, entity.method_11010(), entity, (Object)direction)) == null || !storage.supportsInsertion()) continue;
                            this.chargeableBlocks.put(offset, direction);
                            canAcceptEnergy = true;
                            break;
                        }
                        if (!canAcceptEnergy) {
                            this.chargeableBlocks.remove(offset);
                        }
                    }
                    int range = this.type.range.get();
                    ++this.blockSearchX;
                    if (this.blockSearchX <= range) continue;
                    this.blockSearchX = -range;
                    ++this.blockSearchZ;
                    if (this.blockSearchZ <= range) continue;
                    this.blockSearchZ = -range;
                    ++this.blockSearchY;
                    if (this.blockSearchY <= range) continue;
                    this.blockSearchY = -range;
                }
                if (this.energy > 0 && this.redstoneMode.canOperate(this.isRedstonePowered)) {
                    HashSet<class_2338> toRemove = new HashSet<class_2338>();
                    for (Map.Entry<Object, Object> entry : this.chargeableBlocks.entrySet()) {
                        EnergyStorage storage;
                        class_2586 tile = this.field_11863.method_8321(this.field_11867.method_10081((class_2382)entry.getKey()));
                        if (tile != null && (storage = (EnergyStorage)EnergyStorage.SIDED.find(this.field_11863, tile.method_11016(), tile.method_11010(), tile, (Object)((class_2350)entry.getValue()))) != null) {
                            Transaction transaction = Transaction.openOuter();
                            try {
                                int toTransfer = Math.min(this.energy, this.type.transferRate.get());
                                int transferred = (int)storage.insert((long)toTransfer, (TransactionContext)transaction);
                                if (transferred <= 0) continue;
                                spawnParticles = true;
                                this.energy -= transferred;
                                this.dataChanged();
                                transaction.commit();
                                if (this.energy > 0) continue;
                                break;
                            }
                            finally {
                                if (transaction != null) {
                                    transaction.close();
                                }
                                continue;
                            }
                        }
                        toRemove.add((class_2338)entry.getKey());
                    }
                    toRemove.forEach(this.chargeableBlocks::remove);
                }
            }
            if (this.type.canChargePlayers && this.energy > 0 && this.redstoneMode.canOperate(this.isRedstonePowered)) {
                List players = this.field_11863.method_18467(class_1657.class, this.getOperatingArea());
                block20: for (class_1657 class_16572 : players) {
                    Transaction transaction;
                    EnergyStorage storage;
                    Optional component;
                    int toTransfer = Math.min(this.energy, this.type.transferRate.get());
                    if (CommonUtils.isModLoaded((String)"trinkets") && (component = TrinketsApi.getTrinketComponent((class_1309)class_16572)).isPresent()) {
                        for (class_3545 slot : ((TrinketComponent)component.get()).getAllEquipped()) {
                            class_1799 stack = (class_1799)slot.method_15441();
                            if (stack.method_7960() || stack.method_7960() || (storage = (EnergyStorage)EnergyStorage.ITEM.find(stack, (Object)ContainerItemContext.ofSingleSlot((SingleSlotStorage)new TrinketsSlotStorage((SlotReference)slot.method_15442(), stack)))) == null) continue;
                            transaction = Transaction.openOuter();
                            try {
                                int transferred = (int)storage.insert((long)toTransfer, (TransactionContext)transaction);
                                if (transferred <= 0) continue;
                                spawnParticles = true;
                                this.energy -= transferred;
                                this.dataChanged();
                                transaction.commit();
                                if (this.energy <= 0) break block20;
                                if ((toTransfer -= transferred) > 0) continue;
                                continue block20;
                            }
                            finally {
                                if (transaction != null) {
                                    transaction.close();
                                }
                            }
                        }
                    }
                    class_1661 inventory = class_16572.method_31548();
                    PlayerInventoryStorage inventoryStorage = PlayerInventoryStorage.of((class_1657)class_16572);
                    for (int i = 0; i < inventory.method_5439(); ++i) {
                        class_1799 stack = inventory.method_5438(i);
                        if (stack.method_7960() || (storage = (EnergyStorage)EnergyStorage.ITEM.find(stack, (Object)ContainerItemContext.ofPlayerSlot((class_1657)class_16572, (SingleSlotStorage)inventoryStorage.getSlot(i)))) == null || !storage.supportsInsertion()) continue;
                        transaction = Transaction.openOuter();
                        try {
                            int max = toTransfer;
                            int transferred = (int)storage.insert((long)toTransfer, (TransactionContext)transaction);
                            if (transferred <= 0) continue;
                            spawnParticles = true;
                            this.energy -= transferred;
                            this.dataChanged();
                            transaction.commit();
                            if (this.energy <= 0) break block20;
                            if ((toTransfer -= transferred) > 0) continue;
                            continue block20;
                        }
                        finally {
                            if (transaction == null) continue block20;
                            transaction.close();
                            continue block20;
                        }
                    }
                }
            }
            if (spawnParticles && this.field_11863 instanceof class_3218 && this.field_11863.method_8409().method_43058() <= (double)this.getEnergyFillPercentage()) {
                double x = (double)this.field_11867.method_10263() + 0.5 + (double)this.field_11863.method_8409().method_43057() * 0.8 - 0.4;
                double d = (double)this.field_11867.method_10264() + 0.7 + (double)this.field_11863.method_8409().method_43057() * 0.8 - 0.4;
                double z = (double)this.field_11867.method_10260() + 0.5 + (double)this.field_11863.method_8409().method_43057() * 0.8 - 0.4;
                ((class_3218)this.field_11863).method_14199((class_2394)class_2390.field_11188, x, d, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public float getEnergyFillPercentage() {
        return Math.min(1.0f, Math.max(0.0f, (float)this.energy / (float)this.type.capacity.get().intValue()));
    }

    public class_238 getOperatingArea() {
        return new class_238(this.field_11867).method_1014((double)this.type.range.get().intValue());
    }

    public void setRedstonePowered(boolean powered) {
        if (this.isRedstonePowered != powered) {
            this.isRedstonePowered = powered;
            this.dataChanged();
        }
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    public void cycleRedstoneMode() {
        this.redstoneMode = RedstoneMode.fromIndex((this.redstoneMode.index + 1) % RedstoneMode.values().length);
        this.dataChanged();
    }

    public boolean isAreaHighlighted() {
        return this.highlightArea;
    }

    public void toggleHighlightArea() {
        this.highlightArea = !this.highlightArea;
        this.dataChanged();
    }

    protected class_2487 writeData() {
        class_2487 compound = new class_2487();
        compound.method_10569("energy", this.energy);
        compound.method_10556("highlightArea", this.highlightArea);
        compound.method_10569("redstoneMode", this.redstoneMode.index);
        compound.method_10556("isRedstonePowered", this.isRedstonePowered);
        if (this.type.canChargeBlocks) {
            compound.method_10569("blockSearchX", this.blockSearchX);
            compound.method_10569("blockSearchY", this.blockSearchX);
            compound.method_10569("blockSearchZ", this.blockSearchX);
            int[] arr = new int[this.chargeableBlocks.size() * 4];
            int index = 0;
            for (Map.Entry<class_2338, class_2350> entry : this.chargeableBlocks.entrySet()) {
                arr[index] = entry.getKey().method_10263();
                arr[index + 1] = entry.getKey().method_10264();
                arr[index + 2] = entry.getKey().method_10260();
                arr[index + 3] = entry.getValue() == null ? -1 : entry.getValue().method_10146();
                ++index;
            }
            compound.method_10539("chargeableBlocks", arr);
        }
        return compound;
    }

    public class_2487 writeItemStackData() {
        class_2487 compound = this.writeData();
        if (compound.method_10550("energy") <= 0 && compound.method_10550("redstoneMode") == 2) {
            return null;
        }
        compound.method_10551("highlightArea");
        compound.method_10551("isRedstonePowered");
        if (this.type.canChargeBlocks) {
            compound.method_10551("blockSearchX");
            compound.method_10551("blockSearchY");
            compound.method_10551("blockSearchZ");
            compound.method_10551("chargeableBlocks");
        }
        return compound;
    }

    protected void readData(class_2487 compound) {
        this.energy = compound.method_10550("energy");
        this.highlightArea = compound.method_10577("highlightArea");
        this.redstoneMode = RedstoneMode.fromIndex(compound.method_10550("redstoneMode"));
        this.isRedstonePowered = compound.method_10577("isRedstonePowered");
        if (this.type.canChargeBlocks && compound.method_10545("chargeableBlocks")) {
            this.blockSearchX = compound.method_10550("blockSearchX");
            this.blockSearchY = compound.method_10550("blockSearchY");
            this.blockSearchZ = compound.method_10550("blockSearchZ");
            int[] arr = compound.method_10561("chargeableBlocks");
            this.chargeableBlocks.clear();
            for (int i = 0; i < arr.length / 4; ++i) {
                this.chargeableBlocks.put(new class_2338(arr[i], arr[i + 1], arr[i + 2]), arr[i + 3] == -1 ? null : class_2350.method_10143((int)arr[i + 3]));
            }
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int received = Math.min(maxReceive, Math.min(this.type.capacity.get() - this.energy, this.type.transferRate.get() * 100));
        if (!simulate) {
            this.energy += received;
            this.dataChanged();
        }
        return received;
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return this.type.capacity.get();
    }

    public void setEnergyStored(int energy) {
        this.energy = energy;
    }

    public static enum RedstoneMode {
        HIGH(0),
        LOW(1),
        DISABLED(2);

        public final int index;

        private RedstoneMode(int index) {
            this.index = index;
        }

        public boolean canOperate(boolean isPowered) {
            return this == DISABLED || (isPowered ? this == HIGH : this == LOW);
        }

        public static RedstoneMode fromIndex(int index) {
            for (RedstoneMode mode : RedstoneMode.values()) {
                if (mode.index != index) continue;
                return mode;
            }
            return DISABLED;
        }
    }
}

