/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wirelesschargers;

import com.supermartijn642.core.util.Pair;
import dev.emi.trinkets.api.SlotReference;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1799;

public class TrinketsSlotStorage
extends SnapshotParticipant<Pair<ItemVariant, Integer>>
implements SingleSlotStorage<ItemVariant> {
    private final SlotReference slot;
    private ItemVariant item;
    private int count;

    public TrinketsSlotStorage(SlotReference slot, class_1799 stack) {
        this.slot = slot;
        this.item = ItemVariant.of((class_1799)stack);
        this.count = stack.method_7947();
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        if (maxAmount >= 1L && this.item.isBlank()) {
            this.updateSnapshots(transaction);
            this.item = resource;
            this.count = 1;
            return 1L;
        }
        return 0L;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        if (maxAmount >= 1L && this.count > 0 && this.item.equals(resource)) {
            this.updateSnapshots(transaction);
            --this.count;
            if (this.count == 0) {
                this.item = ItemVariant.blank();
            }
            return 1L;
        }
        return 0L;
    }

    public boolean isResourceBlank() {
        return this.item.isBlank();
    }

    public ItemVariant getResource() {
        return this.item;
    }

    public long getAmount() {
        return this.count;
    }

    public long getCapacity() {
        return 1L;
    }

    protected Pair<ItemVariant, Integer> createSnapshot() {
        return Pair.of((Object)this.item, (Object)this.count);
    }

    protected void readSnapshot(Pair<ItemVariant, Integer> snapshot) {
        this.item = (ItemVariant)snapshot.left();
        this.count = (Integer)snapshot.right();
    }

    protected void onFinalCommit() {
        this.slot.inventory().method_5447(this.slot.index(), this.item.toStack(this.count));
    }
}

