/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.stream.Stream;
import mcp.mobius.waila.command.ArgumentBuilderBuilder;
import mcp.mobius.waila.plugin.PluginInfo;
import net.minecraft.class_124;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_2960;

public abstract class CommonCommand<S, E extends Executor> {
    private final String root;

    protected CommonCommand(String root) {
        this.root = root;
    }

    protected abstract void register(ArgumentBuilderBuilder<S> var1);

    protected abstract LiteralArgumentBuilder<S> literal(String var1);

    protected abstract <T> RequiredArgumentBuilder<S, T> argument(String var1, ArgumentType<T> var2);

    protected abstract void success(S var1, Supplier<class_2561> var2);

    protected abstract void fail(S var1, class_2561 var2);

    protected abstract E getExecutor(S var1);

    protected abstract void reloadPlugins(E var1);

    protected abstract boolean pluginCommandRequirement(S var1);

    protected boolean isPluginDisabledOnServer(PluginInfo plugin) {
        return false;
    }

    public final void register(CommandDispatcher<S> dispatcher) {
        new ArgumentBuilderBuilder<S>(this.literal(this.root)).then((ArgumentBuilder<S, ?>)this.literal("plugin")).requires(this::pluginCommandRequirement).then((ArgumentBuilder<Object, ?>)this.literal("list")).executes((Command<Object>)((Command)context -> {
            Object source = context.getSource();
            return this.listPlugins(source, true) + this.listPlugins(source, false);
        })).then((ArgumentBuilder<Object, ?>)this.literal("enabled")).executes((Command<Object>)((Command)context -> this.listPlugins(context.getSource(), true))).pop("enabled").then((ArgumentBuilder<Object, ?>)this.literal("available")).executes((Command<Object>)((Command)context -> this.listPlugins(context.getSource(), false))).pop("available").pop("list").then((ArgumentBuilder<Object, ?>)this.literal("enable")).then((ArgumentBuilder<Object, ?>)this.argument("name", (ArgumentType)class_2232.method_9441())).suggests(this.suggestPlugins(false)).executes((Command<Object>)((Command)context -> this.modifyPlugin(context, true))).pop("name", "enable").then((ArgumentBuilder<Object, ?>)this.literal("disable")).then((ArgumentBuilder<Object, ?>)this.argument("name", (ArgumentType)class_2232.method_9441())).suggests(this.suggestPlugins(true)).executes((Command<Object>)((Command)context -> this.modifyPlugin(context, false))).pop("name", "disable").then((ArgumentBuilder<Object, ?>)this.literal("reload")).executes((Command<Object>)((Command)context -> {
            Object source = context.getSource();
            E executor = this.getExecutor(source);
            executor.execute(() -> this.reloadPlugins(executor));
            this.success(source, () -> class_2561.method_43471((String)"command.waila.plugin.reload"));
            return 1;
        })).pop("reload").pop("plugin").then(this::register).register(dispatcher);
    }

    private Stream<PluginInfo> getPlugins(boolean enabled) {
        return PluginInfo.getAll().stream().filter(it -> enabled == it.isEnabled());
    }

    private int listPlugins(S source, boolean enabled) {
        List<PluginInfo> plugins = this.getPlugins(enabled).toList();
        if (plugins.isEmpty()) {
            this.success(source, () -> class_2561.method_43471((String)(enabled ? "command.waila.plugin.list.enabled.none" : "command.waila.plugin.list.available.none")));
        } else {
            this.success(source, () -> class_2561.method_43469((String)(enabled ? "command.waila.plugin.list.enabled.success" : "command.waila.plugin.list.available.success"), (Object[])new Object[]{plugins.size(), class_2564.method_10884((Collection)plugins, p -> class_2564.method_10885((class_2561)class_2561.method_43470((String)p.getPluginId().toString())).method_27694(s -> s.method_10977(enabled ? class_124.field_1060 : class_124.field_1061).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43473().method_27693(p.getModInfo().getName())))))}));
        }
        return plugins.size();
    }

    private SuggestionProvider<S> suggestPlugins(boolean enabled) {
        return (context, builder) -> class_2172.method_9257(this.getPlugins(enabled).filter(it -> !it.isLocked() && !this.isPluginDisabledOnServer((PluginInfo)it)).map(PluginInfo::getPluginId), (SuggestionsBuilder)builder);
    }

    private int modifyPlugin(CommandContext<S> context, boolean enable) {
        Object source = context.getSource();
        E executor = this.getExecutor(source);
        class_2960 id = (class_2960)context.getArgument("name", class_2960.class);
        String name = id.toString();
        PluginInfo plugin = PluginInfo.get(id);
        if (plugin == null) {
            this.fail(source, (class_2561)class_2561.method_43469((String)"command.waila.plugin.unknown", (Object[])new Object[]{name}));
            return 0;
        }
        if (plugin.isLocked()) {
            this.fail(source, (class_2561)class_2561.method_43469((String)"command.waila.plugin.locked", (Object[])new Object[]{name}));
            return 0;
        }
        if (this.isPluginDisabledOnServer(plugin)) {
            this.fail(source, (class_2561)class_2561.method_43469((String)"command.waila.plugin.disabled_on_server", (Object[])new Object[]{name}));
            return 0;
        }
        executor.execute(() -> {
            plugin.setEnabled(enable);
            this.reloadPlugins(executor);
        });
        this.success(source, () -> class_2561.method_43469((String)(enable ? "command.waila.plugin.modify.enable" : "command.waila.plugin.modify.disable"), (Object[])new Object[]{name}));
        return 1;
    }
}

