/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.IllegalFormatException;
import java.util.Random;
import mcp.mobius.waila.WailaClient;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.WailaHelper;
import mcp.mobius.waila.util.ExceptionUtil;
import net.minecraft.class_1159;
import net.minecraft.class_1799;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_757;

public final class DisplayUtil
extends class_332 {
    private static final Random RANDOM = new Random();
    private static final class_310 CLIENT = class_310.method_1551();

    public static void renderStack(int x, int y, class_1799 stack) {
        DisplayUtil.renderStack(x, y, stack, stack.method_7947() > 1 ? WailaHelper.suffix(stack.method_7947()) : "");
    }

    public static void renderStack(int x, int y, class_1799 stack, String countText) {
        DisplayUtil.enable3DRender();
        try {
            CLIENT.method_1480().method_4010(stack, x, y);
            CLIENT.method_1480().method_4022(DisplayUtil.CLIENT.field_1772, stack, x, y, countText);
        }
        catch (Exception e) {
            String stackStr = stack != null ? stack.toString() : "NullStack";
            ExceptionUtil.dump(e, "renderStack | " + stackStr, null);
        }
        DisplayUtil.enable2DRender();
    }

    public static void enable3DRender() {
        class_308.method_24211();
        RenderSystem.enableDepthTest();
    }

    public static void enable2DRender() {
        class_308.method_24210();
        RenderSystem.disableDepthTest();
    }

    public static void renderRectBorder(class_1159 matrix, class_287 buf, int x, int y, int w, int h, int s, int gradStart, int gradEnd) {
        if (s <= 0) {
            return;
        }
        DisplayUtil.fillGradient(matrix, buf, x, y, w, s, gradStart, gradStart);
        DisplayUtil.fillGradient(matrix, buf, x, y + h - s, w, s, gradEnd, gradEnd);
        DisplayUtil.fillGradient(matrix, buf, x, y + s, s, h - s * 2, gradStart, gradEnd);
        DisplayUtil.fillGradient(matrix, buf, x + w - s, y + s, s, h - s * 2, gradStart, gradEnd);
    }

    public static void renderComponent(class_4587 matrices, ITooltipComponent component, int x, int y, int cw, float delta) {
        component.render(matrices, x, y, delta);
        if (WailaClient.showComponentBounds) {
            matrices.method_22903();
            float scale = (float)class_310.method_1551().method_22683().method_4495();
            matrices.method_22905(1.0f / scale, 1.0f / scale, 1.0f);
            RenderSystem.disableTexture();
            RenderSystem.setShader(class_757::method_34540);
            class_289 tesselator = class_289.method_1348();
            class_287 buf = tesselator.method_1349();
            buf.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
            int bx = class_3532.method_15357((double)((double)((float)x * scale) + 0.5));
            int by = class_3532.method_15357((double)((double)((float)y * scale) + 0.5));
            int bw = class_3532.method_15357((double)((double)((float)(cw == 0 ? component.getWidth() : cw) * scale) + 0.5));
            int bh = class_3532.method_15357((double)((double)((float)component.getHeight() * scale) + 0.5));
            int color = -16777216 + class_3532.method_15369((float)RANDOM.nextFloat(), (float)RANDOM.nextFloat(), (float)1.0f);
            DisplayUtil.renderRectBorder(matrices.method_23760().method_23761(), buf, bx, by, bw, bh, 1, color, color);
            tesselator.method_1350();
            RenderSystem.enableTexture();
            matrices.method_22909();
        }
    }

    public static void fillGradient(class_1159 matrix, class_287 buf, int x, int y, int w, int h, int start, int end) {
        DisplayUtil.method_27533((class_1159)matrix, (class_287)buf, (int)x, (int)y, (int)(x + w), (int)(y + h), (int)0, (int)start, (int)end);
    }

    public static int getAlphaFromPercentage(int percentage) {
        return percentage == 100 ? -16777216 : (percentage == 0 ? 0x1000000 : (int)((float)percentage / 100.0f * 256.0f) << 24);
    }

    public static String tryFormat(String format, Object ... args) {
        try {
            return format.formatted(args);
        }
        catch (IllegalFormatException e) {
            return "FORMATTING ERROR";
        }
    }
}

