/*
 * Decompiled with CFR 0.152.
 */
package com.notker.xp_storage.blocks;

import com.notker.xp_storage.XpFunctions;
import com.notker.xp_storage.XpStorage;
import com.notker.xp_storage.blocks.StorageBlockEntity;
import com.notker.xp_storage.items.Xp_removerItem;
import com.notker.xp_storage.regestry.ModBlocks;
import com.notker.xp_storage.regestry.ModFluids;
import com.notker.xp_storage.regestry.ModItems;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class StorageBlock
extends class_2237
implements class_2343,
class_3737 {
    public static final class_2746 CHARGED = class_2746.method_11825((String)"charged");

    public StorageBlock(class_4970.class_2251 settings) {
        super(settings.method_22488());
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11043)).method_11657((class_2769)CHARGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false)));
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        boolean bl;
        class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
        boolean bl2 = bl = fluidState.method_15772() == class_3612.field_15910;
        if (Objects.requireNonNull(ctx.method_8036()).method_5715()) {
            return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)ctx.method_8042())).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(bl));
        }
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)ctx.method_8042().method_10153())).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(bl));
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)class_2741.field_12508) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public boolean method_10311(class_1936 world, class_2338 pos, class_2680 state, class_3610 fluidState) {
        if (!((Boolean)state.method_11654((class_2769)class_2741.field_12508)).booleanValue() && fluidState.method_15772() == class_3612.field_15910) {
            class_2680 blockState = (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true));
            world.method_8652(pos, blockState, 3);
            world.method_39281(pos, fluidState.method_15772(), fluidState.method_15772().method_15789((class_4538)world));
            return true;
        }
        return false;
    }

    public class_265 method_9530(class_2680 state, class_1922 view, class_2338 pos, class_3726 ctx) {
        class_265 bottom = class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
        class_265 top = class_2248.method_9541((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
        return class_259.method_1084((class_265)bottom, (class_265)top);
    }

    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        StorageBlockEntity tile = (StorageBlockEntity)world.method_8321(pos);
        if (tile == null) {
            return;
        }
        class_1799 drop = new class_1799((class_1935)this.method_8389());
        if (tile.liquidXp.amount > 0L || !tile.player_uuid.equals(class_156.field_25140)) {
            class_2487 stackTag = new class_2487();
            stackTag.method_10566("BlockEntityTag", (class_2520)tile.getNbtData());
            drop.method_7980(stackTag);
        }
        StorageBlock.method_9577((class_1937)world, (class_2338)pos, (class_1799)drop);
        super.method_9576(world, pos, state, player);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateManager) {
        stateManager.method_11667(new class_2769[]{class_2741.field_12481});
        stateManager.method_11667(new class_2769[]{CHARGED});
        stateManager.method_11667(new class_2769[]{class_2741.field_12508});
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        StorageBlockEntity tile = (StorageBlockEntity)world.method_8321(pos);
        if (tile == null) {
            return;
        }
        if (tile.liquidXp.amount != 0L) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)CHARGED, (Comparable)Boolean.valueOf(true)));
        }
        super.method_9567(world, pos, state, placer, itemStack);
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        super.method_9496(state, world, pos, random);
        StorageBlockEntity tile = (StorageBlockEntity)world.method_8321(pos);
        if (tile != null && tile.vacuum) {
            double targetX = (double)pos.method_10263() + 0.5;
            double targetY = (double)pos.method_10264() + 0.5;
            double targetZ = (double)pos.method_10260() + 0.5;
            double offsetX = 1.0 - (double)random.method_43048(3);
            double offsetZ = 1.0 - (double)random.method_43048(3);
            world.method_8406((class_2394)class_2398.field_11214, targetX, targetY, targetZ, offsetX, 0.1, offsetZ);
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!world.field_9236) {
            boolean isSurvival;
            StorageBlockEntity tile = (StorageBlockEntity)world.method_8321(pos);
            if (tile == null) {
                return class_1269.field_5814;
            }
            class_1799 mainHand = player.method_5998(class_1268.field_5808);
            int itemCountInHand = player.method_5998(hand).method_7947();
            boolean tileIsLocked = !tile.player_uuid.equals(class_156.field_25140);
            boolean isTileOwner = tile.player_uuid.equals(player.method_5667());
            boolean bl = isSurvival = !player.method_7337() && !player.method_7325();
            if (mainHand.method_31574((class_1792)ModItems.INSPECTOR)) {
                return this.displayContainerInfo(world, pos, player, tile);
            }
            if (tileIsLocked && !isTileOwner && !player.method_7337()) {
                return this.containerAccessDenied(world, pos, player);
            }
            if (mainHand.method_31574((class_1792)ModItems.KEY) && (isTileOwner || player.method_7337())) {
                return this.unlockContainer(world, pos, player, hand, isSurvival, itemCountInHand, tile);
            }
            if (mainHand.method_31574(class_1802.field_8530)) {
                return this.toggleVacuum(world, pos, tile);
            }
            if (mainHand.method_31574((class_1792)ModItems.XP_BERRIES)) {
                return this.insertXpBerries(itemCountInHand, world, pos, player, hand, tile);
            }
            if (mainHand.method_31574(class_1802.field_37523)) {
                return this.insertSculkBlock(itemCountInHand, world, pos, player, hand, tile);
            }
            if (mainHand.method_31574((class_1792)ModItems.LOCK)) {
                if (tileIsLocked) {
                    return this.containerIsAlreadyLocked(world, pos, player);
                }
                return this.lockContainer(world, pos, player, hand, itemCountInHand, tile);
            }
            if (mainHand.method_31574((class_1792)ModItems.XP_REMOVER)) {
                class_1799 stack = player.method_5998(hand);
                if (stack.method_7985() && Objects.requireNonNull(stack.method_7969()).method_10577(Xp_removerItem.tagId)) {
                    return this.containerXpToPlayer(itemCountInHand, world, pos, player, tile);
                }
                return this.playerXpToContainer(itemCountInHand, world, pos, player, tile);
            }
            if (mainHand.method_31574(class_1802.field_8469)) {
                return this.fillGlassBottle(world, pos, player, hand, tile);
            }
            if (mainHand.method_31574(class_1802.field_8287)) {
                return this.insertBottleXP(itemCountInHand, world, pos, player, hand, tile);
            }
            if (mainHand.method_31574(class_1802.field_8550)) {
                return this.fillBucketOnContainer(world, pos, player, hand, tile);
            }
            if (mainHand.method_31574(ModFluids.XP_BUCKET)) {
                return this.emptyBucketOnContainer(world, pos, player, hand, tile);
            }
            if (mainHand.method_7986() && class_1890.method_8225((class_1887)class_1893.field_9101, (class_1799)mainHand) > 0) {
                return this.repairItem(world, pos, tile, mainHand);
            }
        }
        return class_1269.field_21466;
    }

    private class_1269 repairItem(class_1937 world, class_2338 pos, StorageBlockEntity tile, class_1799 mainHand) {
        if (tile.getContainerExperience() > 0) {
            tile.isAuthPlayer = true;
            try (Transaction transaction = Transaction.openOuter();){
                int xpCostToRepair = mainHand.method_7919() / 2;
                if (tile.getContainerExperience() >= xpCostToRepair) {
                    mainHand.method_7974(0);
                } else {
                    int maxDamageWithXp = tile.getContainerExperience() * 2;
                    xpCostToRepair = tile.getContainerExperience();
                    mainHand.method_7974(mainHand.method_7919() - maxDamageWithXp);
                }
                tile.liquidXp.extract((TransferVariant)FluidVariant.of((class_3611)ModFluids.LIQUID_XP), (long)xpCostToRepair * XpStorage.MB_PER_XP, (TransactionContext)transaction);
                world.method_8396(null, pos, class_3417.field_19199, class_3419.field_15245, 1.0f, 1.0f);
                transaction.commit();
            }
            tile.isAuthPlayer = false;
        }
        return class_1269.field_5812;
    }

    private class_1269 toggleVacuum(class_1937 world, class_2338 pos, StorageBlockEntity tile) {
        tile.toggleVacuum();
        world.method_8396(null, pos, class_3417.field_14962, class_3419.field_15245, 1.0f, 1.0f);
        return class_1269.field_5812;
    }

    private class_1269 containerIsAlreadyLocked(class_1937 world, class_2338 pos, class_1657 player) {
        player.method_7353((class_2561)class_2561.method_43471((String)"text.storageBlock.isLocked"), true);
        world.method_8396(null, pos, class_3417.field_28081, class_3419.field_15245, 1.0f, 1.0f);
        return class_1269.field_5812;
    }

    private class_1269 containerAccessDenied(class_1937 world, class_2338 pos, class_1657 player) {
        player.method_7353((class_2561)class_2561.method_43471((String)"text.storageBlock.denied"), true);
        world.method_8396(null, pos, class_3417.field_28081, class_3419.field_15245, 1.0f, 1.0f);
        return class_1269.field_5812;
    }

    private class_1269 emptyBucketOnContainer(class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, StorageBlockEntity tile) {
        try (Transaction transaction = Transaction.openOuter();){
            tile.liquidXp.insert((TransferVariant)FluidVariant.of((class_3611)ModFluids.LIQUID_XP), 81000L, (TransactionContext)transaction);
            player.method_5998(hand).method_7939(0);
            player.method_31548().method_7398(new class_1799((class_1935)class_1802.field_8550));
            world.method_8396(null, pos, class_3417.field_14834, class_3419.field_15245, 1.0f, 1.0f);
            transaction.commit();
        }
        return class_1269.field_5812;
    }

    private class_1269 fillBucketOnContainer(class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, StorageBlockEntity tile) {
        if (tile.liquidXp.amount >= 81000L) {
            tile.isAuthPlayer = true;
            try (Transaction transaction = Transaction.openOuter();){
                tile.liquidXp.extract((TransferVariant)FluidVariant.of((class_3611)ModFluids.LIQUID_XP), 81000L, (TransactionContext)transaction);
                player.method_5998(hand).method_7934(1);
                player.method_31548().method_7398(new class_1799((class_1935)ModFluids.XP_BUCKET));
                world.method_8396(null, pos, class_3417.field_15126, class_3419.field_15245, 1.0f, 1.0f);
                transaction.commit();
            }
            tile.isAuthPlayer = false;
        }
        return class_1269.field_5812;
    }

    private class_1269 fillGlassBottle(class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, StorageBlockEntity tile) {
        if (tile.liquidXp.amount >= 27000L) {
            tile.isAuthPlayer = true;
            try (Transaction transaction = Transaction.openOuter();){
                tile.liquidXp.extract((TransferVariant)FluidVariant.of((class_3611)ModFluids.LIQUID_XP), 27000L, (TransactionContext)transaction);
                class_1799 fullBottle = new class_1799((class_1935)class_1802.field_8287);
                fullBottle.method_7939(1);
                world.method_8396(null, pos, class_3417.field_14978, class_3419.field_15245, 0.125f, 1.0f);
                player.method_5998(hand).method_7934(1);
                player.method_31548().method_7398(fullBottle);
                transaction.commit();
            }
            tile.isAuthPlayer = false;
        }
        return class_1269.field_5812;
    }

    private class_1269 insertXpBerries(int itemCount, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, StorageBlockEntity tile) {
        try (Transaction transaction = Transaction.openOuter();){
            tile.liquidXp.insert((TransferVariant)FluidVariant.of((class_3611)ModFluids.LIQUID_XP), (long)itemCount * XpStorage.MB_PER_BERRIE, (TransactionContext)transaction);
            world.method_8396(null, pos, class_3417.field_17617, class_3419.field_15245, 1.0f, 1.0f);
            player.method_5998(hand).method_7939(0);
            transaction.commit();
        }
        return class_1269.field_5812;
    }

    private class_1269 insertSculkBlock(int itemCount, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, StorageBlockEntity tile) {
        try (Transaction transaction = Transaction.openOuter();){
            tile.liquidXp.insert((TransferVariant)FluidVariant.of((class_3611)ModFluids.LIQUID_XP), (long)itemCount * XpStorage.MB_PER_XP, (TransactionContext)transaction);
            world.method_8396(null, pos, class_3417.field_37359, class_3419.field_15245, 1.0f, 1.0f);
            player.method_5998(hand).method_7939(0);
            transaction.commit();
        }
        return class_1269.field_5812;
    }

    private class_1269 insertBottleXP(int itemCount, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, StorageBlockEntity tile) {
        class_1799 emptyBottles = new class_1799((class_1935)class_1802.field_8469);
        emptyBottles.method_7939(itemCount);
        long xpToInsert = 27000L * (long)itemCount;
        try (Transaction transaction = Transaction.openOuter();){
            tile.liquidXp.insert((TransferVariant)FluidVariant.of((class_3611)ModFluids.LIQUID_XP), xpToInsert, (TransactionContext)transaction);
            world.method_8396(null, pos, class_3417.field_14978, class_3419.field_15245, 1.0f, 1.0f);
            player.method_5998(hand).method_7939(0);
            StorageBlock.method_36992((class_1937)world, (class_2338)pos, (class_2350)player.method_5735().method_10153(), (class_1799)emptyBottles);
            transaction.commit();
        }
        return class_1269.field_5812;
    }

    private class_1269 containerXpToPlayer(int itemCount, class_1937 world, class_2338 pos, class_1657 player, StorageBlockEntity tile) {
        if (tile.liquidXp.amount > 0L) {
            for (int i = 0; i < itemCount; ++i) {
                tile.isAuthPlayer = true;
                int xpToNextLevel = XpFunctions.exp_to_reach_next_lvl(player.method_7349(), player.field_7510);
                int storageXP = tile.getContainerExperience();
                if (storageXP == 0) break;
                try (Transaction transaction = Transaction.openOuter();){
                    if (storageXP >= xpToNextLevel) {
                        tile.liquidXp.extract((TransferVariant)FluidVariant.of((class_3611)ModFluids.LIQUID_XP), (long)xpToNextLevel * XpStorage.MB_PER_XP, (TransactionContext)transaction);
                        player.method_7255(xpToNextLevel);
                    } else {
                        tile.liquidXp.extract((TransferVariant)FluidVariant.of((class_3611)ModFluids.LIQUID_XP), tile.liquidXp.amount, (TransactionContext)transaction);
                        player.method_7255(storageXP);
                    }
                    transaction.commit();
                }
                tile.method_5431();
                tile.method_38235();
            }
            world.method_8396(null, pos, class_3417.field_23117, class_3419.field_15245, 0.125f, 1.0f);
        }
        tile.isAuthPlayer = false;
        return class_1269.field_5812;
    }

    private class_1269 playerXpToContainer(int itemCount, class_1937 world, class_2338 pos, class_1657 player, StorageBlockEntity tile) {
        if (XpFunctions.get_total_xp(player.field_7520, player.method_7349(), player.field_7510) > 0) {
            int xpToInsert = 0;
            for (int i = 0; i < itemCount; ++i) {
                int totalPlayerXp = XpFunctions.get_total_xp(player.field_7520, player.method_7349(), player.field_7510);
                int xpExchange = XpFunctions.xp_value_from_bar(player.method_7349(), player.field_7510);
                if (xpExchange == 0) {
                    xpExchange = XpFunctions.getToNextLowerExperienceLevel(player.field_7520);
                    player.field_7510 = 0.0f;
                }
                if (totalPlayerXp >= xpExchange) {
                    player.method_7255(-xpExchange);
                    xpToInsert += xpExchange;
                    continue;
                }
                player.method_7255(-totalPlayerXp);
                xpToInsert += totalPlayerXp;
            }
            try (Transaction transaction = Transaction.openOuter();){
                tile.liquidXp.insert((TransferVariant)FluidVariant.of((class_3611)ModFluids.LIQUID_XP), (long)xpToInsert * XpStorage.MB_PER_XP, (TransactionContext)transaction);
                transaction.commit();
            }
            world.method_8396(null, pos, class_3417.field_23116, class_3419.field_15245, 0.125f, 1.0f);
        }
        return class_1269.field_5812;
    }

    private class_1269 unlockContainer(class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, boolean isSurvival, int itemCountInHand, StorageBlockEntity tile) {
        tile.setUuidAndNameTo();
        player.method_7353((class_2561)class_2561.method_43471((String)"text.storageBlock.isOpen"), true);
        world.method_8396(null, pos, class_3417.field_22463, class_3419.field_15245, 1.0f, 1.0f);
        if (isSurvival) {
            player.method_5998(hand).method_7939(itemCountInHand > 1 ? itemCountInHand - 1 : 0);
        }
        return class_1269.field_5812;
    }

    private class_1269 lockContainer(class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, int itemCountInHand, StorageBlockEntity tile) {
        tile.setUuidAndNameTo(player.method_5667(), player.method_5477());
        player.method_7353((class_2561)class_2561.method_43471((String)"text.storageBlock.locked"), true);
        world.method_8396(null, pos, class_3417.field_22463, class_3419.field_15245, 1.0f, 1.0f);
        player.method_5998(hand).method_7939(itemCountInHand > 1 ? itemCountInHand - 1 : 0);
        return class_1269.field_5812;
    }

    private class_1269 displayContainerInfo(class_1937 world, class_2338 pos, class_1657 player, StorageBlockEntity tile) {
        int totalXp = XpFunctions.get_total_xp(player.field_7520, player.method_7349(), player.field_7510);
        UUID noUUid = class_156.field_25140;
        if (!tile.player_uuid.equals(noUUid)) {
            player.method_7353((class_2561)class_2561.method_43469((String)"item.tooltip.owner", (Object[])new Object[]{tile.playerName.toString()}), false);
            player.method_7353((class_2561)class_2561.method_43471((String)("UUid: " + tile.player_uuid)), false);
        } else {
            player.method_7353((class_2561)class_2561.method_43471((String)"item.debug_info.xp.container_no_owner"), false);
        }
        String xp = String.format(Locale.GERMAN, "%,d", tile.getContainerExperience());
        String playerXp = String.format(Locale.GERMAN, "%,d", totalXp);
        player.method_7353((class_2561)class_2561.method_43469((String)"item.debug_info.xp.container_info", (Object[])new Object[]{xp, Integer.MAX_VALUE}), false);
        player.method_7353((class_2561)class_2561.method_43469((String)"item.debug_info.xp.container_fill", (Object[])new Object[]{tile.getContainerFillPercentage()}), false);
        player.method_7353((class_2561)class_2561.method_43469((String)"item.debug_info.xp.player_info", (Object[])new Object[]{playerXp}), false);
        if (tile.vacuum) {
            player.method_7353((class_2561)class_2561.method_43471((String)"text.storageBlock.vacuum"), false);
        }
        world.method_8396(null, pos, class_3417.field_17482, class_3419.field_15245, 0.5f, 1.0f);
        return class_1269.field_5812;
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new StorageBlockEntity(pos, state);
    }

    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return StorageBlock.method_31618(type, ModBlocks.STORAGE_BLOCK_ENTITY, StorageBlockEntity::tick);
    }
}

