/*
 * Decompiled with CFR 0.152.
 */
package com.notker.xp_storage.blocks;

import com.notker.xp_storage.XpStorage;
import com.notker.xp_storage.blocks.StorageBlock;
import com.notker.xp_storage.regestry.ModBlocks;
import com.notker.xp_storage.regestry.ModFluids;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1301;
import net.minecraft.class_1303;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3611;
import org.jetbrains.annotations.Nullable;

public class StorageBlockEntity
extends class_2586 {
    public UUID player_uuid = class_156.field_25140;
    public class_2561 playerName = class_2561.method_30163((String)"");
    public boolean vacuum = false;
    public boolean isAuthPlayer = false;
    public final SingleVariantStorage<FluidVariant> liquidXp = new SingleVariantStorage<FluidVariant>(){

        protected FluidVariant getBlankVariant() {
            return FluidVariant.blank();
        }

        protected long getCapacity(FluidVariant variant) {
            return 173946175407000L;
        }

        public long insert(FluidVariant insertedVariant, long maxAmount, TransactionContext transaction) {
            StoragePreconditions.notBlankNotNegative((TransferVariant)insertedVariant, (long)maxAmount);
            if (this.canInsert(insertedVariant)) {
                long insertedAmount = Math.min(maxAmount, this.getCapacity(insertedVariant) - this.amount);
                if (insertedAmount > 0L) {
                    this.updateSnapshots(transaction);
                    if (((FluidVariant)this.variant).isBlank()) {
                        this.variant = FluidVariant.of((class_3611)ModFluids.LIQUID_XP);
                        this.amount = insertedAmount;
                    } else {
                        this.amount += insertedAmount;
                    }
                }
                return insertedAmount;
            }
            return 0L;
        }

        protected boolean canInsert(FluidVariant variant) {
            String variant_name = variant.getFluid().method_15785().method_15759().toString();
            return variant_name.contains("liquid_xp") || variant_name.contains("xp_fluid");
        }

        protected boolean canExtract(FluidVariant variant) {
            String variant_name = variant.getFluid().method_15785().method_15759().toString();
            boolean isUnlocked = StorageBlockEntity.this.player_uuid.equals(class_156.field_25140) || StorageBlockEntity.this.isAuthPlayer;
            return isUnlocked && (variant_name.contains("liquid_xp") || variant_name.contains("xp_fluid"));
        }

        protected void onFinalCommit() {
            if (StorageBlockEntity.this.field_11863 != null) {
                StorageBlockEntity.this.field_11863.method_8501(StorageBlockEntity.this.field_11867, (class_2680)StorageBlockEntity.this.method_11010().method_11657((class_2769)StorageBlock.CHARGED, (Comparable)Boolean.valueOf(StorageBlockEntity.this.liquidXp.amount != 0L)));
            }
            StorageBlockEntity.this.isAuthPlayer = false;
            StorageBlockEntity.this.method_5431();
            StorageBlockEntity.this.method_38235();
        }
    };

    public StorageBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlocks.STORAGE_BLOCK_ENTITY, pos, state);
    }

    public void setUuidAndNameTo() {
        this.setUuidAndNameTo(class_156.field_25140, class_2561.method_30163((String)""));
    }

    public void setUuidAndNameTo(UUID id, class_2561 name) {
        this.player_uuid = id;
        this.playerName = name;
        this.method_5431();
        this.method_38235();
    }

    public String getContainerFillPercentage() {
        float container_progress = (float)(100.0 / (double)this.liquidXp.getCapacity() * (double)this.liquidXp.amount);
        return String.format(Locale.US, "%.7f", Float.valueOf(container_progress)) + "%";
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10566("fluidVariant", (class_2520)((FluidVariant)this.liquidXp.variant).toNbt());
        tag.method_10544("amount", this.liquidXp.amount);
        tag.method_25927("player_uuid", this.player_uuid);
        tag.method_10582("playerName", this.playerName.toString());
        tag.method_10556("vacuum", this.vacuum);
        StorageBlockEntity.method_38238((class_2487)tag, ModBlocks.STORAGE_BLOCK_ENTITY);
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        if (tag.method_10545("containerExperience")) {
            this.liquidXp.amount = (long)tag.method_10550("containerExperience") * XpStorage.MB_PER_XP;
            this.liquidXp.variant = FluidVariant.of((class_3611)ModFluids.LIQUID_XP);
        } else {
            this.liquidXp.variant = FluidVariant.fromNbt((class_2487)tag.method_10562("fluidVariant"));
            this.liquidXp.amount = tag.method_10537("amount");
        }
        this.player_uuid = tag.method_25926("player_uuid");
        this.playerName = class_2561.method_30163((String)tag.method_10558("playerName"));
        this.vacuum = tag.method_10577("vacuum");
    }

    public class_2487 getNbtData() {
        class_2487 stackTag = new class_2487();
        stackTag.method_25927("player_uuid", this.player_uuid);
        stackTag.method_10582("playerName", this.playerName.toString());
        stackTag.method_10566("fluidVariant", (class_2520)((FluidVariant)this.liquidXp.variant).toNbt());
        stackTag.method_10544("amount", this.liquidXp.amount);
        StorageBlockEntity.method_38238((class_2487)stackTag, ModBlocks.STORAGE_BLOCK_ENTITY);
        stackTag.method_10556("vacuum", this.vacuum);
        return stackTag;
    }

    public void toggleVacuum() {
        this.vacuum = !this.vacuum;
        this.method_38235();
    }

    public int getContainerExperience() {
        return (int)(this.liquidXp.amount / XpStorage.MB_PER_XP);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, StorageBlockEntity sbe) {
        if (sbe.vacuum && world != null) {
            class_243 center = new class_243((double)pos.method_10263(), (double)pos.method_10264() + 2.5, (double)pos.method_10260());
            List validEntitys = world.method_8390(class_1303.class, class_238.method_30048((class_243)center, (double)9.0, (double)5.0, (double)9.0), class_1301.field_6154);
            validEntitys.forEach(experienceOrbEntity -> {
                int xp = experienceOrbEntity.method_5919();
                if (xp > 0) {
                    try (Transaction transaction = Transaction.openOuter();){
                        sbe.liquidXp.insert((TransferVariant)FluidVariant.of((class_3611)ModFluids.LIQUID_XP), (long)xp * XpStorage.MB_PER_XP, (TransactionContext)transaction);
                        transaction.commit();
                    }
                }
                experienceOrbEntity.method_31472();
            });
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)StorageBlock.CHARGED, (Comparable)Boolean.valueOf(sbe.liquidXp.amount != 0L)));
        }
    }
}

