/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.client.gui;

import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.core.PacketIdentifiers;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1068;
import net.minecraft.class_1071;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.lwjgl.glfw.GLFW;

public class PlayerSelectScreen
extends class_437 {
    private final class_2960 GRAVE_SELECT_TEXTURE = new class_2960("yigd", "textures/gui/select_player_menu.png");
    private final class_2960 SELECT_ELEMENT_TEXTURE = new class_2960("yigd", "textures/gui/select_elements.png");
    private final Map<UUID, class_2960> playerSkinTextures;
    private final Map<UUID, GameProfile> graveOwners;
    private final Map<UUID, List<Byte>> graveAvailabilities;
    private final int page;
    private final Map<UUID, Integer> filteredPlayers = new HashMap<UUID, Integer>();
    private final List<UUID> filteredPlayerIds = new ArrayList<UUID>();
    private boolean mouseIsClicked = false;
    private String hoveredElement = null;
    private final StringBuilder searchField;
    private boolean isTyping = false;
    private boolean includeAvailable;
    private boolean includeClaimed;
    private boolean includeDestroyed;
    private boolean showWithoutGrave;
    private final YigdConfig.GuiTextColors textColors;

    public PlayerSelectScreen(Collection<GameProfile> players, Map<UUID, List<Byte>> graveAvailabilities, int page) {
        this(players, graveAvailabilities, page, null, true, false, false, false);
    }

    public PlayerSelectScreen(Collection<GameProfile> players, Map<UUID, List<Byte>> graveAvailabilities, int page, StringBuilder search, boolean includeAvailable, boolean includeClaimed, boolean includeDestroyed, boolean showWithoutGrave) {
        super((class_2561)class_2561.method_43471((String)"text.yigd.gui.player_select.title"));
        HashMap<UUID, class_2960> playerSkinTextures = new HashMap<UUID, class_2960>();
        HashMap<UUID, GameProfile> graveOwners = new HashMap<UUID, GameProfile>();
        class_310 client = class_310.method_1551();
        for (GameProfile profile : players) {
            class_1071 skinProvider;
            Map map;
            UUID uuid = profile.getId();
            graveOwners.put(uuid, profile);
            class_2960 defaultSkin = class_1068.method_4648((UUID)uuid);
            if (client != null && (map = (skinProvider = client.method_1582()).method_4654(profile)).containsKey(MinecraftProfileTexture.Type.SKIN)) {
                playerSkinTextures.put(uuid, skinProvider.method_4656((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN));
                continue;
            }
            playerSkinTextures.put(uuid, defaultSkin);
        }
        this.graveAvailabilities = graveAvailabilities;
        this.playerSkinTextures = playerSkinTextures;
        this.page = page;
        this.graveOwners = graveOwners;
        this.searchField = Objects.requireNonNullElseGet(search, StringBuilder::new);
        this.includeAvailable = includeAvailable;
        this.includeClaimed = includeClaimed;
        this.includeDestroyed = includeDestroyed;
        this.showWithoutGrave = showWithoutGrave;
        this.reloadFilters();
        this.textColors = YigdConfig.getConfig().graveSettings.graveRenderSettings.guiTextColors;
    }

    private void reloadFilters() {
        this.filteredPlayers.clear();
        this.filteredPlayerIds.clear();
        for (Map.Entry<UUID, List<Byte>> entry : this.graveAvailabilities.entrySet()) {
            UUID uuid = entry.getKey();
            GameProfile profile = this.graveOwners.get(uuid);
            if (!profile.getName().toLowerCase(Locale.ROOT).startsWith(this.searchField.toString().toLowerCase(Locale.ROOT))) continue;
            int filteredGraves = 0;
            for (byte availability : entry.getValue()) {
                if (availability == 1 && this.includeAvailable) {
                    ++filteredGraves;
                    continue;
                }
                if (availability == 0 && this.includeClaimed) {
                    ++filteredGraves;
                    continue;
                }
                if (availability != -1 || !this.includeDestroyed) continue;
                ++filteredGraves;
            }
            if (filteredGraves <= 0 && !this.showWithoutGrave) continue;
            this.filteredPlayers.put(uuid, filteredGraves);
            this.filteredPlayerIds.add(uuid);
        }
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.field_22787 != null && !this.isTyping && (this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode) || keyCode == 259)) {
            this.method_25419();
            return true;
        }
        if (this.isTyping) {
            String newLetter = GLFW.glfwGetKeyName((int)keyCode, (int)scanCode);
            if (newLetter != null && this.searchField.length() < 16) {
                if (((modifiers & 1) != 0 || (modifiers & 0x10) != 0) && (newLetter = newLetter.toUpperCase(Locale.ROOT)).equals("-")) {
                    newLetter = "_";
                }
                this.searchField.append(newLetter);
            } else if (keyCode == 259 && this.searchField.length() > 0) {
                this.searchField.deleteCharAt(this.searchField.length() - 1);
            } else if (keyCode == 257 || keyCode == 335 || keyCode == 256) {
                this.isTyping = false;
            }
            this.reloadFilters();
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && this.hoveredElement != null) {
            this.mouseIsClicked = true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.mouseIsClicked = false;
        boolean bl = this.isTyping = this.hoveredElement != null && this.hoveredElement.equals("search_bar");
        if (button == 0 && this.hoveredElement != null && this.field_22787 != null) {
            if (this.hoveredElement.equals("left") && this.page > 1) {
                PlayerSelectScreen screen = new PlayerSelectScreen(this.graveOwners.values(), this.graveAvailabilities, this.page - 1, this.searchField, this.includeAvailable, this.includeClaimed, this.includeDestroyed, this.showWithoutGrave);
                this.field_22787.method_1507((class_437)screen);
            } else if (this.hoveredElement.equals("right") && this.filteredPlayers.size() > this.page * 4) {
                PlayerSelectScreen screen = new PlayerSelectScreen(this.graveOwners.values(), this.graveAvailabilities, this.page + 1, this.searchField, this.includeAvailable, this.includeClaimed, this.includeDestroyed, this.showWithoutGrave);
                this.field_22787.method_1507((class_437)screen);
            } else if (this.hoveredElement.equals("include_available")) {
                this.includeAvailable = !this.includeAvailable;
                this.reloadFilters();
            } else if (this.hoveredElement.equals("include_claimed")) {
                this.includeClaimed = !this.includeClaimed;
                this.reloadFilters();
            } else if (this.hoveredElement.equals("include_destroyed")) {
                this.includeDestroyed = !this.includeDestroyed;
                this.reloadFilters();
            } else if (this.hoveredElement.equals("show_zero")) {
                this.showWithoutGrave = !this.showWithoutGrave;
                this.reloadFilters();
            } else if (this.isUuid(this.hoveredElement)) {
                UUID parsedUuid = UUID.fromString(this.hoveredElement);
                class_2540 buf = PacketByteBufs.create();
                buf.method_43616(this.graveOwners.get(parsedUuid));
                ClientPlayNetworking.send((class_2960)PacketIdentifiers.PLAYER_GRAVES_GUI, (class_2540)buf);
            }
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        int screenWidth = 220;
        int screenHeight = 231;
        int originX = this.field_22789 / 2;
        int originY = this.field_22790 / 2;
        int screenLeft = originX - 110;
        int screenTop = originY - 115;
        this.hoveredElement = null;
        RenderSystem.setShaderTexture((int)0, (class_2960)this.GRAVE_SELECT_TEXTURE);
        this.method_25302(matrices, screenLeft, screenTop, 0, 0, 220, 231);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.SELECT_ELEMENT_TEXTURE);
        if (mouseX > screenLeft + 6 && mouseX < screenLeft + 14 && mouseY > originY - 8 && mouseY < originY + 7) {
            this.hoveredElement = "left";
        } else if (mouseX > screenLeft + 220 - 14 && mouseX < screenLeft + 220 - 6 && mouseY > originY - 8 && mouseY < originY + 7) {
            this.hoveredElement = "right";
        }
        if (this.hoveredElement != null && this.hoveredElement.equals("left") && this.mouseIsClicked) {
            this.method_25302(matrices, screenLeft + 6, originY - 8, 16, 84, 8, 15);
        } else {
            this.method_25302(matrices, screenLeft + 6, originY - 8, 0, 84, 8, 15);
        }
        if (this.hoveredElement != null && this.hoveredElement.equals("right") && this.mouseIsClicked) {
            this.method_25302(matrices, screenLeft + 220 - 14, originY - 8, 24, 84, 8, 15);
        } else {
            this.method_25302(matrices, screenLeft + 220 - 14, originY - 8, 8, 84, 8, 15);
        }
        int infoSize = this.filteredPlayerIds.size();
        int startValue = (this.page - 1) * 4;
        int whileLessThan = startValue + Math.min(4, infoSize - startValue);
        for (int i = startValue; i < whileLessThan; ++i) {
            UUID playerId = this.filteredPlayerIds.get(i);
            RenderSystem.setShaderTexture((int)0, (class_2960)this.SELECT_ELEMENT_TEXTURE);
            int left = screenLeft + 19;
            int top = screenTop + 55 + 42 * (i % 4);
            int width = 182;
            int height = 42;
            if (mouseX > left && mouseX < left + width && mouseY > top && mouseY < top + height) {
                this.hoveredElement = playerId.toString();
            }
            if (this.hoveredElement != null && this.hoveredElement.equals(playerId.toString()) && this.mouseIsClicked) {
                this.method_25302(matrices, left, top, 0, height, width, height);
            } else {
                this.method_25302(matrices, left, top, 0, 0, width, height);
            }
            RenderSystem.setShaderTexture((int)0, (class_2960)this.playerSkinTextures.get(playerId));
            this.method_25302(matrices, left + 5, top + 5, 32, 32, 32, 32);
            this.field_22793.method_1729(matrices, this.graveOwners.get(playerId).getName(), (float)(left + 42), (float)(top + 7), this.textColors.playerSelectPlayerName);
            this.field_22793.method_30883(matrices, (class_2561)class_2561.method_43469((String)"text.yigd.gui.player_select.grave_count", (Object[])new Object[]{this.filteredPlayers.get(playerId)}), (float)(left + 42), (float)(top + 22), this.textColors.playerSelectGraveCount);
        }
        super.method_25394(matrices, mouseX, mouseY, delta);
        this.renderCheckButtons(matrices, mouseX, mouseY, screenTop, screenLeft, originX);
        this.renderSearchBar(matrices, screenTop, screenLeft, mouseX, mouseY);
        String gravesDisplayed = startValue + 1 + "-" + whileLessThan + "/" + infoSize;
        this.field_22793.method_30883(matrices, (class_2561)class_2561.method_43471((String)"text.yigd.gui.player_select.players_with_graves"), (float)screenLeft + 19.0f, (float)screenTop + 10.0f, this.textColors.playerSelectTitle);
        int offset = this.field_22793.method_1727(gravesDisplayed);
        this.field_22793.method_1729(matrices, gravesDisplayed, (float)(screenLeft + 220) - 19.0f - (float)offset, (float)screenTop + 10.0f, this.textColors.playerSelectPageView);
    }

    private boolean isUuid(String intString) {
        if (intString == null) {
            return false;
        }
        try {
            UUID.fromString(intString);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void renderCheckButtons(class_4587 matrices, int mouseX, int mouseY, int screenTop, int screenLeft, int originX) {
        int boxTop = screenTop + 22;
        int boxRow = boxTop + 9;
        RenderSystem.setShaderTexture((int)0, (class_2960)this.SELECT_ELEMENT_TEXTURE);
        int leftEdge = screenLeft + 18;
        if (mouseX > leftEdge && mouseX < leftEdge + 6 && mouseY > boxTop && mouseY < boxTop + 6) {
            this.hoveredElement = "include_available";
        }
        if (this.hoveredElement != null && this.hoveredElement.equals("include_available") && this.mouseIsClicked) {
            this.method_25302(matrices, leftEdge, boxTop, 32, 90, 6, 6);
        } else {
            this.method_25302(matrices, leftEdge, boxTop, 32, 84, 6, 6);
        }
        if (this.includeAvailable) {
            this.method_25302(matrices, leftEdge, boxTop, 38, 84, 6, 6);
        }
        this.field_22793.method_30883(matrices, (class_2561)class_2561.method_43471((String)"text.yigd.gui.player_select.include_available"), (float)leftEdge + 8.0f, (float)boxTop - 1.0f, this.textColors.playerSelectIncludeAvailableCheckbox);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.SELECT_ELEMENT_TEXTURE);
        if (mouseX > originX && mouseX < originX + 6 && mouseY > boxTop && mouseY < boxTop + 6) {
            this.hoveredElement = "include_claimed";
        }
        if (this.hoveredElement != null && this.hoveredElement.equals("include_claimed") && this.mouseIsClicked) {
            this.method_25302(matrices, originX, boxTop, 32, 90, 6, 6);
        } else {
            this.method_25302(matrices, originX, boxTop, 32, 84, 6, 6);
        }
        if (this.includeClaimed) {
            this.method_25302(matrices, originX, boxTop, 38, 84, 6, 6);
        }
        this.field_22793.method_30883(matrices, (class_2561)class_2561.method_43471((String)"text.yigd.gui.player_select.include_claimed"), (float)originX + 8.0f, (float)boxTop - 1.0f, this.textColors.playerSelectIncludeClaimedCheckbox);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.SELECT_ELEMENT_TEXTURE);
        if (mouseX > leftEdge && mouseX < leftEdge + 6 && mouseY > boxRow && mouseY < boxRow + 6) {
            this.hoveredElement = "include_destroyed";
        }
        if (this.hoveredElement != null && this.hoveredElement.equals("include_destroyed") && this.mouseIsClicked) {
            this.method_25302(matrices, leftEdge, boxRow, 32, 90, 6, 6);
        } else {
            this.method_25302(matrices, leftEdge, boxRow, 32, 84, 6, 6);
        }
        if (this.includeDestroyed) {
            this.method_25302(matrices, leftEdge, boxRow, 38, 84, 6, 6);
        }
        this.field_22793.method_30883(matrices, (class_2561)class_2561.method_43471((String)"text.yigd.gui.player_select.include_destroyed"), (float)leftEdge + 8.0f, (float)boxRow - 1.0f, this.textColors.playerSelectIncludeDestroyedCheckbox);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.SELECT_ELEMENT_TEXTURE);
        if (mouseX > originX && mouseX < originX + 6 && mouseY > boxRow && mouseY < boxRow + 6) {
            this.hoveredElement = "show_zero";
        }
        if (this.hoveredElement != null && this.hoveredElement.equals("show_zero") && this.mouseIsClicked) {
            this.method_25302(matrices, originX, boxRow, 32, 90, 6, 6);
        } else {
            this.method_25302(matrices, originX, boxRow, 32, 84, 6, 6);
        }
        if (this.showWithoutGrave) {
            this.method_25302(matrices, originX, boxRow, 38, 84, 6, 6);
        }
        this.field_22793.method_30883(matrices, (class_2561)class_2561.method_43471((String)"text.yigd.gui.player_select.show_zero"), (float)originX + 8.0f, (float)boxRow - 1.0f, this.textColors.playerSelectShowZeroCheckbox);
    }

    private void renderSearchBar(class_4587 matrices, int screenTop, int screenLeft, int mouseX, int mouseY) {
        this.field_22793.method_30883(matrices, class_2561.method_30163((String)(this.searchField.toString() + (this.isTyping ? "_" : ""))), (float)(screenLeft + 20), (float)(screenTop + 41), this.textColors.playerSelectSearchBar);
        if (mouseX > screenLeft + 18 && mouseX < screenLeft + 202 && mouseY > screenTop + 39 && mouseY < screenTop + 51) {
            this.hoveredElement = "search_bar";
        }
    }
}

