/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.client.render;

import com.b1n_ry.yigd.Yigd;
import com.b1n_ry.yigd.block.GraveBlock;
import com.b1n_ry.yigd.block.entity.GraveBlockEntity;
import com.b1n_ry.yigd.config.YigdConfig;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2484;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4730;
import net.minecraft.class_5598;
import net.minecraft.class_5599;
import net.minecraft.class_5602;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_5614;
import net.minecraft.class_5819;
import net.minecraft.class_607;
import net.minecraft.class_630;
import net.minecraft.class_827;
import net.minecraft.class_836;

@Environment(value=EnvType.CLIENT)
public class GraveBlockEntityRenderer
implements class_827<GraveBlockEntity> {
    private final class_327 textRenderer;
    private final class_5599 renderLayer;
    private final class_2960 SHADER_TEXTURE = new class_2960("yigd", "textures/shader/glowing.png");
    private static Map<String, String> modelTextures;
    private static class_630 graveModel;
    public static boolean renderGraveGlowing;
    private final YigdConfig savedConfig;

    public GraveBlockEntityRenderer(class_5614.class_5615 ctx) {
        this.textRenderer = ctx.method_32143();
        this.renderLayer = ctx.method_32142();
        this.savedConfig = YigdConfig.getConfig();
        if (GraveBlock.customModel == null || !GraveBlock.customModel.isJsonObject()) {
            class_5610 data = new class_5609().method_32111();
            data.method_32117("Base_Layer", class_5606.method_32108().method_32101(0, 0).method_32097(0.0f, 0.0f, 0.0f, 16.0f, 1.0f, 16.0f).method_32106(false), class_5603.field_27701);
            data.method_32117("grave_base", class_5606.method_32108().method_32101(0, 21).method_32097(2.0f, 1.0f, 10.0f, 12.0f, 2.0f, 5.0f).method_32106(false), class_5603.field_27701);
            data.method_32117("grave_core", class_5606.method_32108().method_32101(0, 28).method_32097(3.0f, 3.0f, 11.0f, 10.0f, 12.0f, 3.0f).method_32106(false), class_5603.field_27701);
            data.method_32117("grave_top", class_5606.method_32108().method_32101(0, 17).method_32097(4.0f, 15.0f, 11.0f, 8.0f, 1.0f, 3.0f).method_32106(false), class_5603.field_27701);
            List<String> modelNames = Arrays.asList("Base_Layer", "grave_base", "grave_core", "grave_top");
            List<String> textureLocations = Arrays.asList("yigd:block/grave", "yigd:block/grave", "yigd:block/grave", "yigd:block/grave");
            modelTextures = new HashMap<String, String>();
            for (int i = 0; i < modelNames.size(); ++i) {
                modelTextures.put(modelNames.get(i), textureLocations.get(i));
            }
            graveModel = data.method_32112(64, 64);
        } else {
            GraveBlockEntityRenderer.reloadCustomModel();
        }
    }

    public static void reloadCustomModel() {
        class_5610 data = new class_5609().method_32111();
        modelTextures = new HashMap<String, String>();
        JsonObject modelObject = GraveBlock.customModel.getAsJsonObject();
        JsonArray textureSize = GraveBlock.customModel.getAsJsonArray("texture_size");
        JsonObject textures = GraveBlock.customModel.getAsJsonObject("textures");
        JsonArray elements = modelObject.getAsJsonArray("elements");
        int i = 0;
        for (JsonElement element : elements) {
            ++i;
            JsonObject o = element.getAsJsonObject();
            JsonObject faces = o.getAsJsonObject("faces");
            float minX = Float.NaN;
            float maxX = Float.NaN;
            float minY = Float.NaN;
            float maxY = Float.NaN;
            String textureName = "";
            for (Map.Entry entry : faces.entrySet()) {
                textureName = ((JsonElement)entry.getValue()).getAsJsonObject().get("texture").getAsString();
                JsonArray uv = ((JsonElement)entry.getValue()).getAsJsonObject().getAsJsonArray("uv");
                float localMinX = Math.min(uv.get(0).getAsFloat(), uv.get(2).getAsFloat());
                float localMaxX = Math.max(uv.get(0).getAsFloat(), uv.get(2).getAsFloat());
                float localMinY = Math.min(uv.get(1).getAsFloat(), uv.get(3).getAsFloat());
                float localMaxY = Math.max(uv.get(1).getAsFloat(), uv.get(3).getAsFloat());
                minX = !Float.isNaN(minX) ? Math.min(minX, localMinX) : localMinX;
                maxX = !Float.isNaN(maxX) ? Math.max(maxX, localMaxX) : localMaxX;
                minY = !Float.isNaN(minY) ? Math.min(minY, localMinY) : localMinY;
                maxY = !Float.isNaN(maxY) ? Math.max(maxY, localMaxY) : localMaxY;
            }
            textureName = textureName.replaceFirst("#", "");
            if (Float.isNaN(minX) || Float.isNaN(minY) || Float.isNaN(maxX) || Float.isNaN(maxY)) continue;
            minX *= textureSize.get(0).getAsFloat() / 16.0f;
            minY *= textureSize.get(1).getAsFloat() / 16.0f;
            JsonArray from = o.getAsJsonArray("from");
            JsonArray to = o.getAsJsonArray("to");
            float x1 = from.get(0).getAsFloat();
            float y1 = from.get(1).getAsFloat();
            float z1 = from.get(2).getAsFloat();
            float x2 = to.get(0).getAsFloat();
            float y2 = to.get(1).getAsFloat();
            float z2 = to.get(2).getAsFloat();
            String name = o.get("name") != null ? o.get("name").getAsString() : "" + i;
            String textureLocation = textures.get(textureName).getAsString();
            modelTextures.put(name, textureLocation);
            data.method_32117(name, class_5606.method_32108().method_32101((int)minX, (int)minY).method_32097(x1, y1, z1, x2 - x1, y2 - y1, z2 - z1), class_5603.method_32091((float)(x1 + x2), (float)(y1 + y2), (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.PI)));
        }
        graveModel = data.method_32112(textureSize.get(0).getAsInt(), textureSize.get(1).getAsInt());
    }

    public class_5598 getSkull() {
        return new class_607(this.renderLayer.method_32072(class_5602.field_27578));
    }

    public void render(GraveBlockEntity blockEntity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        boolean renderText;
        String customName;
        if (!this.savedConfig.graveSettings.graveRenderSettings.useRenderFeatures) {
            return;
        }
        if (blockEntity == null) {
            return;
        }
        class_2350 direction = (class_2350)blockEntity.method_11010().method_11654((class_2769)class_2741.field_12481);
        class_310 client = class_310.method_1551();
        class_2338 pos = blockEntity.method_11016();
        class_2338 under = pos.method_10074();
        class_1937 world = blockEntity.method_10997();
        JsonObject featureRenders = GraveBlock.customModel.getAsJsonObject("features");
        class_1799 headItem = client.field_1724 != null ? (class_1799)client.field_1724.method_31548().field_7548.get(3) : class_1799.field_8037;
        boolean wearingGraveXray = !headItem.method_7960() && class_1890.method_8222((class_1799)headItem).containsKey(Yigd.DEATH_SIGHT);
        boolean withingGlowDistance = client.field_1724 != null && pos.method_19769((class_2374)client.field_1724.method_19538(), (double)this.savedConfig.graveSettings.graveRenderSettings.glowMaxDistance) && !pos.method_19769((class_2374)client.field_1724.method_19538(), (double)this.savedConfig.graveSettings.graveRenderSettings.glowMinDistance);
        boolean canGlow = wearingGraveXray || this.savedConfig.graveSettings.graveRenderSettings.glowingGrave && blockEntity.canGlow() && client.field_1724 != null && blockEntity.getGraveOwner() != null && client.field_1724.method_5667().equals(blockEntity.getGraveOwner().getId()) && withingGlowDistance && !blockEntity.isClaimed();
        GameProfile graveSkull = blockEntity.getGraveSkull();
        if (graveSkull != null && this.savedConfig.graveSettings.graveRenderSettings.renderGraveSkull) {
            JsonObject headRender;
            matrices.method_22903();
            matrices.method_22904(0.5, 0.25, 0.5);
            matrices.method_22907(class_1160.field_20705.method_23214(switch (direction) {
                case class_2350.field_11035 -> 180.0f;
                case class_2350.field_11039 -> 90.0f;
                case class_2350.field_11034 -> 270.0f;
                default -> 0.0f;
            }));
            float midY = 2.0f;
            float midZ = 5.0f;
            float rotX = 90.0f;
            float rotY = 0.0f;
            float rotZ = 0.0f;
            float scaleXY = 1.0f;
            float scaleZ = 0.25f;
            boolean showSkull = false;
            if (featureRenders != null && (headRender = featureRenders.getAsJsonObject("skull")) != null) {
                midY = headRender.get("height").getAsFloat();
                midZ = headRender.get("depth").getAsFloat();
                if (headRender.getAsJsonArray("rotation") != null) {
                    rotX = headRender.getAsJsonArray("rotation").get(0).getAsFloat();
                    rotY = headRender.getAsJsonArray("rotation").get(1).getAsFloat();
                    rotZ = headRender.getAsJsonArray("rotation").get(2).getAsFloat();
                } else {
                    rotX = 0.0f;
                    rotY = 0.0f;
                    rotZ = 0.0f;
                }
                if (headRender.get("scaleFace") != null) {
                    scaleXY = headRender.get("scaleFace").getAsFloat();
                }
                scaleZ = headRender.get("scaleDepth") != null ? headRender.get("scaleDepth").getAsFloat() : 1.0f;
                showSkull = true;
            }
            matrices.method_22904(0.0, (double)(-(4.0f - midY) / 16.0f), (double)(-(8.0f - midZ) / 16.0f));
            matrices.method_22907(new class_1158(rotX, rotY, rotZ, true));
            matrices.method_22905(scaleXY, scaleXY, scaleZ);
            matrices.method_22904(-0.5, -0.25, -0.5);
            if (showSkull) {
                class_5598 skull = this.getSkull();
                class_836.method_32161(null, (float)0.0f, (float)0.0f, (class_4587)matrices, (class_4597)vertexConsumers, (int)light, (class_5598)skull, (class_1921)class_836.method_3578((class_2484.class_2485)class_2484.class_2486.field_11510, (GameProfile)graveSkull));
                if (canGlow) {
                    class_836.method_32161(null, (float)0.0f, (float)0.0f, (class_4587)matrices, (class_4597)vertexConsumers, (int)light, (class_5598)skull, (class_1921)class_1921.method_23287((class_2960)this.SHADER_TEXTURE));
                }
            }
            matrices.method_22909();
        }
        if ((customName = blockEntity.getCustomName()) != null && (renderText = this.savedConfig.graveSettings.graveRenderSettings.renderGraveOwner)) {
            JsonObject textRender;
            matrices.method_22903();
            int width = this.textRenderer.method_1727(customName);
            float scale = 1.0f / (float)width;
            float textWidth = 8.8f;
            float textDepth = 11.0f;
            float textHeight = 9.6f;
            boolean showText = false;
            if (featureRenders != null && (textRender = featureRenders.getAsJsonObject("text")) != null) {
                textWidth = textRender.get("width").getAsFloat();
                textDepth = textRender.get("depth").getAsFloat();
                textHeight = textRender.get("height").getAsFloat();
                showText = true;
            }
            scale *= textWidth / 16.0f;
            switch (direction) {
                case field_11035: {
                    matrices.method_22907(class_1160.field_20705.method_23214(180.0f));
                    matrices.method_22904(-1.0, 0.0, -1.0);
                    break;
                }
                case field_11039: {
                    matrices.method_22907(class_1160.field_20705.method_23214(90.0f));
                    matrices.method_22904(-1.0, 0.0, 0.0);
                    break;
                }
                case field_11034: {
                    matrices.method_22907(class_1160.field_20705.method_23214(270.0f));
                    matrices.method_22904(0.0, 0.0, -1.0);
                }
            }
            matrices.method_22904(0.5, (double)(textHeight / 16.0f), (double)(textDepth / 16.0f - 0.001f));
            matrices.method_22905(-1.0f, -1.0f, 0.0f);
            matrices.method_22905(scale, scale, scale);
            matrices.method_22904((double)(-width) / 2.0, -4.5, 0.0);
            if (showText) {
                this.textRenderer.method_27521(customName, 0.0f, 0.0f, 0xFFFFFF, this.savedConfig.graveSettings.graveRenderSettings.textShadow, matrices.method_23760().method_23761(), vertexConsumers, false, 0, light);
            }
            matrices.method_22909();
        }
        matrices.method_22903();
        switch (direction) {
            case field_11034: {
                matrices.method_22907(class_1160.field_20705.method_23214(270.0f));
                matrices.method_22904(0.0, 0.0, -1.0);
                break;
            }
            case field_11039: {
                matrices.method_22907(class_1160.field_20705.method_23214(90.0f));
                matrices.method_22904(-1.0, 0.0, 0.0);
                break;
            }
            case field_11035: {
                matrices.method_22907(class_1160.field_20705.method_23214(180.0f));
                matrices.method_22904(-1.0, 0.0, -1.0);
            }
        }
        class_2680 blockUnder = null;
        if (world != null) {
            blockUnder = world.method_8320(under);
        }
        if (canGlow) {
            graveModel.method_35745(matrices, (matrix, path, index, cuboid) -> cuboid.method_32089(matrix, vertexConsumers.getBuffer(class_1921.method_23287((class_2960)this.SHADER_TEXTURE)), light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f));
            renderGraveGlowing = true;
        }
        if (this.savedConfig.graveSettings.graveRenderSettings.useSpecialBlockRenderer) {
            for (Map.Entry<String, String> entry : modelTextures.entrySet()) {
                if (entry.getKey().equals("Base_Layer")) continue;
                class_2960 identifier = new class_2960(entry.getValue());
                class_4730 texture = new class_4730(class_1723.field_21668, identifier);
                class_4588 vertexConsumer = texture.method_24145(vertexConsumers, class_1921::method_23576);
                class_630 child = graveModel.method_32086(entry.getKey());
                child.method_22698(matrices, vertexConsumer, light, overlay);
            }
            if (modelTextures.containsKey("Base_Layer")) {
                if (this.savedConfig.graveSettings.graveRenderSettings.adaptRenderer && blockUnder != null && blockUnder.method_26216((class_1922)world, pos)) {
                    class_630 baseLayer = graveModel.method_32086("Base_Layer");
                    class_630.class_628 cuboid2 = baseLayer.method_22700(class_5819.method_43047());
                    float scaleX = cuboid2.field_3648 - cuboid2.field_3645;
                    float scaleZ = cuboid2.field_3646 - cuboid2.field_3643;
                    matrices.method_22904((double)(cuboid2.field_3645 / 16.0f + 5.0E-4f), (double)(cuboid2.field_3647 / 16.0f - 1.0f), (double)(cuboid2.field_3643 / 16.0f + 5.0E-4f));
                    matrices.method_22905(0.999f * (scaleX / 16.0f), 1.0f, 0.999f * (scaleZ / 16.0f));
                    client.method_1541().method_3355(blockUnder, pos, (class_1920)world, matrices, vertexConsumers.getBuffer(class_1921.method_23581()), true, class_5819.method_43047());
                } else {
                    class_2960 identifier = new class_2960(modelTextures.get("Base_Layer"));
                    class_4730 texture = new class_4730(class_1723.field_21668, identifier);
                    class_4588 vertexConsumer = texture.method_24145(vertexConsumers, class_1921::method_23576);
                    graveModel.method_32086("Base_Layer").method_22698(matrices, vertexConsumer, light, overlay);
                }
            }
        }
        matrices.method_22909();
    }

    public boolean isInRenderDistance(GraveBlockEntity blockEntity, class_243 pos) {
        class_310 client = class_310.method_1551();
        double viewDistance = client.field_1769.method_34812();
        class_2338 blockPos = blockEntity.method_11016();
        if (client.field_1724 == null) {
            return false;
        }
        return pos.method_24802((class_2374)new class_243((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260()), (viewDistance + 1.0) * 16.0);
    }

    static {
        renderGraveGlowing = false;
    }
}

