/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.core;

import com.b1n_ry.yigd.Yigd;
import com.b1n_ry.yigd.api.YigdApi;
import com.b1n_ry.yigd.config.PriorityInventoryConfig;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.core.DeadPlayerData;
import com.b1n_ry.yigd.core.DeathInfoManager;
import com.b1n_ry.yigd.core.PacketIdentifiers;
import com.b1n_ry.yigd.core.YigdCommand;
import com.b1n_ry.yigd.item.KeyItem;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class ServerPacketReceivers {
    public static void register() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.CONFIG_UPDATE, (server, player, handler, buf, responseSender) -> {
            if (player == null) {
                return;
            }
            PriorityInventoryConfig normalPriority = (PriorityInventoryConfig)buf.method_10818(PriorityInventoryConfig.class);
            PriorityInventoryConfig robbingPriority = (PriorityInventoryConfig)buf.method_10818(PriorityInventoryConfig.class);
            UUID playerId = player.method_5667();
            Yigd.clientPriorities.put(playerId, normalPriority);
            Yigd.clientRobPriorities.put(playerId, robbingPriority);
            Yigd.LOGGER.info("Priority overwritten for player " + player.method_5476().getString() + ". Normal: " + normalPriority.name() + " / Robbing: " + robbingPriority.name());
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.RESTORE_INVENTORY, (server, player, handler, buf, responseSender) -> {
            if (player == null) {
                return;
            }
            UUID graveOwnerId = buf.method_10790();
            UUID graveId = buf.method_10790();
            class_3222 graveOwner = server.method_3760().method_14602(graveOwnerId);
            if (graveOwner != null) {
                server.execute(() -> YigdCommand.restoreGrave((class_1657)graveOwner, player, graveId));
            } else {
                player.method_7353((class_2561)class_2561.method_43471((String)"text.yigd.message.backup.restore.fail").method_27694(style -> style.method_36139(0xFF0000)), false);
            }
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.DELETE_GRAVE, (server, player, handler, buf, responseSender) -> {
            if (player == null) {
                return;
            }
            UUID graveOwnerId = buf.method_10790();
            UUID graveId = buf.method_10790();
            List<DeadPlayerData> deadPlayerData = DeathInfoManager.INSTANCE.data.get(graveOwnerId);
            if (deadPlayerData == null) {
                return;
            }
            for (DeadPlayerData data : deadPlayerData) {
                if (!data.id.equals(graveId)) continue;
                deadPlayerData.remove(data);
                player.method_7353((class_2561)class_2561.method_43471((String)"text.yigd.message.backup.delete_one"), false);
                break;
            }
            DeathInfoManager.INSTANCE.method_80();
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.ROB_GRAVE, (server, player, handler, buf, responseSender) -> {
            if (player == null) {
                return;
            }
            String ownerName = buf.method_19772();
            UUID ownerId = buf.method_10790();
            UUID graveId = buf.method_10790();
            GameProfile gameProfile = new GameProfile(ownerId, ownerName);
            server.execute(() -> YigdCommand.robGrave(gameProfile, player, graveId));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.GIVE_KEY_ITEM, (server, player, handler, buf, responseSender) -> {
            if (player == null) {
                return;
            }
            UUID userId = buf.method_10790();
            UUID graveId = buf.method_10790();
            KeyItem.giveStackToPlayer((class_1657)player, userId, graveId);
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.SET_GRAVE_LOCK, (server, player, handler, buf, responseSender) -> {
            UUID graveId = buf.method_10790();
            boolean graveLocked = buf.readBoolean();
            if (graveLocked) {
                DeathInfoManager.INSTANCE.unlockedGraves.remove(graveId);
            } else if (!DeathInfoManager.INSTANCE.unlockedGraves.contains(graveId)) {
                DeathInfoManager.INSTANCE.unlockedGraves.add(graveId);
            }
            DeathInfoManager.INSTANCE.method_80();
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.PLAYER_GRAVES_GUI, (server, player, handler, serverBuf, responseSender) -> {
            GameProfile profile = serverBuf.method_43623();
            List<DeadPlayerData> graveData = DeathInfoManager.INSTANCE.data.get(profile.getId());
            if (graveData == null) {
                return;
            }
            class_2540 buf = PacketByteBufs.create();
            buf.method_43616(profile);
            buf.writeInt(graveData.size());
            for (DeadPlayerData grave : graveData) {
                int itemCount = 0;
                for (class_1799 stack : grave.inventory) {
                    if (stack.method_7960()) continue;
                    ++itemCount;
                }
                for (YigdApi yigdApi : Yigd.apiMods) {
                    String modName = yigdApi.getModName();
                    if (!grave.modInventories.containsKey(modName)) continue;
                    itemCount += yigdApi.getInventorySize(grave.modInventories.get(modName));
                }
                int points = grave.xp;
                int i = 0;
                while (points >= 0) {
                    points = i < 16 ? (points -= 2 * i + 7) : (i < 31 ? (points -= 5 * i - 38) : (points -= 9 * i - 158));
                    ++i;
                }
                buf.method_10797(grave.id);
                buf.method_10807(grave.gravePos);
                buf.method_10814(grave.dimensionName);
                buf.writeInt(itemCount);
                buf.writeInt(i - 1);
                buf.writeByte((int)grave.availability);
            }
            responseSender.sendPacket(PacketIdentifiers.PLAYER_GRAVES_GUI, buf);
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.SINGLE_GRAVE_GUI, (server, player, handler, serverBuf, responseSender) -> {
            GameProfile profile = serverBuf.method_43623();
            UUID graveId = serverBuf.method_10790();
            YigdConfig config = YigdConfig.getConfig();
            YigdConfig.GraveKeySettings keySettings = config.utilitySettings.graveKeySettings;
            List<DeadPlayerData> data = DeathInfoManager.INSTANCE.data.get(profile.getId());
            if (data == null) {
                return;
            }
            DeadPlayerData graveData = null;
            for (DeadPlayerData grave : data) {
                if (!grave.id.equals(graveId)) continue;
                graveData = grave;
                break;
            }
            if (graveData == null) {
                return;
            }
            class_2487 graveNbt = graveData.toNbt();
            class_2540 buf = PacketByteBufs.create();
            buf.method_10794(graveNbt);
            buf.writeBoolean(keySettings.enableKeys && keySettings.getFromGui);
            buf.writeBoolean(config.graveSettings.unlockableGraves);
            buf.writeBoolean(config.commandToggles.retrieveGrave && YigdCommand.hasPermission((class_1657)player, "yigd.command.restore"));
            buf.writeBoolean(YigdCommand.hasPermission((class_1657)player, "yigd.command.delete"));
            buf.writeBoolean(config.commandToggles.robGrave && YigdCommand.hasPermission((class_1657)player, "yigd.command.rob"));
            buf.writeBoolean(DeathInfoManager.INSTANCE.unlockedGraves.contains(graveId));
            buf.writeBoolean(config.graveSettings.graveRobbing.tellRobber);
            responseSender.sendPacket(PacketIdentifiers.SINGLE_GRAVE_GUI, buf);
        });
    }
}

